/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.h2.command.Command;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.db.MVTableEngine;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int META_TABLE_TYPE_COUNT = 29;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "MIN_VALUE BIGINT", "MAX_VALUE BIGINT", "IS_CYCLE BIT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START", "CONTAINS_UNCOMMITTED");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            case 28: {
                this.setObjectName("QUERY_STATISTICS");
                columnArray = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME LONG", "MAX_EXECUTION_TIME LONG", "CUMULATIVE_EXECUTION_TIME LONG", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(string).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String string2 = stringArray[i];
            int n2 = string2.indexOf(32);
            if (n2 < 0) {
                n = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                string = string2;
            } else {
                n = DataType.getTypeByName((String)string2.substring((int)(n2 + 1))).type;
                string = string2.substring(0, n2);
            }
            columnArray[i] = new Column(string, n);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private ArrayList<Table> getTablesByName(Session session, String string) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string = StringUtils.toUpperEnglish(string);
        }
        ArrayList<Table> arrayList = this.database.getTableOrViewByName(string);
        for (Table table : session.getLocalTempTables()) {
            if (!table.getName().equals(string)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        Value value3 = this.database.getMode().lowerCaseIdentifiers ? ValueStringIgnoreCase.get(string) : ValueString.get(string);
        if (value != null && database.compare(value3, value) < 0) {
            return false;
        }
        return value2 == null || database.compare(value3, value2) <= 0;
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<Row> generateRows(Session session, SearchRow searchRow, SearchRow searchRow2) {
        Value value = null;
        Value value2 = null;
        if (this.indexColumn >= 0) {
            if (searchRow != null) {
                value = searchRow.getValue(this.indexColumn);
            }
            if (searchRow2 != null) {
                value2 = searchRow2.getValue(this.indexColumn);
            }
        }
        ArrayList<Row> arrayList = New.arrayList();
        String string = this.identifier(this.database.getShortName());
        boolean bl = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    String sequence = this.identifier(table.getName());
                    if (!this.checkIndex(session, sequence, value, value2) || this.hideTable(table, session)) continue;
                    String store = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    String dbException = table.getCreateSQL();
                    if (!bl && dbException != null && dbException.contains("--hide--")) {
                        dbException = "-";
                    }
                    this.add(arrayList, string, this.identifier(table.getSchema().getName()), sequence, table.getTableType(), store, dbException, MetaTable.replaceNullWithEmpty(table.getComment()), "" + table.getMaxDataModificationId(), "" + table.getId(), null, table.getClass().getName(), "" + table.getRowCountApproximation());
                }
                break;
            }
            case 1: {
                ArrayList<Table> arrayList2;
                if (value != null && value2 != null && value.equals(value2)) {
                    String string5 = this.identifier(value.getString());
                    arrayList2 = this.getTablesByName(session, string5);
                } else {
                    arrayList2 = this.getAllTables(session);
                }
                for (Table role : arrayList2) {
                    String csv = this.identifier(role.getName());
                    if (!this.checkIndex(session, csv, value, value2) || this.hideTable(role, session)) continue;
                    Column[] columnArray = role.getColumns();
                    String dbObject3 = this.database.getCompareMode().getName();
                    for (int i = 0; i < columnArray.length; ++i) {
                        Column table = columnArray[i];
                        Sequence sequence = table.getSequence();
                        this.add(arrayList, string, this.identifier(role.getSchema().getName()), csv, this.identifier(table.getName()), String.valueOf(i + 1), table.getDefaultSQL(), table.isNullable() ? "YES" : "NO", "" + DataType.convertTypeToSQLType(table.getType()), "" + table.getPrecisionAsInt(), "" + table.getPrecisionAsInt(), "" + table.getPrecisionAsInt(), "10", "" + table.getScale(), CHARACTER_SET_NAME, dbObject3, this.identifier(DataType.getDataType((int)table.getType()).name), "" + (table.isNullable() ? 1 : 0), "" + (table.getComputed() ? "TRUE" : "FALSE"), "" + table.getSelectivity(), table.getCheckConstraintSQL(session, table.getName()), sequence == null ? null : sequence.getName(), MetaTable.replaceNullWithEmpty(table.getComment()), null);
                    }
                }
                break;
            }
            case 2: {
                ArrayList<Table> arrayList3;
                if (value != null && value2 != null && value.equals(value2)) {
                    String object2 = this.identifier(value.getString());
                    arrayList3 = this.getTablesByName(session, object2);
                } else {
                    arrayList3 = this.getAllTables(session);
                }
                for (Table functionAlias : arrayList3) {
                    String dbObject = this.identifier(functionAlias.getName());
                    if (!this.checkIndex(session, dbObject, value, value2) || this.hideTable(functionAlias, session)) continue;
                    ArrayList<Index> dbException = functionAlias.getIndexes();
                    ArrayList<Constraint> indexColumnArray2 = functionAlias.getConstraints();
                    for (int i = 0; dbException != null && i < dbException.size(); ++i) {
                        Object object;
                        Index index = dbException.get(i);
                        if (index.getCreateSQL() == null) continue;
                        String string2 = null;
                        for (int j = 0; indexColumnArray2 != null && j < indexColumnArray2.size(); ++j) {
                            object = indexColumnArray2.get(j);
                            if (!((Constraint)object).usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (!((Constraint)object).getConstraintType().equals("PRIMARY KEY")) continue;
                                string2 = ((DbObjectBase)object).getName();
                                continue;
                            }
                            string2 = ((DbObjectBase)object).getName();
                        }
                        IndexColumn[] indexColumnArray = index.getIndexColumns();
                        object = index instanceof MultiVersionIndex ? ((MultiVersionIndex)index).getBaseIndex().getClass().getName() : index.getClass().getName();
                        for (int j = 0; j < indexColumnArray.length; ++j) {
                            IndexColumn indexColumn = indexColumnArray[j];
                            Column column = indexColumn.column;
                            this.add(arrayList, new String[]{string, this.identifier(functionAlias.getSchema().getName()), dbObject, index.getIndexType().isUnique() ? "FALSE" : "TRUE", this.identifier(index.getName()), "" + (j + 1), this.identifier(column.getName()), "0", index.getIndexType().isPrimaryKey() ? "TRUE" : "FALSE", index.getIndexType().getSQL(), index.getIndexType().getBelongsToConstraint() ? "TRUE" : "FALSE", "3", (indexColumn.sortType & 1) != 0 ? "D" : "A", "0", "", MetaTable.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), "" + index.getId(), "" + indexColumn.sortType, string2, object});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(arrayList, "TABLE");
                this.add(arrayList, "TABLE LINK");
                this.add(arrayList, "SYSTEM TABLE");
                this.add(arrayList, "VIEW");
                this.add(arrayList, "EXTERNAL");
                break;
            }
            case 5: {
                this.add(arrayList, string);
                break;
            }
            case 6: {
                long indexColumnArray;
                MVTableEngine.Store locale;
                Object string212;
                Object object3;
                for (Setting byArray : this.database.getAllSettings()) {
                    String n = byArray.getStringValue();
                    if (n == null) {
                        n = "" + byArray.getIntValue();
                    }
                    this.add(arrayList, this.identifier(byArray.getName()), n);
                }
                this.add(arrayList, "info.BUILD_ID", "191");
                this.add(arrayList, "info.VERSION_MAJOR", "1");
                this.add(arrayList, "info.VERSION_MINOR", "4");
                this.add(arrayList, "info.VERSION", "" + Constants.getFullVersion());
                if (bl) {
                    object3 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (Object string212 : object3) {
                        this.add(arrayList, "property." + (String)string212, Utils.getProperty((String)string212, ""));
                    }
                }
                this.add(arrayList, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(arrayList, "MODE", this.database.getMode().getName());
                this.add(arrayList, "MULTI_THREADED", this.database.isMultiThreaded() ? "1" : "0");
                this.add(arrayList, "MVCC", this.database.isMultiVersion() ? "TRUE" : "FALSE");
                this.add(arrayList, "QUERY_TIMEOUT", "" + session.getQueryTimeout());
                this.add(arrayList, "RETENTION_TIME", "" + this.database.getRetentionTime());
                this.add(arrayList, "LOG", "" + this.database.getLogMode());
                object3 = New.arrayList();
                HashMap<String, String> user = this.database.getSettings().getSettings();
                for (String table : user.keySet()) {
                    ((ArrayList)object3).add(table);
                }
                Collections.sort(object3);
                Object schema = ((ArrayList)object3).iterator();
                while (schema.hasNext()) {
                    String table = schema.next();
                    this.add(arrayList, table, user.get(table));
                }
                if (!this.database.isPersistent()) break;
                schema = this.database.getPageStore();
                if (schema != null) {
                    this.add(arrayList, "info.FILE_WRITE_TOTAL", "" + ((PageStore)schema).getWriteCountTotal());
                    this.add(arrayList, "info.FILE_WRITE", "" + ((PageStore)schema).getWriteCount());
                    this.add(arrayList, "info.FILE_READ", "" + ((PageStore)schema).getReadCount());
                    this.add(arrayList, "info.PAGE_COUNT", "" + ((PageStore)schema).getPageCount());
                    this.add(arrayList, "info.PAGE_SIZE", "" + ((PageStore)schema).getPageSize());
                    this.add(arrayList, "info.CACHE_MAX_SIZE", "" + ((PageStore)schema).getCache().getMaxMemory());
                    this.add(arrayList, "info.CACHE_SIZE", "" + ((PageStore)schema).getCache().getMemory());
                }
                if ((locale = this.database.getMvStore()) == null) break;
                string212 = locale.getStore().getFileStore();
                this.add(arrayList, "info.FILE_WRITE", "" + ((FileStore)string212).getWriteCount());
                this.add(arrayList, "info.FILE_READ", "" + ((FileStore)string212).getReadCount());
                try {
                    indexColumnArray = ((FileStore)string212).getFile().size();
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, "Can not get size");
                }
                int n = 4096;
                long l = indexColumnArray / (long)n;
                this.add(arrayList, "info.PAGE_COUNT", "" + l);
                this.add(arrayList, "info.PAGE_SIZE", "" + n);
                this.add(arrayList, "info.CACHE_MAX_SIZE", "" + locale.getStore().getCacheSize());
                this.add(arrayList, "info.CACHE_SIZE", "" + locale.getStore().getCacheSizeUsed());
                break;
            }
            case 4: {
                for (DataType role : DataType.getTypes()) {
                    if (role.hidden || role.sqlType == 0) continue;
                    this.add(arrayList, role.name, String.valueOf(role.sqlType), String.valueOf(MathUtils.convertLongToInt(role.maxPrecision)), role.prefix, role.suffix, role.params, String.valueOf(role.autoIncrement), String.valueOf(role.minScale), String.valueOf(role.maxScale), role.decimal ? "10" : null, String.valueOf(role.sqlTypePos), String.valueOf(role.caseSensitive), "1", "3");
                }
                break;
            }
            case 7: {
                String string14 = "/org/h2/res/help.csv";
                try {
                    byte[] right = Utils.getResource(string14);
                    InputStreamReader dbObject = new InputStreamReader(new ByteArrayInputStream(right));
                    Csv tableView = new Csv();
                    tableView.setLineCommentCharacter('#');
                    ResultSet string22 = tableView.read(dbObject, null);
                    boolean session2 = false;
                    while (string22.next()) {
                        void var14_147;
                        this.add(arrayList, String.valueOf((int)var14_147), string22.getString(1).trim(), string22.getString(2).trim(), string22.getString(3).trim(), string22.getString(4).trim());
                        ++var14_147;
                    }
                    break;
                }
                catch (Exception dbObject) {
                    throw DbException.convert(dbObject);
                }
            }
            case 8: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(3)) {
                    Sequence dbObject = (Sequence)schemaObject;
                    this.add(arrayList, string, this.identifier(dbObject.getSchema().getName()), this.identifier(dbObject.getName()), String.valueOf(dbObject.getCurrentValue()), String.valueOf(dbObject.getIncrement()), dbObject.getBelongsToTable() ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(dbObject.getComment()), String.valueOf(dbObject.getCacheSize()), String.valueOf(dbObject.getMinValue()), String.valueOf(dbObject.getMaxValue()), dbObject.getCycle() ? "TRUE" : "FALSE", "" + dbObject.getId());
                }
                break;
            }
            case 9: {
                for (User user : this.database.getAllUsers()) {
                    if (!bl && session.getUser() != user) continue;
                    this.add(arrayList, this.identifier(user.getName()), String.valueOf(user.isAdmin()), MetaTable.replaceNullWithEmpty(user.getComment()), "" + user.getId());
                }
                break;
            }
            case 10: {
                for (Role right : this.database.getAllRoles()) {
                    if (!bl && !session.getUser().isRoleGranted(right)) continue;
                    this.add(arrayList, this.identifier(right.getName()), MetaTable.replaceNullWithEmpty(right.getComment()), "" + right.getId());
                }
                break;
            }
            case 11: {
                if (!bl) break;
                for (Right right : this.database.getAllRights()) {
                    String indexColumnArray;
                    Role role = right.getGrantedRole();
                    DbObject constraintReferential = right.getGrantee();
                    String string3 = indexColumnArray = constraintReferential.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        String string4;
                        DbObject object = right.getGrantedObject();
                        Schema schema = null;
                        DbObjectBase dbObjectBase = null;
                        if (object != null) {
                            if (object instanceof Schema) {
                                schema = (Schema)object;
                            } else if (object instanceof Table) {
                                dbObjectBase = (Table)object;
                                schema = ((SchemaObjectBase)dbObjectBase).getSchema();
                            }
                        }
                        String string5 = dbObjectBase != null ? this.identifier(dbObjectBase.getName()) : "";
                        String string6 = string4 = schema != null ? this.identifier(schema.getName()) : "";
                        if (!this.checkIndex(session, string5, value, value2)) continue;
                        this.add(arrayList, this.identifier(constraintReferential.getName()), indexColumnArray, "", right.getRights(), string4, string5, "" + right.getId());
                        continue;
                    }
                    this.add(arrayList, this.identifier(constraintReferential.getName()), indexColumnArray, this.identifier(role.getName()), "", "", "", "" + right.getId());
                }
                break;
            }
            case 12: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias.JavaMethod[] string26;
                    FunctionAlias string23 = (FunctionAlias)schemaObject;
                    try {
                        string26 = string23.getJavaMethods();
                    }
                    catch (DbException dbException) {
                        string26 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod javaMethod : string26) {
                        int n = javaMethod.getDataType() == 0 ? 1 : 2;
                        this.add(arrayList, string, string23.getSchema().getName(), this.identifier(string23.getName()), string23.getJavaClassName(), string23.getJavaMethodName(), "" + DataType.convertTypeToSQLType(javaMethod.getDataType()), DataType.getDataType((int)javaMethod.getDataType()).name, "" + javaMethod.getParameterCount(), "" + n, MetaTable.replaceNullWithEmpty(string23.getComment()), "" + string23.getId(), string23.getSource());
                    }
                }
                for (UserAggregate userAggregate : this.database.getAllAggregates()) {
                    int inDoubtTransaction = 2;
                    this.add(arrayList, string, "PUBLIC", this.identifier(userAggregate.getName()), userAggregate.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), DataType.getDataType((int)0).name, "1", "" + inDoubtTransaction, MetaTable.replaceNullWithEmpty(userAggregate.getComment()), "" + userAggregate.getId(), "");
                }
                break;
            }
            case 21: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(9)) {
                    FunctionAlias.JavaMethod[] valueExpression;
                    FunctionAlias constraint = (FunctionAlias)schemaObject;
                    try {
                        valueExpression = constraint.getJavaMethods();
                    }
                    catch (DbException value3) {
                        valueExpression = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod javaMethod : valueExpression) {
                        Object object;
                        if (javaMethod.getDataType() != 0) {
                            object = DataType.getDataType(javaMethod.getDataType());
                            this.add(arrayList, string, constraint.getSchema().getName(), this.identifier(constraint.getName()), constraint.getJavaClassName(), constraint.getJavaMethodName(), "" + javaMethod.getParameterCount(), "0", "P0", "" + DataType.convertTypeToSQLType(javaMethod.getDataType()), object.name, "" + MathUtils.convertLongToInt(object.defaultPrecision), "" + object.defaultScale, "10", "2", "5", "", null);
                        }
                        object = javaMethod.getColumnClasses();
                        for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                            if (javaMethod.hasConnectionParam() && i == 0) continue;
                            Class<?> clazz = object[i];
                            int n = DataType.getTypeFromClass(clazz);
                            DataType dataType = DataType.getDataType(n);
                            int n2 = clazz.isPrimitive() ? 0 : 1;
                            this.add(arrayList, string, constraint.getSchema().getName(), this.identifier(constraint.getName()), constraint.getJavaClassName(), constraint.getJavaMethodName(), "" + javaMethod.getParameterCount(), "" + (i + (javaMethod.hasConnectionParam() ? 0 : 1)), "P" + (i + 1), "" + DataType.convertTypeToSQLType(dataType.type), dataType.name, "" + MathUtils.convertLongToInt(dataType.defaultPrecision), "" + dataType.defaultScale, "10", "" + n2, "1", "", null);
                        }
                    }
                }
                break;
            }
            case 13: {
                String string20 = this.database.getCompareMode().getName();
                for (Schema constraint : this.database.getAllSchemas()) {
                    this.add(arrayList, string, this.identifier(constraint.getName()), this.identifier(constraint.getOwner().getName()), CHARACTER_SET_NAME, string20, "PUBLIC".equals(constraint.getName()) ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(constraint.getComment()), "" + constraint.getId());
                }
                break;
            }
            case 14: {
                for (Right schemaObject : this.database.getAllRights()) {
                    String string7;
                    Table table;
                    DbObject constant = schemaObject.getGrantedObject();
                    if (!(constant instanceof Table) || (table = (Table)constant) == null || this.hideTable(table, session) || !this.checkIndex(session, string7 = this.identifier(table.getName()), value, value2)) continue;
                    this.addPrivileges(arrayList, schemaObject.getGrantee(), string, table, null, schemaObject.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right userDataType : this.database.getAllRights()) {
                    String string8;
                    Table table;
                    DbObject column = userDataType.getGrantedObject();
                    if (!(column instanceof Table) || (table = (Table)column) == null || this.hideTable(table, session) || !this.checkIndex(session, string8 = this.identifier(table.getName()), value, value2)) continue;
                    DbObject dbObject = userDataType.getGrantee();
                    int n = userDataType.getRightMask();
                    for (Column column2 : table.getColumns()) {
                        this.addPrivileges(arrayList, dbObject, string, table, column2.getName(), n);
                    }
                }
                break;
            }
            case 16: {
                for (Locale session3 : Collator.getAvailableLocales()) {
                    this.add(arrayList, CompareMode.getName(session3), session3.toString());
                }
                break;
            }
            case 17: {
                for (Table table : this.getAllTables(session)) {
                    String string9;
                    if (!table.getTableType().equals("VIEW") || !this.checkIndex(session, string9 = this.identifier(table.getName()), value, value2)) continue;
                    TableView string31 = (TableView)table;
                    this.add(arrayList, string, this.identifier(table.getSchema().getName()), string9, table.getCreateSQL(), "NONE", "NO", string31.isInvalid() ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(string31.getComment()), "" + string31.getId());
                }
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> arrayList6 = this.database.getInDoubtTransactions();
                if (arrayList6 == null || !bl) break;
                for (InDoubtTransaction inDoubtTransaction : arrayList6) {
                    this.add(arrayList, inDoubtTransaction.getTransactionName(), inDoubtTransaction.getState());
                }
                break;
            }
            case 19: {
                for (SchemaObject table : this.database.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)table;
                    if (!constraint.getConstraintType().equals("REFERENTIAL")) continue;
                    ConstraintReferential constraintReferential = (ConstraintReferential)constraint;
                    IndexColumn[] indexColumnArray = constraintReferential.getColumns();
                    IndexColumn[] indexColumnArray2 = constraintReferential.getRefColumns();
                    Table table2 = constraintReferential.getTable();
                    Table table3 = constraintReferential.getRefTable();
                    String string10 = this.identifier(table3.getName());
                    if (!this.checkIndex(session, string10, value, value2)) continue;
                    int n = MetaTable.getRefAction(constraintReferential.getUpdateAction());
                    int n3 = MetaTable.getRefAction(constraintReferential.getDeleteAction());
                    for (int i = 0; i < indexColumnArray.length; ++i) {
                        this.add(arrayList, string, this.identifier(table3.getSchema().getName()), this.identifier(table3.getName()), this.identifier(indexColumnArray2[i].column.getName()), string, this.identifier(table2.getSchema().getName()), this.identifier(table2.getName()), this.identifier(indexColumnArray[i].column.getName()), String.valueOf(i + 1), String.valueOf(n), String.valueOf(n3), this.identifier(constraintReferential.getName()), this.identifier(constraintReferential.getUniqueIndex().getName()), "7");
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject statementBuilder : this.database.getAllSchemaObjects(5)) {
                    void var14_153;
                    String string11;
                    Constraint constraint = (Constraint)statementBuilder;
                    String string12 = constraint.getConstraintType();
                    String string13 = null;
                    Object var14_154 = null;
                    Table table = constraint.getTable();
                    if (this.hideTable(table, session)) continue;
                    Index index = constraint.getUniqueIndex();
                    String string14 = null;
                    if (index != null) {
                        string14 = index.getName();
                    }
                    if (!this.checkIndex(session, string11 = this.identifier(table.getName()), value, value2)) continue;
                    if (string12.equals("CHECK")) {
                        string13 = ((ConstraintCheck)constraint).getExpression().getSQL();
                    } else if (string12.equals("UNIQUE") || string12.equals("PRIMARY KEY")) {
                        IndexColumn[] indexColumnArray = ((ConstraintUnique)constraint).getColumns();
                    } else if (string12.equals("REFERENTIAL")) {
                        IndexColumn[] indexColumnArray = ((ConstraintReferential)constraint).getColumns();
                    }
                    String string15 = null;
                    if (var14_153 != null) {
                        StatementBuilder statementBuilder2 = new StatementBuilder();
                        for (void var24_214 : var14_153) {
                            statementBuilder2.appendExceptFirst(",");
                            statementBuilder2.append(var24_214.column.getName());
                        }
                        string15 = statementBuilder2.toString();
                    }
                    this.add(arrayList, string, this.identifier(constraint.getSchema().getName()), this.identifier(constraint.getName()), string12, string, this.identifier(table.getSchema().getName()), string11, string14, string13, string15, MetaTable.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), "" + constraint.getId());
                }
                break;
            }
            case 22: {
                for (SchemaObject string30 : this.database.getAllSchemaObjects(11)) {
                    Constant queryEntry = (Constant)string30;
                    ValueExpression valueExpression = queryEntry.getValue();
                    this.add(arrayList, string, this.identifier(queryEntry.getSchema().getName()), this.identifier(queryEntry.getName()), "" + DataType.convertTypeToSQLType(valueExpression.getType()), MetaTable.replaceNullWithEmpty(queryEntry.getComment()), valueExpression.getSQL(), "" + queryEntry.getId());
                }
                break;
            }
            case 23: {
                for (UserDataType userDataType : this.database.getAllUserDataTypes()) {
                    Column column = userDataType.getColumn();
                    this.add(arrayList, string, "PUBLIC", this.identifier(userDataType.getName()), column.getDefaultSQL(), column.isNullable() ? "YES" : "NO", "" + column.getDataType().sqlType, "" + column.getPrecisionAsInt(), "" + column.getScale(), column.getDataType().name, "" + column.getSelectivity(), "" + column.getCheckConstraintSQL(session, "VALUE"), MetaTable.replaceNullWithEmpty(userDataType.getComment()), "" + userDataType.getCreateSQL(), "" + userDataType.getId());
                }
                break;
            }
            case 24: {
                for (SchemaObject schemaObject : this.database.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)schemaObject;
                    Table table = triggerObject.getTable();
                    this.add(arrayList, string, this.identifier(triggerObject.getSchema().getName()), this.identifier(triggerObject.getName()), triggerObject.getTypeNameList(), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), "" + triggerObject.isBefore(), triggerObject.getTriggerClassName(), "" + triggerObject.getQueueSize(), "" + triggerObject.isNoWait(), MetaTable.replaceNullWithEmpty(triggerObject.getComment()), triggerObject.getCreateSQL(), "" + triggerObject.getId());
                }
                break;
            }
            case 25: {
                long l = System.currentTimeMillis();
                for (Session session2 : this.database.getSessions(false)) {
                    if (!bl && session2 != session) continue;
                    Command command = session2.getCurrentCommand();
                    long l2 = session2.getCurrentCommandStart();
                    if (l2 == 0L) {
                        l2 = l;
                    }
                    this.add(arrayList, "" + session2.getId(), session2.getUser().getName(), new Timestamp(session2.getSessionStart()).toString(), command == null ? null : command.toString(), new Timestamp(l2).toString(), "" + session2.containsUncommitted());
                }
                break;
            }
            case 26: {
                for (Session session3 : this.database.getSessions(false)) {
                    if (!bl && session3 != session) continue;
                    for (Table table : session3.getLocks()) {
                        this.add(arrayList, table.getSchema().getName(), table.getName(), "" + session3.getId(), table.isLockedExclusivelyBy(session3) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                String string16;
                for (String string17 : session.getVariableNames()) {
                    Value value3 = session.getVariable(string17);
                    this.add(arrayList, "@" + string17, "SET @" + string17 + " " + value3.getSQL());
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(arrayList, "TABLE " + table.getName(), table.getCreateSQL());
                }
                String[] stringArray = session.getSchemaSearchPath();
                if (stringArray != null && stringArray.length > 0) {
                    StatementBuilder statementBuilder = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (Object object : stringArray) {
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(StringUtils.quoteIdentifier((String)object));
                    }
                    this.add(arrayList, "SCHEMA_SEARCH_PATH", statementBuilder.toString());
                }
                if ((string16 = session.getCurrentSchemaName()) == null) break;
                this.add(arrayList, "SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(string16));
                break;
            }
            case 28: {
                QueryStatisticsData queryStatisticsData = this.database.getQueryStatisticsData();
                if (queryStatisticsData == null) break;
                for (QueryStatisticsData.QueryEntry queryEntry : queryStatisticsData.getQueries()) {
                    this.add(arrayList, queryEntry.sqlStatement, "" + queryEntry.count, "" + queryEntry.executionTimeMin, "" + queryEntry.executionTimeMax, "" + queryEntry.executionTimeCumulative, "" + queryEntry.executionTimeMean, "" + queryEntry.getExecutionTimeStandardDeviation(), "" + queryEntry.rowCountMin, "" + queryEntry.rowCountMax, "" + queryEntry.rowCountCumulative, "" + queryEntry.rowCountMean, "" + queryEntry.getRowCountStandardDeviation());
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return arrayList;
    }

    private static int getRefAction(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + n);
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string3, string4);
        } else {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string2), string3, string4);
        }
    }

    private void add(ArrayList<Row> arrayList, String ... stringArray) {
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            Column column = this.columns[i];
            value = column.convert(value);
            valueArray[i] = value;
        }
        Row row = this.database.createRow(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public String getTableType() {
        return "SYSTEM TABLE";
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> arrayList = New.arrayList();
        if (this.metaIndex == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 29;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

