/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.crypto;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;

public class CustomMessageDigestDetector
implements Detector {
    private static final String CUSTOM_MESSAGE_DIGEST_TYPE = "CUSTOM_MESSAGE_DIGEST";
    private BugReporter bugReporter;

    public CustomMessageDigestDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if ("java.security.MessageDigest".equals(javaClass.getSuperclassName())) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, CUSTOM_MESSAGE_DIGEST_TYPE, 2).addClass(javaClass));
        }
    }

    public void report() {
    }
}

