/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.injection.smtp;

import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import edu.umd.cs.findbugs.BugReporter;

public class SmtpHeaderInjectionDetector
extends BasicInjectionDetector {
    public SmtpHeaderInjectionDetector(BugReporter bugReporter) {
        super(bugReporter);
        this.loadConfiguredSinks("smtp.txt", "SMTP_HEADER_INJECTION");
    }

    @Override
    protected int getPriority(Taint taint) {
        if (!taint.isSafe()) {
            boolean newLineSafe = taint.hasTag(Taint.Tag.CR_ENCODED) && taint.hasTag(Taint.Tag.LF_ENCODED);
            boolean urlSafe = taint.hasTag(Taint.Tag.URL_ENCODED);
            if (newLineSafe || urlSafe) {
                return 5;
            }
        }
        if (taint.isTainted()) {
            return 1;
        }
        if (!taint.isSafe()) {
            return 2;
        }
        return 5;
    }
}

