/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import net.schmizz.sshj.transport.Decoder;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.TransportImpl;
import org.slf4j.Logger;

public final class Reader
extends Thread {
    private final Logger log;
    private final TransportImpl trans;

    public Reader(TransportImpl trans) {
        this.trans = trans;
        this.log = trans.getConfig().getLoggerFactory().getLogger(this.getClass());
        this.setName("reader");
    }

    @Override
    public void run() {
        block6: {
            try {
                Decoder decoder = this.trans.getDecoder();
                InputStream inp = this.trans.getConnInfo().in;
                byte[] recvbuf = new byte[decoder.getMaxPacketLength()];
                int needed = 1;
                while (!this.isInterrupted()) {
                    int read;
                    try {
                        read = inp.read(recvbuf, 0, needed);
                    }
                    catch (SocketTimeoutException e) {
                        if (!this.isInterrupted()) continue;
                        throw e;
                    }
                    if (read == -1) {
                        throw new TransportException("Broken transport; encountered EOF");
                    }
                    needed = decoder.received(recvbuf, read);
                }
            }
            catch (Exception e) {
                if (this.isInterrupted()) break block6;
                this.trans.die(e);
            }
        }
        this.log.debug("Stopping");
    }
}

