/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.compression;

import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.GZIPException;
import com.jcraft.jzlib.Inflater;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.compression.Compression;

public class ZlibCompression
implements Compression {
    private static final int BUF_SIZE = 4096;
    private final byte[] tempBuf = new byte[4096];
    private Deflater deflater;
    private Inflater inflater;

    @Override
    public void init(Compression.Mode mode) {
        try {
            switch (mode) {
                case DEFLATE: {
                    this.deflater = new Deflater(-1);
                    break;
                }
                case INFLATE: {
                    this.inflater = new Inflater();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (GZIPException gZIPException) {
            // empty catch block
        }
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public void compress(Buffer buffer) {
        this.deflater.setNextIn(buffer.array());
        this.deflater.setNextInIndex(buffer.rpos());
        this.deflater.setAvailIn(buffer.available());
        buffer.wpos(buffer.rpos());
        do {
            this.deflater.setNextOut(this.tempBuf);
            this.deflater.setNextOutIndex(0);
            this.deflater.setAvailOut(4096);
            int status = this.deflater.deflate(1);
            if (status != 0) {
                throw new SSHRuntimeException("compress: deflate returned " + status);
            }
            buffer.putRawBytes(this.tempBuf, 0, 4096 - this.deflater.getAvailOut());
        } while (this.deflater.getAvailOut() == 0);
    }

    @Override
    public void uncompress(Buffer from, Buffer to) throws TransportException {
        int status;
        this.inflater.setNextIn(from.array());
        this.inflater.setNextInIndex(from.rpos());
        this.inflater.setAvailIn(from.available());
        block4: while (true) {
            this.inflater.setNextOut(this.tempBuf);
            this.inflater.setNextOutIndex(0);
            this.inflater.setAvailOut(4096);
            status = this.inflater.inflate(1);
            switch (status) {
                case 0: {
                    to.putRawBytes(this.tempBuf, 0, 4096 - this.inflater.getAvailOut());
                    continue block4;
                }
                case -5: {
                    return;
                }
            }
            break;
        }
        throw new TransportException(DisconnectReason.COMPRESSION_ERROR, "uncompress: inflate returned " + status);
    }

    public static class Factory
    implements Factory.Named<Compression> {
        @Override
        public Compression create() {
            return new ZlibCompression();
        }

        @Override
        public String getName() {
            return "zlib";
        }
    }
}

