/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.common.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ClassLoaderAwareInvocationHandler
implements InvocationHandler {
    private final ClassLoader classLoader;
    private final Object actualObject;

    public ClassLoaderAwareInvocationHandler(ClassLoader classLoader, Object actualObject) {
        this.classLoader = classLoader;
        this.actualObject = actualObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = method.invoke(this.actualObject, args);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

