/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SchemaFieldQuery {
    private final String name;
    private final String namespace;
    private final String type;

    public SchemaFieldQuery(String name, String namespace, String type) {
        this.name = name;
        this.namespace = namespace;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> toQueryMap() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (this.name != null) {
            queryMap.put("name", this.name);
        }
        if (this.namespace != null) {
            queryMap.put("fieldNamespace", this.namespace);
        }
        if (this.type != null) {
            queryMap.put("type", this.type);
        }
        return Collections.unmodifiableMap(queryMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaFieldQuery that = (SchemaFieldQuery)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.type);
    }

    public String toString() {
        return "SchemaFieldQuery{name='" + this.name + '\'' + ", namespace='" + this.namespace + '\'' + ", type='" + this.type + '\'' + '}';
    }

    public static class Builder {
        private String name;
        private String namespace;
        private String type;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public SchemaFieldQuery build() {
            return new SchemaFieldQuery(this.name, this.namespace, this.type);
        }
    }
}

