/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.avro;

import com.google.common.base.Joiner;
import com.hortonworks.registries.schemaregistry.AbstractSchemaProvider;
import com.hortonworks.registries.schemaregistry.CompatibilityResult;
import com.hortonworks.registries.schemaregistry.SchemaCompatibility;
import com.hortonworks.registries.schemaregistry.SchemaFieldInfo;
import com.hortonworks.registries.schemaregistry.avro.AvroFieldsGenerator;
import com.hortonworks.registries.schemaregistry.avro.AvroSchemaResolver;
import com.hortonworks.registries.schemaregistry.avro.AvroSchemaValidator;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaProvider.class);
    public static final String TYPE = "avro";

    @Override
    public String getName() {
        return "Avro schema provider";
    }

    @Override
    public String getDescription() {
        return "This provider supports avro schemas. You can find more information about avro at http://avro.apache.org";
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public CompatibilityResult checkCompatibility(String toSchemaText, String existingSchemaText, SchemaCompatibility existingSchemaCompatibility) {
        return AvroSchemaValidator.of(existingSchemaCompatibility).validate(new Schema.Parser().parse(toSchemaText), new Schema.Parser().parse(existingSchemaText));
    }

    @Override
    public byte[] getFingerprint(String schemaText) throws InvalidSchemaException, SchemaNotFoundException {
        try {
            Schema schema = new Schema.Parser().parse(this.getResultantSchema(schemaText));
            return MessageDigest.getInstance("MD5").digest(this.normalize(schema).getBytes());
        }
        catch (IOException e) {
            throw new InvalidSchemaException("Given schema is invalid", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getResultantSchema(String schemaText) throws InvalidSchemaException, SchemaNotFoundException {
        AvroSchemaResolver avroSchemaResolver = new AvroSchemaResolver(this.getSchemaVersionRetriever());
        return avroSchemaResolver.resolveSchema(schemaText);
    }

    @Override
    public List<SchemaFieldInfo> generateFields(String schemaText) throws InvalidSchemaException, SchemaNotFoundException {
        AvroFieldsGenerator avroFieldsGenerator = new AvroFieldsGenerator();
        return avroFieldsGenerator.generateFields(new Schema.Parser().parse(this.getResultantSchema(schemaText)));
    }

    public String normalize(Schema schema) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        return AvroSchemaProvider.build(env, schema, sb).toString();
    }

    private static Appendable build(Map<String, String> env, Schema schema, Appendable appendable) throws IOException {
        boolean firstTime = true;
        Schema.Type schemaType = schema.getType();
        String fullName = schema.getFullName();
        switch (schemaType) {
            default: {
                return appendable.append('\"').append(schemaType.getName()).append('\"');
            }
            case UNION: {
                appendable.append('[');
                for (Schema b : schema.getTypes()) {
                    if (!firstTime) {
                        appendable.append(',');
                    } else {
                        firstTime = false;
                    }
                    AvroSchemaProvider.build(env, b, appendable);
                }
                return appendable.append(']');
            }
            case ARRAY: 
            case MAP: {
                appendable.append("{\"type\":\"").append(schemaType.getName()).append("\"");
                if (schemaType == Schema.Type.ARRAY) {
                    AvroSchemaProvider.build(env, schema.getElementType(), appendable.append(",\"items\":"));
                } else {
                    AvroSchemaProvider.build(env, schema.getValueType(), appendable.append(",\"values\":"));
                }
                return appendable.append("}");
            }
            case ENUM: {
                if (env.get(fullName) != null) {
                    return appendable.append(env.get(fullName));
                }
                AvroSchemaProvider.addNameType(env, appendable, schemaType, fullName);
                appendable.append(",\"symbols\":[");
                for (String enumSymbol : schema.getEnumSymbols()) {
                    if (!firstTime) {
                        appendable.append(',');
                    } else {
                        firstTime = false;
                    }
                    appendable.append('\"').append(enumSymbol).append('\"');
                }
                return appendable.append("]").append("}");
            }
            case FIXED: {
                if (env.get(fullName) != null) {
                    return appendable.append(env.get(fullName));
                }
                AvroSchemaProvider.addNameType(env, appendable, schemaType, fullName);
                return appendable.append(",\"size\":").append(Integer.toString(schema.getFixedSize())).append("}");
            }
            case RECORD: 
        }
        if (env.get(fullName) != null) {
            return appendable.append(env.get(fullName));
        }
        AvroSchemaProvider.addNameType(env, appendable, schemaType, fullName);
        Set aliases = schema.getAliases();
        if (aliases != null && !aliases.isEmpty()) {
            appendable.append("\"aliases\":").append("[").append(Joiner.on((String)",").join((Iterable)aliases.stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()))).append("]").append(",");
        }
        appendable.append(",\"fields\":[");
        for (Schema.Field field : schema.getFields()) {
            if (!firstTime) {
                appendable.append(',');
            } else {
                firstTime = false;
            }
            appendable.append("{\"name\":\"").append(field.name()).append("\"").append(",\"type\":");
            Object defaultValue = field.defaultVal();
            if (defaultValue != null) {
                appendable.append(defaultValue.toString());
            }
            AvroSchemaProvider.build(env, field.schema(), appendable).append("}");
        }
        return appendable.append("]").append("}");
    }

    private static void addNameType(Map<String, String> env, Appendable appendable, Schema.Type schemaType, String name) throws IOException {
        String qname = "\"" + name + "\"";
        env.put(name, qname);
        appendable.append("{\"name\":").append(qname);
        appendable.append(",\"type\":\"").append(schemaType.getName()).append("\"");
    }
}

