/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.cache;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.hortonworks.registries.schemaregistry.SchemaBranch;
import com.hortonworks.registries.schemaregistry.SchemaBranchKey;
import com.hortonworks.registries.schemaregistry.cache.AbstractCache;
import com.hortonworks.registries.schemaregistry.cache.SchemaRegistryCacheType;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchNotFoundException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaBranchCache
implements AbstractCache {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaBranchCache.class);
    private final LoadingCache<Key, SchemaBranch> loadingCache;
    private final BiMap<SchemaBranchKey, Long> schemaBranchNameToIdMap = Maps.synchronizedBiMap((BiMap)HashBiMap.create());

    public SchemaBranchCache(Integer size, Long expiryInSecs, final SchemaBranchFetcher schemaBranchFetcher) {
        this.loadingCache = CacheBuilder.newBuilder().maximumSize((long)size.intValue()).expireAfterAccess(expiryInSecs.longValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Key, SchemaBranch>(){

            public SchemaBranch load(Key key) throws Exception {
                Key otherKey;
                SchemaBranch schemaBranch;
                if (key.getSchemaBranchKey() != null) {
                    schemaBranch = schemaBranchFetcher.getSchemaBranch(key.getSchemaBranchKey());
                    otherKey = Key.of(schemaBranch.getId());
                    SchemaBranchCache.this.schemaBranchNameToIdMap.put((Object)key.getSchemaBranchKey(), (Object)schemaBranch.getId());
                } else if (key.getId() != null) {
                    schemaBranch = schemaBranchFetcher.getSchemaBranch(key.getId());
                    otherKey = Key.of(new SchemaBranchKey(schemaBranch.getName(), schemaBranch.getSchemaMetadataName()));
                    SchemaBranchCache.this.schemaBranchNameToIdMap.put((Object)otherKey.schemaBranchKey, (Object)schemaBranch.getId());
                } else {
                    throw new IllegalArgumentException("Given argument is not valid: " + key);
                }
                SchemaBranchCache.this.loadingCache.put((Object)otherKey, (Object)schemaBranch);
                return schemaBranch;
            }
        });
    }

    public SchemaBranch get(Key key) throws SchemaBranchNotFoundException {
        SchemaBranch schemaBranch;
        try {
            schemaBranch = (SchemaBranch)this.loadingCache.get((Object)key);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SchemaBranchNotFoundException) {
                throw (SchemaBranchNotFoundException)cause;
            }
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            LOG.error("Error occurred while retrieving schema branch for [{}]", (Object)key, (Object)e);
            throw new RuntimeException(e);
        }
        return schemaBranch;
    }

    public void put(Key key, SchemaBranch schemaBranch) {
        this.loadingCache.put((Object)key, (Object)schemaBranch);
    }

    public SchemaBranch getIfPresent(Key key) {
        return (SchemaBranch)this.loadingCache.getIfPresent((Object)key);
    }

    public void invalidateSchemaBranch(Key key) {
        LOG.info("Invalidating cache entry for key [{}]", (Object)key);
        if (this.loadingCache.getIfPresent((Object)key) == null) {
            return;
        }
        this.loadingCache.invalidate((Object)key);
        Key otherKey = key.id == null ? Key.of((Long)this.schemaBranchNameToIdMap.get((Object)key.getSchemaBranchKey())) : Key.of((SchemaBranchKey)this.schemaBranchNameToIdMap.inverse().get((Object)key.id));
        this.loadingCache.invalidate((Object)otherKey);
    }

    public void invalidateAll() {
        LOG.info("Invalidating all the cache entries");
        this.loadingCache.invalidateAll();
    }

    @Override
    public SchemaRegistryCacheType getCacheType() {
        return SchemaRegistryCacheType.SCHEMA_BRANCH_CACHE;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Key {
        @JsonProperty
        private SchemaBranchKey schemaBranchKey;
        @JsonProperty
        private Long id;

        private Key(SchemaBranchKey schemaBranchKey) {
            Preconditions.checkNotNull((Object)schemaBranchKey, (Object)"schemaBranchKey can not be null");
            this.schemaBranchKey = schemaBranchKey;
        }

        private Key(Long id) {
            Preconditions.checkNotNull((Object)id, (Object)"id can not be null");
            this.id = id;
        }

        private Key() {
        }

        public SchemaBranchKey getSchemaBranchKey() {
            return this.schemaBranchKey;
        }

        public Long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.schemaBranchKey != null ? !this.schemaBranchKey.equals(key.schemaBranchKey) : key.schemaBranchKey != null) {
                return false;
            }
            return this.id != null ? this.id.equals(key.id) : key.id == null;
        }

        public int hashCode() {
            int result = this.schemaBranchKey != null ? this.schemaBranchKey.hashCode() : 0;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }

        public static Key of(SchemaBranchKey schemaBranchKey) {
            return new Key(schemaBranchKey);
        }

        public static Key of(Long id) {
            return new Key(id);
        }
    }

    public static interface SchemaBranchFetcher {
        public SchemaBranch getSchemaBranch(SchemaBranchKey var1) throws SchemaBranchNotFoundException;

        public SchemaBranch getSchemaBranch(Long var1) throws SchemaBranchNotFoundException;
    }
}

