/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.cache;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.SchemaVersionRetriever;
import com.hortonworks.registries.schemaregistry.cache.AbstractCache;
import com.hortonworks.registries.schemaregistry.cache.SchemaRegistryCacheType;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaVersionInfoCache
implements AbstractCache {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaVersionInfoCache.class);
    private final LoadingCache<Key, SchemaVersionInfo> loadingCache;
    private final ConcurrentMap<SchemaIdVersion, SchemaVersionKey> idWithNameVersion;
    private final ConcurrentMap<SchemaVersionKey, List<SchemaIdVersion>> nameVersionWithIds;

    public SchemaVersionInfoCache(SchemaVersionRetriever schemaRetriever, int schemaCacheSize, long schemaCacheExpiryInMilliSecs) {
        this.idWithNameVersion = new ConcurrentHashMap<SchemaIdVersion, SchemaVersionKey>(schemaCacheSize);
        this.nameVersionWithIds = new ConcurrentHashMap<SchemaVersionKey, List<SchemaIdVersion>>(schemaCacheSize);
        this.loadingCache = this.createLoadingCache(schemaRetriever, schemaCacheSize, schemaCacheExpiryInMilliSecs);
    }

    private LoadingCache<Key, SchemaVersionInfo> createLoadingCache(final SchemaVersionRetriever schemaRetriever, int schemaCacheSize, long schemaCacheExpiryInMilliSecs) {
        return CacheBuilder.newBuilder().maximumSize((long)schemaCacheSize).expireAfterAccess(schemaCacheExpiryInMilliSecs, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<Key, SchemaVersionInfo>(){

            public SchemaVersionInfo load(Key key) throws Exception {
                SchemaVersionInfo schemaVersionInfo;
                LOG.info("Loading entry for cache with key [{}] from target service", (Object)key);
                if (key.schemaVersionKey != null) {
                    schemaVersionInfo = schemaRetriever.retrieveSchemaVersion(key.schemaVersionKey);
                } else if (key.schemaIdVersion != null) {
                    schemaVersionInfo = schemaRetriever.retrieveSchemaVersion(key.schemaIdVersion);
                } else {
                    throw new IllegalArgumentException("Given argument is not valid: " + key);
                }
                SchemaVersionInfoCache.this.updateCacheInvalidationEntries(schemaVersionInfo);
                return schemaVersionInfo;
            }
        });
    }

    private void updateCacheInvalidationEntries(SchemaVersionInfo schemaVersionInfo) {
        SchemaVersionKey schemaVersionKey = new SchemaVersionKey(schemaVersionInfo.getName(), schemaVersionInfo.getVersion());
        SchemaIdVersion key1 = new SchemaIdVersion(schemaVersionInfo.getId());
        this.idWithNameVersion.putIfAbsent(key1, schemaVersionKey);
        Long schemaMetadataId = schemaVersionInfo.getSchemaMetadataId();
        if (schemaMetadataId != null) {
            SchemaIdVersion key2 = new SchemaIdVersion(schemaMetadataId, schemaVersionInfo.getVersion());
            this.nameVersionWithIds.putIfAbsent(schemaVersionKey, Lists.newArrayList((Object[])new SchemaIdVersion[]{key1, key2}));
            this.idWithNameVersion.putIfAbsent(key2, schemaVersionKey);
        } else {
            this.nameVersionWithIds.putIfAbsent(schemaVersionKey, Collections.singletonList(key1));
        }
    }

    public SchemaVersionInfo getSchema(Key key) throws SchemaNotFoundException {
        try {
            LOG.debug("Trying to load entry for cache with key [{}] from target service", (Object)key);
            return (SchemaVersionInfo)this.loadingCache.get((Object)key);
        }
        catch (ExecutionException e) {
            if (e.getCause().getClass() == SchemaNotFoundException.class) {
                throw (SchemaNotFoundException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public SchemaVersionInfo getSchemaIfPresent(Key key) throws SchemaNotFoundException {
        LOG.debug("Trying to get entry from cache if it is present in local cache with key [{}]", (Object)key);
        return (SchemaVersionInfo)this.loadingCache.getIfPresent((Object)key);
    }

    public void invalidateSchema(Key key) {
        SchemaVersionKey schemaVersionKey;
        LOG.debug("Invalidating cache entry for key [{}]", (Object)key);
        this.loadingCache.invalidate((Object)key);
        SchemaVersionKey schemaVersionKey2 = schemaVersionKey = key.schemaIdVersion != null ? (SchemaVersionKey)this.idWithNameVersion.get(key.schemaIdVersion) : key.schemaVersionKey;
        if (schemaVersionKey != null) {
            this.loadingCache.invalidate((Object)Key.of(schemaVersionKey));
            List schemaIdVersions = (List)this.nameVersionWithIds.get(schemaVersionKey);
            if (schemaIdVersions != null) {
                for (SchemaIdVersion schemaIdVersion : schemaIdVersions) {
                    this.loadingCache.invalidate((Object)Key.of(schemaIdVersion));
                }
            }
        }
    }

    public void invalidateAll() {
        LOG.info("Invalidating all the cache entries");
        this.loadingCache.invalidateAll();
    }

    @Override
    public SchemaRegistryCacheType getCacheType() {
        return SchemaRegistryCacheType.SCHEMA_VERSION_CACHE;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Key {
        @JsonProperty
        private SchemaVersionKey schemaVersionKey;
        @JsonProperty
        private SchemaIdVersion schemaIdVersion;

        public Key(SchemaVersionKey schemaVersionKey) {
            this.schemaVersionKey = schemaVersionKey;
        }

        public Key(SchemaIdVersion schemaIdVersion) {
            this.schemaIdVersion = schemaIdVersion;
        }

        public static Key of(SchemaVersionKey schemaVersionKey) {
            return new Key(schemaVersionKey);
        }

        public static Key of(SchemaIdVersion schemaIdVersion) {
            return new Key(schemaIdVersion);
        }

        private Key() {
        }

        public String toString() {
            return "Key {schemaVersionKey=" + this.schemaVersionKey + ", schemaIdVersion=" + this.schemaIdVersion + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.schemaVersionKey != null ? !this.schemaVersionKey.equals(key.schemaVersionKey) : key.schemaVersionKey != null) {
                return false;
            }
            return this.schemaIdVersion != null ? this.schemaIdVersion.equals(key.schemaIdVersion) : key.schemaIdVersion == null;
        }

        public int hashCode() {
            int result = this.schemaVersionKey != null ? this.schemaVersionKey.hashCode() : 0;
            result = 31 * result + (this.schemaIdVersion != null ? this.schemaIdVersion.hashCode() : 0);
            return result;
        }
    }
}

