/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.state;

import com.google.common.collect.Lists;
import com.hortonworks.registries.schemaregistry.CompatibilityResult;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaMetadataInfo;
import com.hortonworks.registries.schemaregistry.SchemaValidationLevel;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.errors.IncompatibleSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaBranchNotFoundException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.state.AbstractInbuiltSchemaLifecycleState;
import com.hortonworks.registries.schemaregistry.state.InbuiltSchemaVersionLifecycleState;
import com.hortonworks.registries.schemaregistry.state.SchemaLifecycleException;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleContext;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateAction;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionLifecycleStateTransition;
import com.hortonworks.registries.schemaregistry.state.SchemaVersionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public final class SchemaVersionLifecycleStates {
    public static final InbuiltSchemaVersionLifecycleState INITIATED = new InitiatedState();
    public static final InbuiltSchemaVersionLifecycleState START_REVIEW = new StartReviewState();
    public static final InbuiltSchemaVersionLifecycleState CHANGES_REQUIRED = new ChangesRequiredState();
    public static final InbuiltSchemaVersionLifecycleState REVIEWED = new ReviewedState();
    public static final InbuiltSchemaVersionLifecycleState ENABLED = new EnabledState();
    public static final InbuiltSchemaVersionLifecycleState DISABLED = new DisabledState();
    public static final InbuiltSchemaVersionLifecycleState ARCHIVED = new ArchivedState();
    public static final InbuiltSchemaVersionLifecycleState DELETED = new DeletedState();

    private static Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> createDeleteTransitionActionPair(Byte sourceStateId) {
        return Pair.of((Object)new SchemaVersionLifecycleStateTransition(sourceStateId, DELETED.getId(), "Delete", "Deletes the schema version"), context -> {
            try {
                SchemaVersionLifecycleStates.transitionToDeleteState(context);
            }
            catch (SchemaNotFoundException e) {
                throw new SchemaLifecycleException(e);
            }
        });
    }

    private static Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> createStartReviewTransitionActionPair(Byte sourceStateId) {
        return Pair.of((Object)new SchemaVersionLifecycleStateTransition(sourceStateId, START_REVIEW.getId(), "StartReview", "Starts review state"), context -> {
            try {
                SchemaVersionLifecycleStates.transitionToStartReview(context);
            }
            catch (SchemaNotFoundException e) {
                throw new SchemaLifecycleException(e);
            }
        });
    }

    private static Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> createDisableAction(Byte sourceStateId) {
        return Pair.of((Object)new SchemaVersionLifecycleStateTransition(sourceStateId, DISABLED.getId(), "Disable", "Disables the schema version"), context -> {
            try {
                SchemaVersionLifecycleStates.transitionToDisableState(context);
            }
            catch (SchemaNotFoundException e) {
                throw new SchemaLifecycleException(e);
            }
        });
    }

    private static Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> createArchiveTransitionAction(Byte sourceStateId) {
        return Pair.of((Object)new SchemaVersionLifecycleStateTransition(sourceStateId, ARCHIVED.getId(), "Archive", "Archives the schema version"), context -> {
            try {
                SchemaVersionLifecycleStates.transitionToArchiveState(context);
            }
            catch (SchemaNotFoundException e) {
                throw new SchemaLifecycleException(e);
            }
        });
    }

    private static Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction> createEnableTransitionAction(Byte sourceStateId) {
        return Pair.of((Object)new SchemaVersionLifecycleStateTransition(sourceStateId, ENABLED.getId(), "Enable", "Enables the schema version"), context -> {
            try {
                SchemaVersionLifecycleStates.transitionToEnableState(context);
            }
            catch (IncompatibleSchemaException | SchemaBranchNotFoundException | SchemaNotFoundException e) {
                throw new SchemaLifecycleException(e);
            }
        });
    }

    private static void transitionToDisableState(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
        context.setState(DISABLED);
        context.updateSchemaVersionState();
    }

    private static void transitionToStartReview(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
        context.setState(START_REVIEW);
        context.getCustomSchemaStateExecutor().executeReviewState(context);
    }

    private static void transitionToArchiveState(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
        context.setState(ARCHIVED);
        context.updateSchemaVersionState();
    }

    private static void transitionToDeleteState(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
        context.setState(DELETED);
        context.updateSchemaVersionState();
        context.getSchemaVersionService().deleteSchemaVersion(context.getSchemaVersionId());
    }

    private static void checkCompatibility(SchemaVersionService schemaVersionService, SchemaMetadata schemaMetadata, String toSchemaText, String fromSchemaText) throws IncompatibleSchemaException {
        CompatibilityResult compatibilityResult = schemaVersionService.checkForCompatibility(schemaMetadata, toSchemaText, fromSchemaText);
        if (!compatibilityResult.isCompatible()) {
            String errMsg = String.format("Given schema is not compatible with latest schema versions. \nError location: [%s] \nError encountered is: [%s]", compatibilityResult.getErrorLocation(), compatibilityResult.getErrorMessage());
            throw new IncompatibleSchemaException(errMsg);
        }
    }

    public static void transitionToEnableState(SchemaVersionLifecycleContext context) throws SchemaNotFoundException, IncompatibleSchemaException, SchemaLifecycleException, SchemaBranchNotFoundException {
        Long schemaVersionId = context.getSchemaVersionId();
        SchemaVersionService schemaVersionService = context.getSchemaVersionService();
        SchemaMetadataInfo schemaMetadataInfo = schemaVersionService.getSchemaMetadata(schemaVersionId);
        SchemaMetadata schemaMetadata = schemaMetadataInfo.getSchemaMetadata();
        String schemaName = schemaMetadata.getName();
        SchemaValidationLevel validationLevel = schemaMetadata.getValidationLevel();
        SchemaVersionInfo schemaVersionInfo = schemaVersionService.getSchemaVersionInfo(schemaVersionId);
        int schemaVersion = schemaVersionInfo.getVersion();
        String schemaText = schemaVersionInfo.getSchemaText();
        List allEnabledSchemaVersions = schemaVersionService.getAllSchemaVersions("MASTER", schemaName).stream().filter(x -> ENABLED.getId().equals(x.getStateId())).collect(Collectors.toList());
        if (!allEnabledSchemaVersions.isEmpty()) {
            if (validationLevel.equals((Object)SchemaValidationLevel.ALL)) {
                for (SchemaVersionInfo curSchemaVersionInfo : allEnabledSchemaVersions) {
                    int curVersion = curSchemaVersionInfo.getVersion();
                    if (curVersion < schemaVersion) {
                        SchemaVersionLifecycleStates.checkCompatibility(schemaVersionService, schemaMetadata, schemaText, curSchemaVersionInfo.getSchemaText());
                        continue;
                    }
                    SchemaVersionLifecycleStates.checkCompatibility(schemaVersionService, schemaMetadata, curSchemaVersionInfo.getSchemaText(), schemaText);
                }
            } else if (validationLevel.equals((Object)SchemaValidationLevel.LATEST)) {
                int i;
                ArrayList sortedSchemaVersionInfos = new ArrayList(allEnabledSchemaVersions);
                sortedSchemaVersionInfos.sort(Comparator.comparingInt(SchemaVersionInfo::getVersion));
                int size = sortedSchemaVersionInfos.size();
                for (i = 0; i < size && ((SchemaVersionInfo)sortedSchemaVersionInfos.get(i)).getVersion() < schemaVersion; ++i) {
                    String fromSchemaText = ((SchemaVersionInfo)sortedSchemaVersionInfos.get(i)).getSchemaText();
                    SchemaVersionLifecycleStates.checkCompatibility(schemaVersionService, schemaMetadata, schemaText, fromSchemaText);
                }
                while (i < size && ((SchemaVersionInfo)sortedSchemaVersionInfos.get(i)).getVersion() > schemaVersion) {
                    String toSchemaText = ((SchemaVersionInfo)sortedSchemaVersionInfos.get(i)).getSchemaText();
                    SchemaVersionLifecycleStates.checkCompatibility(schemaVersionService, schemaMetadata, toSchemaText, schemaText);
                    ++i;
                }
            }
        }
        context.setState(ENABLED);
        context.updateSchemaVersionState();
    }

    private static final class DeletedState
    extends AbstractInbuiltSchemaLifecycleState {
        private DeletedState() {
            super("Deleted", (byte)8, "Schema is deleted and it is a terminal state");
        }

        @Override
        public String toString() {
            return "DeletedState{" + super.toString() + "}";
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Collections.emptyList();
        }
    }

    private static final class ArchivedState
    extends AbstractInbuiltSchemaLifecycleState {
        private ArchivedState() {
            super("Archived", (byte)7, "Schema is archived and it is a terminal state");
        }

        @Override
        public void delete(SchemaVersionLifecycleContext schemaVersionLifecycleContext) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToDeleteState(schemaVersionLifecycleContext);
        }

        @Override
        public String toString() {
            return "ArchivedState{" + super.toString() + "}";
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Collections.emptyList();
        }
    }

    private static final class DisabledState
    extends AbstractInbuiltSchemaLifecycleState {
        private DisabledState() {
            super("Disabled", (byte)6, "Schema version is disabled");
        }

        @Override
        public void enable(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
            SchemaVersionLifecycleStates.transitionToEnableState(context);
        }

        @Override
        public void archive(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToArchiveState(context);
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Lists.newArrayList((Object[])new Pair[]{SchemaVersionLifecycleStates.createEnableTransitionAction(this.getId()), SchemaVersionLifecycleStates.createArchiveTransitionAction(this.getId())});
        }

        @Override
        public String toString() {
            return "DisabledState{" + super.toString() + "}";
        }
    }

    private static final class EnabledState
    extends AbstractInbuiltSchemaLifecycleState {
        private EnabledState() {
            super("Enabled", (byte)5, "Schema version is enabled");
        }

        @Override
        public void disable(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToDisableState(context);
        }

        @Override
        public void archive(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToArchiveState(context);
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Lists.newArrayList((Object[])new Pair[]{SchemaVersionLifecycleStates.createDisableAction(this.getId()), SchemaVersionLifecycleStates.createArchiveTransitionAction(this.getId())});
        }

        @Override
        public String toString() {
            return "EnabledState{" + super.toString() + "}";
        }
    }

    private static final class ReviewedState
    extends AbstractInbuiltSchemaLifecycleState {
        private ReviewedState() {
            super("Reviewed", (byte)4, "This schema version is successfully reviewed");
        }

        @Override
        public void enable(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
            SchemaVersionLifecycleStates.transitionToEnableState(context);
        }

        @Override
        public void archive(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToArchiveState(context);
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Lists.newArrayList((Object[])new Pair[]{SchemaVersionLifecycleStates.createEnableTransitionAction(this.getId()), SchemaVersionLifecycleStates.createArchiveTransitionAction(this.getId())});
        }

        @Override
        public String toString() {
            return "ReviewedState{" + super.toString() + "}";
        }
    }

    private static final class ChangesRequiredState
    extends AbstractInbuiltSchemaLifecycleState {
        public ChangesRequiredState() {
            super("ChangesRequired", (byte)3, "Requires changes to be done in this schema");
        }

        @Override
        public void startReview(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToStartReview(context);
        }

        @Override
        public void delete(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToDeleteState(context);
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Lists.newArrayList((Object[])new Pair[]{SchemaVersionLifecycleStates.createStartReviewTransitionActionPair(this.getId()), SchemaVersionLifecycleStates.createDeleteTransitionActionPair(this.getId())});
        }

        @Override
        public String toString() {
            return "ChangesRequiredState{" + super.toString() + "}";
        }
    }

    private static final class StartReviewState
    extends AbstractInbuiltSchemaLifecycleState {
        private StartReviewState() {
            super("StartReview", (byte)2, "Initiates the process for reviewing with the given custom state");
        }

        @Override
        public void startReview(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToStartReview(context);
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Collections.emptyList();
        }

        @Override
        public String toString() {
            return "StartReviewState{" + super.toString() + "}";
        }
    }

    private static final class InitiatedState
    extends AbstractInbuiltSchemaLifecycleState {
        private InitiatedState() {
            super("INITIATED", (byte)1, "Schema version is initialized, It can either go to review or enabled states.");
        }

        @Override
        public void startReview(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToStartReview(context);
        }

        @Override
        public void enable(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, IncompatibleSchemaException, SchemaNotFoundException, SchemaBranchNotFoundException {
            SchemaVersionLifecycleStates.transitionToEnableState(context);
        }

        @Override
        public Collection<Pair<SchemaVersionLifecycleStateTransition, SchemaVersionLifecycleStateAction>> getTransitionActions() {
            return Lists.newArrayList((Object[])new Pair[]{SchemaVersionLifecycleStates.createStartReviewTransitionActionPair(this.getId()), SchemaVersionLifecycleStates.createArchiveTransitionAction(this.getId()), SchemaVersionLifecycleStates.createDeleteTransitionActionPair(this.getId())});
        }

        @Override
        public void delete(SchemaVersionLifecycleContext context) throws SchemaLifecycleException, SchemaNotFoundException {
            SchemaVersionLifecycleStates.transitionToDeleteState(context);
        }

        @Override
        public String toString() {
            return "InitiatedState{" + super.toString() + "}";
        }
    }
}

