/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.InterfaceLogBean;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.Constants;
import com.obs.services.internal.IConvertor;
import com.obs.services.internal.IHeaders;
import com.obs.services.internal.OefExceptionMessage;
import com.obs.services.internal.RestConnectionService;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.UnrecoverableIOException;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.internal.security.ProviderCredentialThreadContext;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.CallCancelHandler;
import com.obs.services.internal.utils.IAuthentication;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.LocalTimeUtil;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.utils.V4Authentication;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HttpMethodEnum;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import shade.okhttp3.Call;
import shade.okhttp3.Headers;
import shade.okhttp3.Request;
import shade.okhttp3.Response;

public abstract class RestStorageService
extends RestConnectionService {
    private static final ILogger log = LoggerBuilder.getLogger(RestStorageService.class);
    private static final Set<Class<? extends IOException>> NON_RETRIEVABLE_CLASSES = new HashSet<Class<? extends IOException>>();
    private static final String REQUEST_TIMEOUT_CODE = "RequestTimeout";
    private static final String UNEXPECTED_END_OF_STREAM_EXCEPTION = "unexpected end of stream";
    private static ThreadLocal<HashMap<String, String>> userHeaders = new ThreadLocal();
    protected static final ThreadLocal<Boolean> CAN_USE_STANDARD_HTTP_HEADERS = new ThreadLocal();

    public static Set<Class<? extends IOException>> getNonRetrievableClasses() {
        return NON_RETRIEVABLE_CLASSES;
    }

    public static void addNonRetrievableClass(Class<? extends IOException> nonRetrievableClass) {
        NON_RETRIEVABLE_CLASSES.add(nonRetrievableClass);
    }

    public static void removeNonRetrievableClass(Class<? extends IOException> nonRetrievableClass) {
        NON_RETRIEVABLE_CLASSES.remove(nonRetrievableClass);
    }

    protected RestStorageService() {
    }

    public void setCanUseStandardHTTPHeaders(Boolean canUseStandardHTTPHeadersMap) {
        CAN_USE_STANDARD_HTTP_HEADERS.set(canUseStandardHTTPHeadersMap);
    }

    public void setUserHeaders(HashMap<String, String> userHeadersMap) {
        userHeaders.set(userHeadersMap);
    }

    private void addUserHeaderToRequest(String bucketName, Request.Builder builder, boolean needEncode) {
        Map<String, String> userHeaderMap = this.formatMetadataAndHeader(bucketName, (Map<String, String>)userHeaders.get(), needEncode);
        for (Map.Entry<String, String> entry : userHeaderMap.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug("Added request header to connection: " + entry.getKey() + "=" + ServiceUtils.getLoggableInfo(entry.getKey(), entry.getValue()));
        }
    }

    private Map<String, String> formatMetadataAndHeader(String bucketName, Map<String, String> metadataAndHeader, boolean needEncode) {
        HashMap<String, String> format = new HashMap<String, String>();
        if (metadataAndHeader != null) {
            for (Map.Entry<String, String> entry : metadataAndHeader.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!ServiceUtils.isValid(key)) continue;
                if (!((key = key.trim()).startsWith(this.getRestHeaderPrefix(bucketName)) || key.startsWith("x-obs-") || Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key.toLowerCase(Locale.getDefault())))) {
                    key = this.getRestMetadataPrefix(bucketName) + key;
                }
                try {
                    if (key.startsWith(this.getRestMetadataPrefix(bucketName)) && needEncode) {
                        key = RestUtils.uriEncode(key, true);
                    }
                    if (needEncode) {
                        format.put(key, RestUtils.uriEncode(value == null ? "" : value, true));
                        continue;
                    }
                    format.put(key, value);
                }
                catch (ServiceException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Ignore key:" + key);
                }
            }
        }
        return format;
    }

    protected boolean retryRequest(IOException exception, RetryCounter retryCounter, Request request, Call call) {
        retryCounter.addErrorCount();
        if (retryCounter.getErrorCount() > retryCounter.getRetryMaxCount()) {
            return false;
        }
        if (NON_RETRIEVABLE_CLASSES.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : NON_RETRIEVABLE_CLASSES) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        return !call.isCanceled();
    }

    private boolean retryRequestForUnexpectedException(IOException exception, RetryCounter retryCounter, Call call) {
        retryCounter.addErrorCount();
        if (null == exception || retryCounter.getErrorCount() > retryCounter.getRetryMaxCount()) {
            return false;
        }
        if (!exception.getMessage().contains(UNEXPECTED_END_OF_STREAM_EXCEPTION)) {
            return false;
        }
        return !call.isCanceled();
    }

    private ServiceException handleThrowable(String bucketName, Request request, Response response, Call call, Throwable t, boolean needEncode) {
        ServiceException serviceException = t instanceof ServiceException ? (ServiceException)t : new ServiceException("Request Error: " + t, t);
        serviceException.setRequestHost(request.header("Host"));
        serviceException.setRequestVerb(request.method());
        serviceException.setRequestPath(request.url().toString());
        if (response != null) {
            ServiceUtils.closeStream(response);
            serviceException.setResponseCode(response.code());
            serviceException.setResponseStatus(response.message());
            serviceException.setResponseDate(response.header("Date"));
            serviceException.setErrorIndicator(response.header("x-reserved-indicator"));
            serviceException.setResponseHeaders(ServiceUtils.cleanRestMetadataMapV2(this.convertHeadersToMap(response.headers()), this.getRestHeaderPrefix(bucketName), this.getRestMetadataPrefix(bucketName), needEncode));
            if (!ServiceUtils.isValid(serviceException.getErrorRequestId())) {
                serviceException.setRequestAndHostIds(response.header(this.getIHeaders(bucketName).requestIdHeader()), response.header(this.getIHeaders(bucketName).requestId2Header()));
            }
        }
        if (log.isWarnEnabled()) {
            log.warn("Request failed, Response code: " + serviceException.getResponseCode() + "; Request ID: " + serviceException.getErrorRequestId() + "; Request path: " + serviceException.getRequestPath());
        }
        if (log.isDebugEnabled()) {
            log.debug("Exception detail.", serviceException);
        }
        if (call != null) {
            call.cancel();
        }
        return serviceException;
    }

    private boolean isLocationHostOnly(String location) {
        boolean isOnlyHost = false;
        URI uri = URI.create(location);
        String path = uri.getPath();
        if (!location.contains("?") && (path == null || path.isEmpty() || path.equals("/"))) {
            isOnlyHost = true;
        }
        return isOnlyHost;
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, true);
    }

    protected Response performRequestWithoutSignature(Request request, Map<String, String> requestParameters, String bucketName) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, false);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, doSignature, false);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF) throws ServiceException {
        return this.performRequest(request, requestParameters, bucketName, doSignature, isOEF, true);
    }

    protected Response performRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF, boolean needEncode) throws ServiceException {
        RequestInfo requestInfo = new RequestInfo(request, new InterfaceLogBean("performRequest", "", ""));
        try {
            this.tryRequest(requestParameters, bucketName, doSignature, isOEF, requestInfo, needEncode, null);
        }
        catch (Throwable t) {
            throw this.handleThrowable(bucketName, requestInfo.getRequest(), requestInfo.getResponse(), requestInfo.getCall(), t, needEncode);
        }
        if (log.isInfoEnabled()) {
            requestInfo.getReqBean().setRespTime(new Date());
            requestInfo.getReqBean().setResultCode("0");
            log.info(requestInfo.getReqBean());
        }
        return requestInfo.getResponse();
    }

    protected Response performRequest(NewTransResult result) {
        return this.performRequest(result, true, true, false, false);
    }

    protected Response performRequest(NewTransResult result, boolean needSignature, boolean autoRelease, boolean isOEF, boolean isNotNeedBucket) {
        Request.Builder builder = this.setupConnection(result, isOEF, isNotNeedBucket);
        this.renameMetadataKeys(result.getBucketName(), builder, result.getHeaders(), result.isEncodeHeaders());
        if (result.getUserHeaders() != null) {
            result.getUserHeaders().forEach(builder::addHeader);
        }
        Request request = builder.build();
        if (result.hasCertificate()) {
            ServiceUtils.checkParameterStartsWith(request.url().toString(), "https://", "Only 'https://' URLs are allowed for sending certificate details to ensure secure transmission.");
        }
        RequestInfo requestInfo = new RequestInfo(request, new InterfaceLogBean("performRequest", "", ""));
        try {
            this.tryRequest(result.getParams(), result.getBucketName(), needSignature, isOEF, requestInfo, result.isEncodeHeaders(), result.getCancelHandler());
        }
        catch (Throwable t) {
            throw this.handleThrowable(result.getBucketName(), requestInfo.getRequest(), requestInfo.getResponse(), requestInfo.getCall(), t, result.isEncodeHeaders());
        }
        if (log.isInfoEnabled()) {
            requestInfo.getReqBean().setRespTime(new Date());
            requestInfo.getReqBean().setResultCode("0");
            log.info(requestInfo.getReqBean());
        }
        Response response = requestInfo.getResponse();
        if (autoRelease && response != null) {
            response.close();
        }
        return response;
    }

    private void tryRequest(Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF, RequestInfo requestInfo, boolean needEncode, CallCancelHandler cancelHandler) throws Exception {
        requestInfo.setRequest(this.initRequest(bucketName, requestInfo.getRequest(), needEncode));
        log.debug("Performing " + requestInfo.getRequest().method() + " request for '" + requestInfo.getRequest().url());
        Map<String, List<String>> requestHeaders = requestInfo.getRequest().headers().toMultimap();
        for (Map.Entry<String, List<String>> entry : requestHeaders.entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isInfoLoggable(key)) continue;
            List<String> values2 = entry.getValue();
            for (String value : values2) {
                log.debug("Headers: " + key + " = " + value);
            }
        }
        RetryController retryController = new RetryController(new RetryCounter(this.obsProperties.getIntProperty("httpclient.retry-max", 3)), new RetryCounter(this.obsProperties.getIntProperty("httpclient.max-retry-on-unexpected-end-exception", -1)), false);
        StringBuilder stringToSignToReturn = new StringBuilder("");
        while (true) {
            if (!retryController.isWasRecentlyRedirected()) {
                requestInfo.setRequest(this.addBaseHeaders(requestInfo.getRequest(), bucketName, doSignature, stringToSignToReturn));
            } else {
                retryController.setWasRecentlyRedirected(false);
            }
            Call okhttpCall = this.httpClient.newCall(requestInfo.getRequest());
            requestInfo.setCall(okhttpCall);
            if (cancelHandler != null) {
                cancelHandler.setCall(okhttpCall);
            }
            requestInfo.setResponse(this.executeRequest(okhttpCall, requestInfo.getRequest(), retryController));
            if (cancelHandler != null) {
                cancelHandler.removeFinishedCall(okhttpCall);
            }
            if (null == requestInfo.getResponse()) continue;
            int responseCode = requestInfo.getResponse().code();
            requestInfo.getReqBean().setRespParams("[responseCode: " + responseCode + "][request-id: " + requestInfo.getResponse().header(this.getIHeaders(bucketName).requestIdHeader(), "") + "]");
            String contentType = requestInfo.getResponse().header("Content-Type");
            if (log.isDebugEnabled()) {
                log.debug("Response for '" + requestInfo.getRequest().method() + "'. Content-Type: " + contentType + ", ResponseCode:" + responseCode + ", Headers: " + requestInfo.getResponse().headers());
            }
            if (log.isTraceEnabled() && requestInfo.getResponse().body() != null) {
                log.trace("Entity length: " + requestInfo.getResponse().body().contentLength());
            }
            if (isOEF && "application/json".equalsIgnoreCase(contentType)) {
                this.transOEFResponse(requestInfo.getResponse(), requestInfo.getReqBean(), retryController.getErrorRetryCounter().getErrorCount(), responseCode);
                break;
            }
            if (responseCode >= 300 && responseCode < 400 && responseCode != 304) {
                requestInfo.setRequest(this.handleRedirectResponse(requestInfo.getRequest(), requestParameters, bucketName, doSignature, isOEF, requestInfo.getReqBean(), requestInfo.getResponse(), retryController, stringToSignToReturn));
                continue;
            }
            if (responseCode >= 400 && responseCode < 500 || responseCode == 304) {
                this.handleRequestErrorResponse(requestInfo.getResponse(), retryController, stringToSignToReturn);
                continue;
            }
            if (responseCode < 500) break;
            this.handleServerErrorResponse(requestInfo.getReqBean(), requestInfo.getResponse(), retryController, responseCode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleRequestErrorResponse(Response response, RetryController retryController, StringBuilder stringToSignToReturn) {
        ServiceException exception = this.createServiceException("Request Error.", response, stringToSignToReturn);
        if (LocalTimeUtil.isRequestTimeTooSkewed(exception, response)) {
            if (this.getLocalTimeUtil() == null) {
                log.warn("getTimeDiffBetweenServerAndLocal is skipped cause localTimeUtil is null.");
                throw exception;
            }
            if (!this.getLocalTimeUtil().isEnableAutoRetryForSkewedTime()) {
                log.warn("getTimeDiffBetweenServerAndLocal is skipped cause LocalTimeUtil.isEnableAutoRetryForSkewedTime() is false");
                throw exception;
            }
            LocalTimeUtil.getTimeDiffBetweenServerAndLocal(response);
        } else if (!REQUEST_TIMEOUT_CODE.equals(exception.getErrorCode())) {
            throw exception;
        }
        String errorCode = exception.getErrorCode();
        if (errorCode == null) {
            errorCode = this.getErrorCodeFromHeader(response);
            exception.setErrorCode(errorCode);
        }
        retryController.getErrorRetryCounter().addErrorCount();
        if (retryController.getErrorRetryCounter().getErrorCount() < retryController.getErrorRetryCounter().getRetryMaxCount()) {
            if (!log.isWarnEnabled()) return;
            log.warn("Retrying connection that failed with " + errorCode + " error, attempt number " + retryController.getErrorRetryCounter().getErrorCount() + " of " + retryController.getErrorRetryCounter().getRetryMaxCount());
            return;
        }
        if (!log.isErrorEnabled()) throw exception;
        log.error("Exceeded maximum number of retries for " + errorCode + " errors: " + retryController.getErrorRetryCounter().getRetryMaxCount());
        throw exception;
    }

    public String getErrorCodeFromHeader(Response response) {
        if (response != null && response.headers() != null) {
            Headers headers = response.headers();
            String errorCodeOBS = headers.get("x-obs-error-code");
            return errorCodeOBS == null ? headers.get("x-amz-error-code") : errorCodeOBS;
        }
        return null;
    }

    private void handleServerErrorResponse(InterfaceLogBean reqBean, Response response, RetryController retryController, int responseCode) {
        reqBean.setResponseInfo("Internal Server error(s).", String.valueOf(responseCode));
        if (log.isErrorEnabled()) {
            log.error(reqBean);
        }
        this.doRetry(response, "Encountered too many 5xx errors (" + retryController.getErrorRetryCounter().getErrorCount() + "), aborting request.", retryController.getErrorRetryCounter());
        this.sleepBeforeRetry(retryController.getErrorRetryCounter().getErrorCount());
    }

    private Request handleRedirectResponse(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF, InterfaceLogBean reqBean, Response response, RetryController retryController, StringBuilder stringToSignToReturn) {
        int responseCode = response.code();
        String location = response.header("Location");
        if (!ServiceUtils.isValid(location)) {
            ServiceException exception = new ServiceException("Try to redirect, but location is null!");
            reqBean.setResponseInfo("Request Error:" + exception.getMessage(), "|" + responseCode + "|" + response.message() + "|");
            throw exception;
        }
        request = this.createRedirectRequest(request, requestParameters, bucketName, doSignature, isOEF, responseCode, location, stringToSignToReturn);
        retryController.setWasRecentlyRedirected(true);
        this.doRetry(response, "Exceeded 3xx redirect limit (" + retryController.getErrorRetryCounter().getRetryMaxCount() + ").", retryController.getErrorRetryCounter());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response executeRequest(Call call, Request request, RetryController retryController) throws Exception {
        long start = System.currentTimeMillis();
        try {
            this.semaphore.acquire();
            if (log.isDebugEnabled()) {
                long acquireTime = System.currentTimeMillis();
                log.debug("semaphore.acquire cost " + (acquireTime - start) + " ms, acquire time:" + acquireTime);
            }
            Response acquireTime = call.execute();
            return acquireTime;
        }
        catch (UnrecoverableIOException e) {
            if (retryController.getLastException() != null) {
                throw retryController.getLastException();
            }
            throw e;
        }
        catch (IOException e) {
            retryController.setLastException(e);
            this.retryOnIOException(e, request, retryController, call);
            if (log.isWarnEnabled()) {
                log.warn("Retrying connection that failed with " + e.getClass() + ", attempt number " + retryController.getErrorRetryCounter().getErrorCount() + " of " + retryController.getErrorRetryCounter().getRetryMaxCount());
            }
            Response response = null;
            return response;
        }
        finally {
            this.semaphore.release();
            if (log.isInfoEnabled()) {
                log.info("OkHttp cost " + (System.currentTimeMillis() - start) + " ms to apply http request");
            }
        }
    }

    private void retryOnIOException(IOException e, Request request, RetryController retryController, Call call) throws Exception {
        if (this.retryRequestForUnexpectedException(e, retryController.getUnexpectedErrorRetryCounter(), call)) {
            if (log.isErrorEnabled()) {
                log.error("unexpected end of stream excepiton.");
            }
            return;
        }
        if (this.retryRequest(e, retryController.getErrorRetryCounter(), request, call)) {
            this.sleepBeforeRetry(retryController.getErrorRetryCounter().getErrorCount());
            return;
        }
        if (e instanceof ConnectException || e instanceof InterruptedIOException) {
            ServiceException se = new ServiceException("Request error. ", e);
            se.setResponseCode(408);
            se.setErrorCode("RequestTimeOut");
            se.setErrorMessage(e.getMessage());
            se.setResponseStatus("Request error. ");
            throw se;
        }
        throw e;
    }

    private void doRetry(Response response, String message, RetryCounter retryCounter) {
        retryCounter.addErrorCount();
        if (retryCounter.getErrorCount() > retryCounter.getRetryMaxCount()) {
            throw this.createServiceException(message, response, null);
        }
        ServiceUtils.closeStream(response);
    }

    private ServiceException createServiceException(String message, Response response, StringBuilder stringToSignToReturn) {
        String xmlMessage = this.readResponseMessage(response);
        if (stringToSignToReturn != null) {
            String errorMessageForSignatureDoesNotMatch = this.createErrorMessageForSignatureDoesNotMatch(xmlMessage, message, stringToSignToReturn);
            ServiceException serviceException = new ServiceException(errorMessageForSignatureDoesNotMatch, xmlMessage);
            serviceException.setErrorMessage(serviceException.getErrorMessage() + "\n" + errorMessageForSignatureDoesNotMatch);
            return serviceException;
        }
        return new ServiceException(message, xmlMessage);
    }

    private String createErrorMessageForSignatureDoesNotMatch(String xmlMessage, String message, StringBuilder stringToSignToReturn) {
        if (!xmlMessage.contains("<Code>SignatureDoesNotMatch</Code>")) {
            return message;
        }
        int startStringToSign = xmlMessage.lastIndexOf("<StringToSign>");
        if (startStringToSign < 0) {
            return message;
        }
        startStringToSign += "<StringToSign>".length();
        int endStringToSign = xmlMessage.lastIndexOf("</StringToSign>");
        StringBuilder ErrorStringToSignMessage = new StringBuilder();
        ServiceUtils.tokenMasked(stringToSignToReturn);
        ErrorStringToSignMessage.append("your local StringToSign is (between\"---\"):\n---\n");
        ErrorStringToSignMessage.append((CharSequence)stringToSignToReturn);
        ErrorStringToSignMessage.append("\n---\nPlease compare it to Server's StringToSign (between\"---\"):\n---\n");
        ErrorStringToSignMessage.append(xmlMessage, startStringToSign, endStringToSign);
        ErrorStringToSignMessage.append("\n---\n");
        return ErrorStringToSignMessage.toString();
    }

    private String readResponseMessage(Response response) {
        String xmlMessage = null;
        try {
            if (response.body() != null) {
                xmlMessage = ServiceUtils.messageMasked(response.body().string());
            }
        }
        catch (IOException e) {
            log.warn("read response body failed.", e);
        }
        return xmlMessage;
    }

    private Request createRedirectRequest(Request request, Map<String, String> requestParameters, String bucketName, boolean doSignature, boolean isOEF, int responseCode, String location, StringBuilder stringToSignToReturn) {
        if (!location.contains("?")) {
            location = this.addRequestParametersToUrlPath(location, requestParameters, isOEF);
        }
        if (doSignature && this.isLocationHostOnly(location)) {
            request = this.authorizeHttpRequest(request, bucketName, location, stringToSignToReturn);
        } else {
            Request.Builder builder = request.newBuilder();
            if (responseCode == 302 && HttpMethodEnum.GET.getOperationType().equalsIgnoreCase(request.method())) {
                Headers headers = request.headers().newBuilder().removeAll("Authorization").build();
                builder.headers(headers);
            }
            this.setHost(builder, request, location);
            request = builder.build();
        }
        return request;
    }

    private void transOEFResponse(Response response, InterfaceLogBean reqBean, int internalErrorCount, int responseCode) {
        if (responseCode >= 400 && responseCode < 500) {
            String xmlMessage = this.readResponseMessage(response);
            OefExceptionMessage oefException = (OefExceptionMessage)JSONChange.jsonToObj(new OefExceptionMessage(), ServiceUtils.toValid(xmlMessage));
            ServiceException exception = new ServiceException("Request Error." + ServiceUtils.toValid(xmlMessage));
            exception.setErrorMessage(oefException.getMessage());
            exception.setErrorCode(oefException.getCode());
            exception.setErrorRequestId(oefException.getRequestId());
            throw exception;
        }
        if (responseCode >= 500) {
            reqBean.setResponseInfo("Internal Server error(s).", String.valueOf(responseCode));
            if (log.isErrorEnabled()) {
                log.error(reqBean);
            }
            throw this.createServiceException("Encountered too many 5xx errors (" + internalErrorCount + "), aborting request.", response, null);
        }
    }

    private Request addBaseHeaders(Request request, String bucketName, boolean doSignature, StringBuilder stringToSignToReturn) {
        if (doSignature) {
            request = this.authorizeHttpRequest(request, bucketName, null, stringToSignToReturn);
        } else {
            Request.Builder builder = request.newBuilder();
            builder.headers(request.headers().newBuilder().removeAll("Authorization").build());
            this.setHost(builder, request, null);
            builder.header("User-Agent", "obs-sdk-java/3.25.7");
            request = builder.build();
        }
        Map<String, List<String>> requestHeaders = request.headers().toMultimap();
        for (Map.Entry<String, List<String>> entry : requestHeaders.entrySet()) {
            String key = entry.getKey();
            if (!ServiceUtils.isInfoLoggable(key)) continue;
            List<String> values2 = entry.getValue();
            for (String value : values2) {
                log.debug("Request Headers: " + key + " = " + value);
            }
        }
        return request;
    }

    private Request initRequest(String bucketName, Request request, boolean needEncode) {
        if (userHeaders.get() != null && userHeaders.get().size() > 0) {
            Request.Builder builderTmp = request.newBuilder();
            this.addUserHeaderToRequest(bucketName, builderTmp, needEncode);
            request = builderTmp.build();
        }
        return request;
    }

    protected String getRestMetadataPrefix(String bucketName) {
        return this.getIHeaders(bucketName).headerMetaPrefix();
    }

    protected String getRestHeaderPrefix(String bucketName) {
        return this.getIHeaders(bucketName).headerPrefix();
    }

    private boolean isProviderCredentialsInValid(ProviderCredentials providerCredentials) {
        return providerCredentials == null || providerCredentials.getObsCredentialsProvider().getSecurityKey() == null || !ServiceUtils.isValid(providerCredentials.getSecurityKey().getAccessKey()) || !ServiceUtils.isValid(providerCredentials.getSecurityKey().getSecretKey());
    }

    private URI setHost(Request.Builder builder, Request request, String url) {
        int insecurePort;
        int securePort;
        URI uri;
        if (url == null) {
            uri = request.url().uri();
        } else {
            uri = URI.create(url);
            builder.url(url);
        }
        String portStr = this.getHttpsOnly() ? ((securePort = this.getHttpsPort()) == 443 ? "" : ":" + securePort) : ((insecurePort = this.getHttpPort()) == 80 ? "" : ":" + insecurePort);
        builder.header("Host", uri.getHost() + portStr);
        return uri;
    }

    private Date parseDate(String bucketName, Request request, boolean isV4) {
        String dateHeader = this.getIHeaders(bucketName).dateHeader();
        String date = request.header(dateHeader);
        if (date != null) {
            try {
                return isV4 ? ServiceUtils.getLongDateFormat().parse(date) : ServiceUtils.parseRfc822Date(date);
            }
            catch (ParseException e) {
                throw new ServiceException(dateHeader + " is not well-format", e);
            }
        }
        return new Date();
    }

    protected Request authorizeHttpRequest(Request request, String bucketName, String url, StringBuilder stringToSignToReturn) throws ServiceException {
        IAuthentication iauthentication;
        String queryString;
        Headers headers = request.headers().newBuilder().removeAll("Authorization").build();
        Request.Builder builder = request.newBuilder();
        builder.headers(headers);
        URI uri = this.setHost(builder, request, url);
        String hostname = uri.getHost();
        ProviderCredentials providerCredentials = ProviderCredentialThreadContext.getInstance().getProviderCredentials();
        if (this.isProviderCredentialsInValid(providerCredentials)) {
            providerCredentials = this.getProviderCredentials();
        } else {
            providerCredentials.setAuthType(this.getProviderCredentials().getLocalAuthType(bucketName));
            LinkedHashMap<String, AuthTypeEnum> localAuthType = new LinkedHashMap<String, AuthTypeEnum>();
            localAuthType.put(bucketName, providerCredentials.getAuthType());
            providerCredentials.setLocalAuthType(localAuthType);
        }
        if (this.isProviderCredentialsInValid(providerCredentials)) {
            if (log.isInfoEnabled()) {
                log.info("Service has no Credential and is un-authenticated, skipping authorization");
            }
            return request;
        }
        boolean isV4 = providerCredentials.getLocalAuthType(bucketName) == AuthTypeEnum.V4;
        Date now = this.parseDate(bucketName, request, isV4);
        builder.header("Date", ServiceUtils.formatRfc822Date(LocalTimeUtil.dateWithTimeDiff(now)));
        BasicSecurityKey securityKey = providerCredentials.getSecurityKey();
        String securityToken = securityKey.getSecurityToken();
        if (ServiceUtils.isValid(securityToken)) {
            builder.header(this.getIHeaders(bucketName).securityTokenHeader(), securityToken);
        }
        String fullUrl = uri.getRawPath();
        String endpoint = this.getEndpoint();
        if (!(this.isPathStyle() && !this.isCname() || hostname == null || isV4)) {
            if (this.isCname()) {
                fullUrl = "/" + hostname + fullUrl;
            } else if (ServiceUtils.isValid(bucketName) && !endpoint.equals(hostname) && hostname.contains(bucketName)) {
                fullUrl = "/" + bucketName + fullUrl;
            }
        }
        if ((queryString = uri.getRawQuery()) != null && queryString.length() > 0) {
            fullUrl = fullUrl + "?" + queryString;
        }
        if (log.isDebugEnabled()) {
            log.debug("For creating canonical string, using uri: " + fullUrl);
        }
        if (isV4) {
            builder.header(this.getIHeaders(bucketName).contentSha256Header(), V4Authentication.CONTENT_SHA256);
            iauthentication = V4Authentication.makeServiceCanonicalString(request.method(), this.convertHeadersToMap(builder.build().headers()), fullUrl, providerCredentials, now, securityKey);
            if (log.isDebugEnabled()) {
                log.debug("CanonicalRequest:" + iauthentication.getCanonicalRequest());
            }
        } else {
            iauthentication = Constants.AUTHTICATION_MAP.get((Object)providerCredentials.getLocalAuthType(bucketName)).makeAuthorizationString(request.method(), this.convertHeadersToMap(builder.build().headers()), fullUrl, Constants.ALLOWED_RESOURCE_PARAMTER_NAMES, securityKey);
        }
        if (stringToSignToReturn != null) {
            stringToSignToReturn.setLength(0);
            stringToSignToReturn.append(iauthentication.getStringToSign());
        }
        log.debug("StringToSign ('|' is a newline): " + ServiceUtils.messageMasked(iauthentication.getStringToSign().replace('\n', '|')));
        String authorizationString = iauthentication.getAuthorization();
        builder.header("Authorization", authorizationString);
        builder.header("User-Agent", "obs-sdk-java/3.25.7");
        return builder.build();
    }

    protected Response performRestHead(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders, Map<String, String> userHeaders, boolean needEncode) throws ServiceException {
        NewTransResult transResult = new NewTransResult();
        transResult.setHttpMethod(HttpMethodEnum.HEAD);
        transResult.setBucketName(bucketName);
        transResult.setObjectKey(objectKey);
        transResult.setParams(requestParameters);
        Request.Builder builder = this.setupConnection(transResult, false, false);
        this.addRequestHeadersToConnection(bucketName, builder, requestHeaders);
        if (userHeaders != null) {
            userHeaders.forEach(builder::addHeader);
        }
        return this.performRequest(builder.build(), requestParameters, bucketName, true, false, needEncode);
    }

    protected Response performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders, Map<String, String> userHeaders) throws ServiceException {
        return this.performRestGet(bucketName, objectKey, requestParameters, requestHeaders, userHeaders, false);
    }

    protected Response performRestGetForListBuckets(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        NewTransResult transResult = new NewTransResult();
        transResult.setHttpMethod(HttpMethodEnum.GET);
        transResult.setBucketName(bucketName);
        transResult.setObjectKey(objectKey);
        transResult.setParams(requestParameters);
        Request.Builder builder = this.setupConnection(transResult, false, true);
        this.addRequestHeadersToConnection(bucketName, builder, requestHeaders);
        return this.performRequest(builder.build(), requestParameters, bucketName, true, false);
    }

    protected Response performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders, Map<String, String> userHeaders, boolean isOEF) throws ServiceException {
        return this.performRestGet(bucketName, objectKey, requestParameters, requestHeaders, userHeaders, isOEF, true);
    }

    protected Response performRestGet(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders, Map<String, String> userHeaders, boolean isOEF, boolean needEncode) throws ServiceException {
        NewTransResult transResult = new NewTransResult();
        transResult.setHttpMethod(HttpMethodEnum.GET);
        transResult.setBucketName(bucketName);
        transResult.setObjectKey(objectKey);
        transResult.setParams(requestParameters);
        Request.Builder builder = this.setupConnection(transResult, isOEF, false);
        this.addRequestHeadersToConnection(bucketName, builder, requestHeaders);
        if (userHeaders != null) {
            userHeaders.forEach(builder::addHeader);
        }
        return this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF, needEncode);
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> metadata, Map<String, String> userHeaders) throws ServiceException {
        return this.performRestDelete(bucketName, objectKey, requestParameters, metadata, userHeaders, true, false);
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> metadata, Map<String, String> userHeaders, boolean autoRelease, boolean isOEF) throws ServiceException {
        NewTransResult transResult = new NewTransResult();
        transResult.setHttpMethod(HttpMethodEnum.DELETE);
        transResult.setBucketName(bucketName);
        transResult.setObjectKey(objectKey);
        transResult.setParams(requestParameters);
        Request.Builder builder = this.setupConnection(transResult, isOEF, false);
        this.renameMetadataKeys(bucketName, builder, metadata);
        if (userHeaders != null) {
            userHeaders.forEach(builder::addHeader);
        }
        Response result = this.performRequest(builder.build(), requestParameters, bucketName, true, isOEF);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestDelete(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> userHeaders, boolean autoRelease) throws ServiceException {
        return this.performRestDelete(bucketName, objectKey, requestParameters, new HashMap<String, String>(), userHeaders, autoRelease, false);
    }

    protected Response performRestOptions(String bucketName, String objectKey, Map<String, String> metadata, Map<String, String> requestParameters, boolean autoRelease) throws ServiceException {
        NewTransResult transResult = new NewTransResult();
        transResult.setHttpMethod(HttpMethodEnum.OPTIONS);
        transResult.setBucketName(bucketName);
        transResult.setObjectKey(objectKey);
        transResult.setParams(requestParameters);
        Request.Builder builder = this.setupConnection(transResult, false, false);
        this.addRequestHeadersToConnection(bucketName, builder, metadata);
        Response result = this.performRequest(builder.build(), requestParameters, bucketName);
        if (autoRelease) {
            result.close();
        }
        return result;
    }

    protected Response performRestForApiVersion(String bucketName, String objectKey, Map<String, String> requestParameters, Map<String, String> requestHeaders) throws ServiceException {
        boolean isListBuckets = true;
        if (null != bucketName && !"".equals(bucketName.trim())) {
            isListBuckets = false;
        }
        NewTransResult transResult = new NewTransResult();
        transResult.setHttpMethod(HttpMethodEnum.HEAD);
        transResult.setBucketName(bucketName);
        transResult.setObjectKey(objectKey);
        transResult.setParams(requestParameters);
        Request.Builder builder = this.setupConnection(transResult, false, isListBuckets);
        this.addRequestHeadersToConnection(bucketName, builder, requestHeaders);
        return this.performRequestWithoutSignature(builder.build(), requestParameters, bucketName);
    }

    private void sleepBeforeRetry(int internalErrorCount) {
        long delayMs = 50L * (long)((int)Math.pow(2.0, internalErrorCount));
        log.warn("Encountered " + internalErrorCount + " Internal Server error(s), will retry in " + delayMs + "ms");
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException e) {
            log.warn("thread sleep failed.", e);
        }
    }

    protected Map<String, String> convertHeadersToMap(Headers headers) {
        IdentityHashMap<String, String> map = new IdentityHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : headers.toMultimap().entrySet()) {
            List<String> values2 = entry.getValue();
            for (String value : values2) {
                map.put(entry.getKey(), value);
            }
        }
        return map;
    }

    protected ProviderCredentials getProviderCredentials() {
        return this.credentials;
    }

    protected void setProviderCredentials(ProviderCredentials credentials) {
        this.credentials = credentials;
    }

    protected void renameMetadataKeys(String bucketName, Request.Builder builder, Map<String, String> metadata, boolean needEncode) {
        Map<String, String> convertedMetadata = this.formatMetadataAndHeader(bucketName, metadata, needEncode);
        for (Map.Entry<String, String> entry : convertedMetadata.entrySet()) {
            builder.addHeader(entry.getKey(), entry.getValue());
            if (!log.isDebugEnabled()) continue;
            log.debug("Added metadata to connection: " + entry.getKey() + "=" + ServiceUtils.getLoggableInfo(entry.getKey(), entry.getValue()));
        }
    }

    protected void renameMetadataKeys(String bucketName, Request.Builder builder, Map<String, String> metadata) {
        this.renameMetadataKeys(bucketName, builder, metadata, true);
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser();
    }

    protected void addRequestHeadersToConnection(String bucketName, Request.Builder builder, Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (!ServiceUtils.isValid(key) || value == null || !Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains((key = key.trim()).toLowerCase(Locale.getDefault())) && !key.startsWith(this.getRestHeaderPrefix(bucketName))) continue;
                builder.addHeader(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug("Added request header to connection: " + key + "=" + ServiceUtils.getLoggableInfo(key, value));
            }
        }
    }

    protected IHeaders getIHeaders(String bucketName) {
        return Constants.HEADERS_MAP.get((Object)this.getProviderCredentials().getLocalAuthType(bucketName));
    }

    protected IConvertor getIConvertor(String bucketName) {
        return Constants.CONVERTOR_MAP.get((Object)this.getProviderCredentials().getLocalAuthType(bucketName));
    }

    protected boolean isAuthTypeNegotiation() {
        return this.obsProperties.getBoolProperty("httpclient.auth-type-negotiation", true);
    }

    protected String getFileSystemDelimiter() {
        return this.obsProperties.getStringProperty("filesystem.delimiter", "/");
    }

    private static final class RetryCounter {
        private int errorCount = 0;
        private int retryMaxCount;

        public RetryCounter(int retryMaxCount) {
            this.retryMaxCount = retryMaxCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public void addErrorCount() {
            ++this.errorCount;
        }

        public int getRetryMaxCount() {
            return this.retryMaxCount;
        }
    }

    private static final class RequestInfo {
        private Request request;
        private Response response = null;
        private Call call = null;
        private InterfaceLogBean reqBean;

        public RequestInfo(Request request, InterfaceLogBean reqBean) {
            this.request = request;
            this.reqBean = reqBean;
        }

        public Request getRequest() {
            return this.request;
        }

        public void setRequest(Request request) {
            this.request = request;
        }

        public Response getResponse() {
            return this.response;
        }

        public void setResponse(Response response) {
            this.response = response;
        }

        public Call getCall() {
            return this.call;
        }

        public void setCall(Call call) {
            this.call = call;
        }

        public InterfaceLogBean getReqBean() {
            return this.reqBean;
        }
    }

    private static final class RetryController {
        private RetryCounter errorRetryCounter;
        private RetryCounter unexpectedErrorRetryCounter;
        private Exception lastException = null;
        private boolean wasRecentlyRedirected;

        public RetryController(RetryCounter errorRetryCounter, RetryCounter unexpectedErrorRetryCounter, boolean wasRecentlyRedirected) {
            this.errorRetryCounter = errorRetryCounter;
            this.unexpectedErrorRetryCounter = unexpectedErrorRetryCounter;
            this.wasRecentlyRedirected = wasRecentlyRedirected;
        }

        public Exception getLastException() {
            return this.lastException;
        }

        public void setLastException(Exception lastException) {
            this.lastException = lastException;
        }

        public RetryCounter getErrorRetryCounter() {
            return this.errorRetryCounter;
        }

        public RetryCounter getUnexpectedErrorRetryCounter() {
            return this.unexpectedErrorRetryCounter;
        }

        public boolean isWasRecentlyRedirected() {
            return this.wasRecentlyRedirected;
        }

        public void setWasRecentlyRedirected(boolean wasRecentlyRedirected) {
            this.wasRecentlyRedirected = wasRecentlyRedirected;
        }
    }
}

