/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cce.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cce.v3.model.Versions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class AddonInstanceStatus {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="Reason")
    private String reason;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="message")
    private String message;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="targetVersions")
    private List<String> targetVersions = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="currentVersion")
    private Versions currentVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="isRollbackable")
    private Boolean isRollbackable;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="previousVersion")
    private String previousVersion;

    public AddonInstanceStatus withStatus(StatusEnum status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AddonInstanceStatus withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public AddonInstanceStatus withMessage(String message) {
        this.message = message;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public AddonInstanceStatus withTargetVersions(List<String> targetVersions) {
        this.targetVersions = targetVersions;
        return this;
    }

    public AddonInstanceStatus addTargetVersionsItem(String targetVersionsItem) {
        if (this.targetVersions == null) {
            this.targetVersions = new ArrayList<String>();
        }
        this.targetVersions.add(targetVersionsItem);
        return this;
    }

    public AddonInstanceStatus withTargetVersions(Consumer<List<String>> targetVersionsSetter) {
        if (this.targetVersions == null) {
            this.targetVersions = new ArrayList<String>();
        }
        targetVersionsSetter.accept(this.targetVersions);
        return this;
    }

    public List<String> getTargetVersions() {
        return this.targetVersions;
    }

    public void setTargetVersions(List<String> targetVersions) {
        this.targetVersions = targetVersions;
    }

    public AddonInstanceStatus withCurrentVersion(Versions currentVersion) {
        this.currentVersion = currentVersion;
        return this;
    }

    public AddonInstanceStatus withCurrentVersion(Consumer<Versions> currentVersionSetter) {
        if (this.currentVersion == null) {
            this.currentVersion = new Versions();
            currentVersionSetter.accept(this.currentVersion);
        }
        return this;
    }

    public Versions getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(Versions currentVersion) {
        this.currentVersion = currentVersion;
    }

    public AddonInstanceStatus withIsRollbackable(Boolean isRollbackable) {
        this.isRollbackable = isRollbackable;
        return this;
    }

    public Boolean getIsRollbackable() {
        return this.isRollbackable;
    }

    public void setIsRollbackable(Boolean isRollbackable) {
        this.isRollbackable = isRollbackable;
    }

    public AddonInstanceStatus withPreviousVersion(String previousVersion) {
        this.previousVersion = previousVersion;
        return this;
    }

    public String getPreviousVersion() {
        return this.previousVersion;
    }

    public void setPreviousVersion(String previousVersion) {
        this.previousVersion = previousVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddonInstanceStatus that = (AddonInstanceStatus)obj;
        return Objects.equals(this.status, that.status) && Objects.equals(this.reason, that.reason) && Objects.equals(this.message, that.message) && Objects.equals(this.targetVersions, that.targetVersions) && Objects.equals(this.currentVersion, that.currentVersion) && Objects.equals(this.isRollbackable, that.isRollbackable) && Objects.equals(this.previousVersion, that.previousVersion);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.reason, this.message, this.targetVersions, this.currentVersion, this.isRollbackable, this.previousVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddonInstanceStatus {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    targetVersions: ").append(this.toIndentedString(this.targetVersions)).append("\n");
        sb.append("    currentVersion: ").append(this.toIndentedString(this.currentVersion)).append("\n");
        sb.append("    isRollbackable: ").append(this.toIndentedString(this.isRollbackable)).append("\n");
        sb.append("    previousVersion: ").append(this.toIndentedString(this.previousVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class StatusEnum {
        public static final StatusEnum RUNNING = new StatusEnum("running");
        public static final StatusEnum ABNORMAL = new StatusEnum("abnormal");
        public static final StatusEnum INSTALLING = new StatusEnum("installing");
        public static final StatusEnum INSTALLFAILED = new StatusEnum("installFailed");
        public static final StatusEnum UPGRADING = new StatusEnum("upgrading");
        public static final StatusEnum UPGRADEFAILED = new StatusEnum("upgradeFailed");
        public static final StatusEnum DELETING = new StatusEnum("deleting");
        public static final StatusEnum DELETESUCCESS = new StatusEnum("deleteSuccess");
        public static final StatusEnum DELETEFAILED = new StatusEnum("deleteFailed");
        public static final StatusEnum AVAILABLE = new StatusEnum("available");
        public static final StatusEnum ROLLBACKING = new StatusEnum("rollbacking");
        public static final StatusEnum ROLLBACKFAILED = new StatusEnum("rollbackFailed");
        private static final Map<String, StatusEnum> STATIC_FIELDS = StatusEnum.createStaticFields();
        private String value;

        private static Map<String, StatusEnum> createStaticFields() {
            HashMap<String, StatusEnum> map = new HashMap<String, StatusEnum>();
            map.put("running", RUNNING);
            map.put("abnormal", ABNORMAL);
            map.put("installing", INSTALLING);
            map.put("installFailed", INSTALLFAILED);
            map.put("upgrading", UPGRADING);
            map.put("upgradeFailed", UPGRADEFAILED);
            map.put("deleting", DELETING);
            map.put("deleteSuccess", DELETESUCCESS);
            map.put("deleteFailed", DELETEFAILED);
            map.put("available", AVAILABLE);
            map.put("rollbacking", ROLLBACKING);
            map.put("rollbackFailed", ROLLBACKFAILED);
            return Collections.unmodifiableMap(map);
        }

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new StatusEnum(value));
        }

        public static StatusEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof StatusEnum) {
                return this.value.equals(((StatusEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

