/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cce.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cce.v3.model.Authentication;
import com.huaweicloud.sdk.cce.v3.model.ClusterExtendParam;
import com.huaweicloud.sdk.cce.v3.model.ContainerNetwork;
import com.huaweicloud.sdk.cce.v3.model.EniNetwork;
import com.huaweicloud.sdk.cce.v3.model.HostNetwork;
import com.huaweicloud.sdk.cce.v3.model.MasterSpec;
import com.huaweicloud.sdk.cce.v3.model.PackageConfiguration;
import com.huaweicloud.sdk.cce.v3.model.ResourceTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ClusterSpec {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="category")
    private CategoryEnum category;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="flavor")
    private String flavor;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="version")
    private String version;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="platformVersion")
    private String platformVersion;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="customSan")
    private List<String> customSan = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ipv6enable")
    private Boolean ipv6enable;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="hostNetwork")
    private HostNetwork hostNetwork;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="containerNetwork")
    private ContainerNetwork containerNetwork;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="eniNetwork")
    private EniNetwork eniNetwork;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="authentication")
    private Authentication authentication;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="billingMode")
    private Integer billingMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="masters")
    private List<MasterSpec> masters = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="kubernetesSvcIpRange")
    private String kubernetesSvcIpRange;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="clusterTags")
    private List<ResourceTag> clusterTags = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="kubeProxyMode")
    private KubeProxyModeEnum kubeProxyMode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="az")
    private String az;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="extendParam")
    private ClusterExtendParam extendParam;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="supportIstio")
    private Boolean supportIstio;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="configurationsOverride")
    private List<PackageConfiguration> configurationsOverride = null;

    public ClusterSpec withCategory(CategoryEnum category) {
        this.category = category;
        return this;
    }

    public CategoryEnum getCategory() {
        return this.category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public ClusterSpec withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ClusterSpec withFlavor(String flavor) {
        this.flavor = flavor;
        return this;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    public ClusterSpec withVersion(String version) {
        this.version = version;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ClusterSpec withPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public ClusterSpec withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ClusterSpec withCustomSan(List<String> customSan) {
        this.customSan = customSan;
        return this;
    }

    public ClusterSpec addCustomSanItem(String customSanItem) {
        if (this.customSan == null) {
            this.customSan = new ArrayList<String>();
        }
        this.customSan.add(customSanItem);
        return this;
    }

    public ClusterSpec withCustomSan(Consumer<List<String>> customSanSetter) {
        if (this.customSan == null) {
            this.customSan = new ArrayList<String>();
        }
        customSanSetter.accept(this.customSan);
        return this;
    }

    public List<String> getCustomSan() {
        return this.customSan;
    }

    public void setCustomSan(List<String> customSan) {
        this.customSan = customSan;
    }

    public ClusterSpec withIpv6enable(Boolean ipv6enable) {
        this.ipv6enable = ipv6enable;
        return this;
    }

    public Boolean getIpv6enable() {
        return this.ipv6enable;
    }

    public void setIpv6enable(Boolean ipv6enable) {
        this.ipv6enable = ipv6enable;
    }

    public ClusterSpec withHostNetwork(HostNetwork hostNetwork) {
        this.hostNetwork = hostNetwork;
        return this;
    }

    public ClusterSpec withHostNetwork(Consumer<HostNetwork> hostNetworkSetter) {
        if (this.hostNetwork == null) {
            this.hostNetwork = new HostNetwork();
            hostNetworkSetter.accept(this.hostNetwork);
        }
        return this;
    }

    public HostNetwork getHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(HostNetwork hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    public ClusterSpec withContainerNetwork(ContainerNetwork containerNetwork) {
        this.containerNetwork = containerNetwork;
        return this;
    }

    public ClusterSpec withContainerNetwork(Consumer<ContainerNetwork> containerNetworkSetter) {
        if (this.containerNetwork == null) {
            this.containerNetwork = new ContainerNetwork();
            containerNetworkSetter.accept(this.containerNetwork);
        }
        return this;
    }

    public ContainerNetwork getContainerNetwork() {
        return this.containerNetwork;
    }

    public void setContainerNetwork(ContainerNetwork containerNetwork) {
        this.containerNetwork = containerNetwork;
    }

    public ClusterSpec withEniNetwork(EniNetwork eniNetwork) {
        this.eniNetwork = eniNetwork;
        return this;
    }

    public ClusterSpec withEniNetwork(Consumer<EniNetwork> eniNetworkSetter) {
        if (this.eniNetwork == null) {
            this.eniNetwork = new EniNetwork();
            eniNetworkSetter.accept(this.eniNetwork);
        }
        return this;
    }

    public EniNetwork getEniNetwork() {
        return this.eniNetwork;
    }

    public void setEniNetwork(EniNetwork eniNetwork) {
        this.eniNetwork = eniNetwork;
    }

    public ClusterSpec withAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public ClusterSpec withAuthentication(Consumer<Authentication> authenticationSetter) {
        if (this.authentication == null) {
            this.authentication = new Authentication();
            authenticationSetter.accept(this.authentication);
        }
        return this;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public ClusterSpec withBillingMode(Integer billingMode) {
        this.billingMode = billingMode;
        return this;
    }

    public Integer getBillingMode() {
        return this.billingMode;
    }

    public void setBillingMode(Integer billingMode) {
        this.billingMode = billingMode;
    }

    public ClusterSpec withMasters(List<MasterSpec> masters) {
        this.masters = masters;
        return this;
    }

    public ClusterSpec addMastersItem(MasterSpec mastersItem) {
        if (this.masters == null) {
            this.masters = new ArrayList<MasterSpec>();
        }
        this.masters.add(mastersItem);
        return this;
    }

    public ClusterSpec withMasters(Consumer<List<MasterSpec>> mastersSetter) {
        if (this.masters == null) {
            this.masters = new ArrayList<MasterSpec>();
        }
        mastersSetter.accept(this.masters);
        return this;
    }

    public List<MasterSpec> getMasters() {
        return this.masters;
    }

    public void setMasters(List<MasterSpec> masters) {
        this.masters = masters;
    }

    public ClusterSpec withKubernetesSvcIpRange(String kubernetesSvcIpRange) {
        this.kubernetesSvcIpRange = kubernetesSvcIpRange;
        return this;
    }

    public String getKubernetesSvcIpRange() {
        return this.kubernetesSvcIpRange;
    }

    public void setKubernetesSvcIpRange(String kubernetesSvcIpRange) {
        this.kubernetesSvcIpRange = kubernetesSvcIpRange;
    }

    public ClusterSpec withClusterTags(List<ResourceTag> clusterTags) {
        this.clusterTags = clusterTags;
        return this;
    }

    public ClusterSpec addClusterTagsItem(ResourceTag clusterTagsItem) {
        if (this.clusterTags == null) {
            this.clusterTags = new ArrayList<ResourceTag>();
        }
        this.clusterTags.add(clusterTagsItem);
        return this;
    }

    public ClusterSpec withClusterTags(Consumer<List<ResourceTag>> clusterTagsSetter) {
        if (this.clusterTags == null) {
            this.clusterTags = new ArrayList<ResourceTag>();
        }
        clusterTagsSetter.accept(this.clusterTags);
        return this;
    }

    public List<ResourceTag> getClusterTags() {
        return this.clusterTags;
    }

    public void setClusterTags(List<ResourceTag> clusterTags) {
        this.clusterTags = clusterTags;
    }

    public ClusterSpec withKubeProxyMode(KubeProxyModeEnum kubeProxyMode) {
        this.kubeProxyMode = kubeProxyMode;
        return this;
    }

    public KubeProxyModeEnum getKubeProxyMode() {
        return this.kubeProxyMode;
    }

    public void setKubeProxyMode(KubeProxyModeEnum kubeProxyMode) {
        this.kubeProxyMode = kubeProxyMode;
    }

    public ClusterSpec withAz(String az) {
        this.az = az;
        return this;
    }

    public String getAz() {
        return this.az;
    }

    public void setAz(String az) {
        this.az = az;
    }

    public ClusterSpec withExtendParam(ClusterExtendParam extendParam) {
        this.extendParam = extendParam;
        return this;
    }

    public ClusterSpec withExtendParam(Consumer<ClusterExtendParam> extendParamSetter) {
        if (this.extendParam == null) {
            this.extendParam = new ClusterExtendParam();
            extendParamSetter.accept(this.extendParam);
        }
        return this;
    }

    public ClusterExtendParam getExtendParam() {
        return this.extendParam;
    }

    public void setExtendParam(ClusterExtendParam extendParam) {
        this.extendParam = extendParam;
    }

    public ClusterSpec withSupportIstio(Boolean supportIstio) {
        this.supportIstio = supportIstio;
        return this;
    }

    public Boolean getSupportIstio() {
        return this.supportIstio;
    }

    public void setSupportIstio(Boolean supportIstio) {
        this.supportIstio = supportIstio;
    }

    public ClusterSpec withConfigurationsOverride(List<PackageConfiguration> configurationsOverride) {
        this.configurationsOverride = configurationsOverride;
        return this;
    }

    public ClusterSpec addConfigurationsOverrideItem(PackageConfiguration configurationsOverrideItem) {
        if (this.configurationsOverride == null) {
            this.configurationsOverride = new ArrayList<PackageConfiguration>();
        }
        this.configurationsOverride.add(configurationsOverrideItem);
        return this;
    }

    public ClusterSpec withConfigurationsOverride(Consumer<List<PackageConfiguration>> configurationsOverrideSetter) {
        if (this.configurationsOverride == null) {
            this.configurationsOverride = new ArrayList<PackageConfiguration>();
        }
        configurationsOverrideSetter.accept(this.configurationsOverride);
        return this;
    }

    public List<PackageConfiguration> getConfigurationsOverride() {
        return this.configurationsOverride;
    }

    public void setConfigurationsOverride(List<PackageConfiguration> configurationsOverride) {
        this.configurationsOverride = configurationsOverride;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterSpec that = (ClusterSpec)obj;
        return Objects.equals(this.category, that.category) && Objects.equals(this.type, that.type) && Objects.equals(this.flavor, that.flavor) && Objects.equals(this.version, that.version) && Objects.equals(this.platformVersion, that.platformVersion) && Objects.equals(this.description, that.description) && Objects.equals(this.customSan, that.customSan) && Objects.equals(this.ipv6enable, that.ipv6enable) && Objects.equals(this.hostNetwork, that.hostNetwork) && Objects.equals(this.containerNetwork, that.containerNetwork) && Objects.equals(this.eniNetwork, that.eniNetwork) && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.billingMode, that.billingMode) && Objects.equals(this.masters, that.masters) && Objects.equals(this.kubernetesSvcIpRange, that.kubernetesSvcIpRange) && Objects.equals(this.clusterTags, that.clusterTags) && Objects.equals(this.kubeProxyMode, that.kubeProxyMode) && Objects.equals(this.az, that.az) && Objects.equals(this.extendParam, that.extendParam) && Objects.equals(this.supportIstio, that.supportIstio) && Objects.equals(this.configurationsOverride, that.configurationsOverride);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.type, this.flavor, this.version, this.platformVersion, this.description, this.customSan, this.ipv6enable, this.hostNetwork, this.containerNetwork, this.eniNetwork, this.authentication, this.billingMode, this.masters, this.kubernetesSvcIpRange, this.clusterTags, this.kubeProxyMode, this.az, this.extendParam, this.supportIstio, this.configurationsOverride);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ClusterSpec {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    flavor: ").append(this.toIndentedString(this.flavor)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    platformVersion: ").append(this.toIndentedString(this.platformVersion)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    customSan: ").append(this.toIndentedString(this.customSan)).append("\n");
        sb.append("    ipv6enable: ").append(this.toIndentedString(this.ipv6enable)).append("\n");
        sb.append("    hostNetwork: ").append(this.toIndentedString(this.hostNetwork)).append("\n");
        sb.append("    containerNetwork: ").append(this.toIndentedString(this.containerNetwork)).append("\n");
        sb.append("    eniNetwork: ").append(this.toIndentedString(this.eniNetwork)).append("\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    billingMode: ").append(this.toIndentedString(this.billingMode)).append("\n");
        sb.append("    masters: ").append(this.toIndentedString(this.masters)).append("\n");
        sb.append("    kubernetesSvcIpRange: ").append(this.toIndentedString(this.kubernetesSvcIpRange)).append("\n");
        sb.append("    clusterTags: ").append(this.toIndentedString(this.clusterTags)).append("\n");
        sb.append("    kubeProxyMode: ").append(this.toIndentedString(this.kubeProxyMode)).append("\n");
        sb.append("    az: ").append(this.toIndentedString(this.az)).append("\n");
        sb.append("    extendParam: ").append(this.toIndentedString(this.extendParam)).append("\n");
        sb.append("    supportIstio: ").append(this.toIndentedString(this.supportIstio)).append("\n");
        sb.append("    configurationsOverride: ").append(this.toIndentedString(this.configurationsOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class KubeProxyModeEnum {
        public static final KubeProxyModeEnum IPTABLES = new KubeProxyModeEnum("iptables");
        public static final KubeProxyModeEnum IPVS = new KubeProxyModeEnum("ipvs");
        private static final Map<String, KubeProxyModeEnum> STATIC_FIELDS = KubeProxyModeEnum.createStaticFields();
        private String value;

        private static Map<String, KubeProxyModeEnum> createStaticFields() {
            HashMap<String, KubeProxyModeEnum> map = new HashMap<String, KubeProxyModeEnum>();
            map.put("iptables", IPTABLES);
            map.put("ipvs", IPVS);
            return Collections.unmodifiableMap(map);
        }

        KubeProxyModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KubeProxyModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new KubeProxyModeEnum(value));
        }

        public static KubeProxyModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof KubeProxyModeEnum) {
                return this.value.equals(((KubeProxyModeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class TypeEnum {
        public static final TypeEnum VIRTUALMACHINE = new TypeEnum("VirtualMachine");
        public static final TypeEnum ARM64 = new TypeEnum("ARM64");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("VirtualMachine", VIRTUALMACHINE);
            map.put("ARM64", ARM64);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class CategoryEnum {
        public static final CategoryEnum CCE = new CategoryEnum("CCE");
        public static final CategoryEnum TURBO = new CategoryEnum("Turbo");
        private static final Map<String, CategoryEnum> STATIC_FIELDS = CategoryEnum.createStaticFields();
        private String value;

        private static Map<String, CategoryEnum> createStaticFields() {
            HashMap<String, CategoryEnum> map = new HashMap<String, CategoryEnum>();
            map.put("CCE", CCE);
            map.put("Turbo", TURBO);
            return Collections.unmodifiableMap(map);
        }

        CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new CategoryEnum(value));
        }

        public static CategoryEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof CategoryEnum) {
                return this.value.equals(((CategoryEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

