/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cce.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cce.v3.model.ContainerCIDR;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class ContainerNetwork {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="mode")
    private ModeEnum mode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cidr")
    private String cidr;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="cidrs")
    private List<ContainerCIDR> cidrs = null;

    public ContainerNetwork withMode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public ContainerNetwork withCidr(String cidr) {
        this.cidr = cidr;
        return this;
    }

    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public ContainerNetwork withCidrs(List<ContainerCIDR> cidrs) {
        this.cidrs = cidrs;
        return this;
    }

    public ContainerNetwork addCidrsItem(ContainerCIDR cidrsItem) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<ContainerCIDR>();
        }
        this.cidrs.add(cidrsItem);
        return this;
    }

    public ContainerNetwork withCidrs(Consumer<List<ContainerCIDR>> cidrsSetter) {
        if (this.cidrs == null) {
            this.cidrs = new ArrayList<ContainerCIDR>();
        }
        cidrsSetter.accept(this.cidrs);
        return this;
    }

    public List<ContainerCIDR> getCidrs() {
        return this.cidrs;
    }

    public void setCidrs(List<ContainerCIDR> cidrs) {
        this.cidrs = cidrs;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerNetwork that = (ContainerNetwork)obj;
        return Objects.equals(this.mode, that.mode) && Objects.equals(this.cidr, that.cidr) && Objects.equals(this.cidrs, that.cidrs);
    }

    public int hashCode() {
        return Objects.hash(this.mode, this.cidr, this.cidrs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerNetwork {\n");
        sb.append("    mode: ").append(this.toIndentedString(this.mode)).append("\n");
        sb.append("    cidr: ").append(this.toIndentedString(this.cidr)).append("\n");
        sb.append("    cidrs: ").append(this.toIndentedString(this.cidrs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ModeEnum {
        public static final ModeEnum OVERLAY_L2 = new ModeEnum("overlay_l2");
        public static final ModeEnum VPC_ROUTER = new ModeEnum("vpc-router");
        public static final ModeEnum ENI = new ModeEnum("eni");
        private static final Map<String, ModeEnum> STATIC_FIELDS = ModeEnum.createStaticFields();
        private String value;

        private static Map<String, ModeEnum> createStaticFields() {
            HashMap<String, ModeEnum> map = new HashMap<String, ModeEnum>();
            map.put("overlay_l2", OVERLAY_L2);
            map.put("vpc-router", VPC_ROUTER);
            map.put("eni", ENI);
            return Collections.unmodifiableMap(map);
        }

        ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ModeEnum(value));
        }

        public static ModeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModeEnum) {
                return this.value.equals(((ModeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

