/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cce.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cce.v3.model.MasterEIPRequestSpecSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class MasterEIPRequestSpec {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="action")
    private ActionEnum action;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="spec")
    private MasterEIPRequestSpecSpec spec;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="bandwidth")
    private String bandwidth;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="elasticIp")
    private String elasticIp;

    public MasterEIPRequestSpec withAction(ActionEnum action) {
        this.action = action;
        return this;
    }

    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public MasterEIPRequestSpec withSpec(MasterEIPRequestSpecSpec spec) {
        this.spec = spec;
        return this;
    }

    public MasterEIPRequestSpec withSpec(Consumer<MasterEIPRequestSpecSpec> specSetter) {
        if (this.spec == null) {
            this.spec = new MasterEIPRequestSpecSpec();
            specSetter.accept(this.spec);
        }
        return this;
    }

    public MasterEIPRequestSpecSpec getSpec() {
        return this.spec;
    }

    public void setSpec(MasterEIPRequestSpecSpec spec) {
        this.spec = spec;
    }

    public MasterEIPRequestSpec withBandwidth(String bandwidth) {
        this.bandwidth = bandwidth;
        return this;
    }

    public String getBandwidth() {
        return this.bandwidth;
    }

    public void setBandwidth(String bandwidth) {
        this.bandwidth = bandwidth;
    }

    public MasterEIPRequestSpec withElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
        return this;
    }

    public String getElasticIp() {
        return this.elasticIp;
    }

    public void setElasticIp(String elasticIp) {
        this.elasticIp = elasticIp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MasterEIPRequestSpec that = (MasterEIPRequestSpec)obj;
        return Objects.equals(this.action, that.action) && Objects.equals(this.spec, that.spec) && Objects.equals(this.bandwidth, that.bandwidth) && Objects.equals(this.elasticIp, that.elasticIp);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.spec, this.bandwidth, this.elasticIp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MasterEIPRequestSpec {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    bandwidth: ").append(this.toIndentedString(this.bandwidth)).append("\n");
        sb.append("    elasticIp: ").append(this.toIndentedString(this.elasticIp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class ActionEnum {
        public static final ActionEnum BIND = new ActionEnum("bind");
        public static final ActionEnum UNBIND = new ActionEnum("unbind");
        private static final Map<String, ActionEnum> STATIC_FIELDS = ActionEnum.createStaticFields();
        private String value;

        private static Map<String, ActionEnum> createStaticFields() {
            HashMap<String, ActionEnum> map = new HashMap<String, ActionEnum>();
            map.put("bind", BIND);
            map.put("unbind", UNBIND);
            return Collections.unmodifiableMap(map);
        }

        ActionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ActionEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new ActionEnum(value));
        }

        public static ActionEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActionEnum) {
                return this.value.equals(((ActionEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

