/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cce.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cce.v3.model.NodeManagement;
import com.huaweicloud.sdk.cce.v3.model.NodePoolNodeAutoscaling;
import com.huaweicloud.sdk.cce.v3.model.NodeSpec;
import com.huaweicloud.sdk.cce.v3.model.SecurityID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class NodePoolSpec {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nodeTemplate")
    private NodeSpec nodeTemplate;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="initialNodeCount")
    private Integer initialNodeCount;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="autoscaling")
    private NodePoolNodeAutoscaling autoscaling;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nodeManagement")
    private NodeManagement nodeManagement;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="podSecurityGroups")
    private List<SecurityID> podSecurityGroups = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="customSecurityGroups")
    private List<String> customSecurityGroups = null;

    public NodePoolSpec withType(TypeEnum type) {
        this.type = type;
        return this;
    }

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public NodePoolSpec withNodeTemplate(NodeSpec nodeTemplate) {
        this.nodeTemplate = nodeTemplate;
        return this;
    }

    public NodePoolSpec withNodeTemplate(Consumer<NodeSpec> nodeTemplateSetter) {
        if (this.nodeTemplate == null) {
            this.nodeTemplate = new NodeSpec();
            nodeTemplateSetter.accept(this.nodeTemplate);
        }
        return this;
    }

    public NodeSpec getNodeTemplate() {
        return this.nodeTemplate;
    }

    public void setNodeTemplate(NodeSpec nodeTemplate) {
        this.nodeTemplate = nodeTemplate;
    }

    public NodePoolSpec withInitialNodeCount(Integer initialNodeCount) {
        this.initialNodeCount = initialNodeCount;
        return this;
    }

    public Integer getInitialNodeCount() {
        return this.initialNodeCount;
    }

    public void setInitialNodeCount(Integer initialNodeCount) {
        this.initialNodeCount = initialNodeCount;
    }

    public NodePoolSpec withAutoscaling(NodePoolNodeAutoscaling autoscaling) {
        this.autoscaling = autoscaling;
        return this;
    }

    public NodePoolSpec withAutoscaling(Consumer<NodePoolNodeAutoscaling> autoscalingSetter) {
        if (this.autoscaling == null) {
            this.autoscaling = new NodePoolNodeAutoscaling();
            autoscalingSetter.accept(this.autoscaling);
        }
        return this;
    }

    public NodePoolNodeAutoscaling getAutoscaling() {
        return this.autoscaling;
    }

    public void setAutoscaling(NodePoolNodeAutoscaling autoscaling) {
        this.autoscaling = autoscaling;
    }

    public NodePoolSpec withNodeManagement(NodeManagement nodeManagement) {
        this.nodeManagement = nodeManagement;
        return this;
    }

    public NodePoolSpec withNodeManagement(Consumer<NodeManagement> nodeManagementSetter) {
        if (this.nodeManagement == null) {
            this.nodeManagement = new NodeManagement();
            nodeManagementSetter.accept(this.nodeManagement);
        }
        return this;
    }

    public NodeManagement getNodeManagement() {
        return this.nodeManagement;
    }

    public void setNodeManagement(NodeManagement nodeManagement) {
        this.nodeManagement = nodeManagement;
    }

    public NodePoolSpec withPodSecurityGroups(List<SecurityID> podSecurityGroups) {
        this.podSecurityGroups = podSecurityGroups;
        return this;
    }

    public NodePoolSpec addPodSecurityGroupsItem(SecurityID podSecurityGroupsItem) {
        if (this.podSecurityGroups == null) {
            this.podSecurityGroups = new ArrayList<SecurityID>();
        }
        this.podSecurityGroups.add(podSecurityGroupsItem);
        return this;
    }

    public NodePoolSpec withPodSecurityGroups(Consumer<List<SecurityID>> podSecurityGroupsSetter) {
        if (this.podSecurityGroups == null) {
            this.podSecurityGroups = new ArrayList<SecurityID>();
        }
        podSecurityGroupsSetter.accept(this.podSecurityGroups);
        return this;
    }

    public List<SecurityID> getPodSecurityGroups() {
        return this.podSecurityGroups;
    }

    public void setPodSecurityGroups(List<SecurityID> podSecurityGroups) {
        this.podSecurityGroups = podSecurityGroups;
    }

    public NodePoolSpec withCustomSecurityGroups(List<String> customSecurityGroups) {
        this.customSecurityGroups = customSecurityGroups;
        return this;
    }

    public NodePoolSpec addCustomSecurityGroupsItem(String customSecurityGroupsItem) {
        if (this.customSecurityGroups == null) {
            this.customSecurityGroups = new ArrayList<String>();
        }
        this.customSecurityGroups.add(customSecurityGroupsItem);
        return this;
    }

    public NodePoolSpec withCustomSecurityGroups(Consumer<List<String>> customSecurityGroupsSetter) {
        if (this.customSecurityGroups == null) {
            this.customSecurityGroups = new ArrayList<String>();
        }
        customSecurityGroupsSetter.accept(this.customSecurityGroups);
        return this;
    }

    public List<String> getCustomSecurityGroups() {
        return this.customSecurityGroups;
    }

    public void setCustomSecurityGroups(List<String> customSecurityGroups) {
        this.customSecurityGroups = customSecurityGroups;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodePoolSpec that = (NodePoolSpec)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.nodeTemplate, that.nodeTemplate) && Objects.equals(this.initialNodeCount, that.initialNodeCount) && Objects.equals(this.autoscaling, that.autoscaling) && Objects.equals(this.nodeManagement, that.nodeManagement) && Objects.equals(this.podSecurityGroups, that.podSecurityGroups) && Objects.equals(this.customSecurityGroups, that.customSecurityGroups);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.nodeTemplate, this.initialNodeCount, this.autoscaling, this.nodeManagement, this.podSecurityGroups, this.customSecurityGroups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodePoolSpec {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    nodeTemplate: ").append(this.toIndentedString(this.nodeTemplate)).append("\n");
        sb.append("    initialNodeCount: ").append(this.toIndentedString(this.initialNodeCount)).append("\n");
        sb.append("    autoscaling: ").append(this.toIndentedString(this.autoscaling)).append("\n");
        sb.append("    nodeManagement: ").append(this.toIndentedString(this.nodeManagement)).append("\n");
        sb.append("    podSecurityGroups: ").append(this.toIndentedString(this.podSecurityGroups)).append("\n");
        sb.append("    customSecurityGroups: ").append(this.toIndentedString(this.customSecurityGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class TypeEnum {
        public static final TypeEnum VM = new TypeEnum("vm");
        public static final TypeEnum ELASTICBMS = new TypeEnum("ElasticBMS");
        public static final TypeEnum PM = new TypeEnum("pm");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("vm", VM);
            map.put("ElasticBMS", ELASTICBMS);
            map.put("pm", PM);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new TypeEnum(value));
        }

        public static TypeEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

