/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cce.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cce.v3.model.NodePoolCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class NodePoolStatus {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="currentNode")
    private Integer currentNode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="creatingNode")
    private Integer creatingNode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="deletingNode")
    private Integer deletingNode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="phase")
    private PhaseEnum phase;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="jobId")
    private String jobId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="conditions")
    private List<NodePoolCondition> conditions = null;

    public NodePoolStatus withCurrentNode(Integer currentNode) {
        this.currentNode = currentNode;
        return this;
    }

    public Integer getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Integer currentNode) {
        this.currentNode = currentNode;
    }

    public NodePoolStatus withCreatingNode(Integer creatingNode) {
        this.creatingNode = creatingNode;
        return this;
    }

    public Integer getCreatingNode() {
        return this.creatingNode;
    }

    public void setCreatingNode(Integer creatingNode) {
        this.creatingNode = creatingNode;
    }

    public NodePoolStatus withDeletingNode(Integer deletingNode) {
        this.deletingNode = deletingNode;
        return this;
    }

    public Integer getDeletingNode() {
        return this.deletingNode;
    }

    public void setDeletingNode(Integer deletingNode) {
        this.deletingNode = deletingNode;
    }

    public NodePoolStatus withPhase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    public PhaseEnum getPhase() {
        return this.phase;
    }

    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public NodePoolStatus withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public NodePoolStatus withConditions(List<NodePoolCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public NodePoolStatus addConditionsItem(NodePoolCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NodePoolCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    public NodePoolStatus withConditions(Consumer<List<NodePoolCondition>> conditionsSetter) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<NodePoolCondition>();
        }
        conditionsSetter.accept(this.conditions);
        return this;
    }

    public List<NodePoolCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<NodePoolCondition> conditions) {
        this.conditions = conditions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodePoolStatus that = (NodePoolStatus)obj;
        return Objects.equals(this.currentNode, that.currentNode) && Objects.equals(this.creatingNode, that.creatingNode) && Objects.equals(this.deletingNode, that.deletingNode) && Objects.equals(this.phase, that.phase) && Objects.equals(this.jobId, that.jobId) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.currentNode, this.creatingNode, this.deletingNode, this.phase, this.jobId, this.conditions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NodePoolStatus {\n");
        sb.append("    currentNode: ").append(this.toIndentedString(this.currentNode)).append("\n");
        sb.append("    creatingNode: ").append(this.toIndentedString(this.creatingNode)).append("\n");
        sb.append("    deletingNode: ").append(this.toIndentedString(this.deletingNode)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class PhaseEnum {
        public static final PhaseEnum SYNCHRONIZING = new PhaseEnum("Synchronizing");
        public static final PhaseEnum SYNCHRONIZED = new PhaseEnum("Synchronized");
        public static final PhaseEnum SOLDOUT = new PhaseEnum("SoldOut");
        public static final PhaseEnum DELETING = new PhaseEnum("Deleting");
        public static final PhaseEnum ERROR = new PhaseEnum("Error");
        private static final Map<String, PhaseEnum> STATIC_FIELDS = PhaseEnum.createStaticFields();
        private String value;

        private static Map<String, PhaseEnum> createStaticFields() {
            HashMap<String, PhaseEnum> map = new HashMap<String, PhaseEnum>();
            map.put("Synchronizing", SYNCHRONIZING);
            map.put("Synchronized", SYNCHRONIZED);
            map.put("SoldOut", SOLDOUT);
            map.put("Deleting", DELETING);
            map.put("Error", ERROR);
            return Collections.unmodifiableMap(map);
        }

        PhaseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PhaseEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new PhaseEnum(value));
        }

        public static PhaseEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof PhaseEnum) {
                return this.value.equals(((PhaseEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

