/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.cce.v3.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.huaweicloud.sdk.cce.v3.model.ResourceRequirements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class PersistentVolumeClaimSpec {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="volumeID")
    private String volumeID;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="storageType")
    private String storageType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="accessModes")
    private List<AccessModesEnum> accessModes = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="storageClassName")
    private String storageClassName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="volumeName")
    private String volumeName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="resources")
    private ResourceRequirements resources;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="volumeMode")
    private String volumeMode;

    public PersistentVolumeClaimSpec withVolumeID(String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public PersistentVolumeClaimSpec withStorageType(String storageType) {
        this.storageType = storageType;
        return this;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public PersistentVolumeClaimSpec withAccessModes(List<AccessModesEnum> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public PersistentVolumeClaimSpec addAccessModesItem(AccessModesEnum accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<AccessModesEnum>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    public PersistentVolumeClaimSpec withAccessModes(Consumer<List<AccessModesEnum>> accessModesSetter) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<AccessModesEnum>();
        }
        accessModesSetter.accept(this.accessModes);
        return this;
    }

    public List<AccessModesEnum> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<AccessModesEnum> accessModes) {
        this.accessModes = accessModes;
    }

    public PersistentVolumeClaimSpec withStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public PersistentVolumeClaimSpec withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public PersistentVolumeClaimSpec withResources(ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    public PersistentVolumeClaimSpec withResources(Consumer<ResourceRequirements> resourcesSetter) {
        if (this.resources == null) {
            this.resources = new ResourceRequirements();
            resourcesSetter.accept(this.resources);
        }
        return this;
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(ResourceRequirements resources) {
        this.resources = resources;
    }

    public PersistentVolumeClaimSpec withVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return this;
    }

    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentVolumeClaimSpec that = (PersistentVolumeClaimSpec)obj;
        return Objects.equals(this.volumeID, that.volumeID) && Objects.equals(this.storageType, that.storageType) && Objects.equals(this.accessModes, that.accessModes) && Objects.equals(this.storageClassName, that.storageClassName) && Objects.equals(this.volumeName, that.volumeName) && Objects.equals(this.resources, that.resources) && Objects.equals(this.volumeMode, that.volumeMode);
    }

    public int hashCode() {
        return Objects.hash(this.volumeID, this.storageType, this.accessModes, this.storageClassName, this.volumeName, this.resources, this.volumeMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PersistentVolumeClaimSpec {\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("    storageType: ").append(this.toIndentedString(this.storageType)).append("\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    volumeMode: ").append(this.toIndentedString(this.volumeMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class AccessModesEnum {
        public static final AccessModesEnum READONLYMANY = new AccessModesEnum("ReadOnlyMany");
        public static final AccessModesEnum READWRITEMANY = new AccessModesEnum("ReadWriteMany");
        private static final Map<String, AccessModesEnum> STATIC_FIELDS = AccessModesEnum.createStaticFields();
        private String value;

        private static Map<String, AccessModesEnum> createStaticFields() {
            HashMap<String, AccessModesEnum> map = new HashMap<String, AccessModesEnum>();
            map.put("ReadOnlyMany", READONLYMANY);
            map.put("ReadWriteMany", READWRITEMANY);
            return Collections.unmodifiableMap(map);
        }

        AccessModesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccessModesEnum fromValue(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElse(new AccessModesEnum(value));
        }

        public static AccessModesEnum valueOf(String value) {
            if (value == null) {
                return null;
            }
            return Optional.ofNullable(STATIC_FIELDS.get(value)).orElseThrow(() -> new IllegalArgumentException("Unexpected value '" + value + "'"));
        }

        public boolean equals(Object obj) {
            if (obj instanceof AccessModesEnum) {
                return this.value.equals(((AccessModesEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

