/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.bspay.sdk.opps.core.net;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.BasePay;
import com.huifu.bspay.sdk.opps.core.config.MerConfig;
import com.huifu.bspay.sdk.opps.core.enums.ServerTypeEnum;
import com.huifu.bspay.sdk.opps.core.exception.BasePayException;
import com.huifu.bspay.sdk.opps.core.exception.FailureCode;
import com.huifu.bspay.sdk.opps.core.sign.JsonUtils;
import com.huifu.bspay.sdk.opps.core.utils.HttpClientUtils;
import com.huifu.bspay.sdk.opps.core.utils.RsaUtils;
import com.huifu.bspay.sdk.opps.core.utils.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRequest {
    public static final String SDK_VERSION = "3.0.30";

    protected static Map<String, Object> requestBasePayCore(RequestMethod method, String uri, Map<String, Object> params, MerConfig config, boolean isPage) throws BasePayException {
        return AbstractRequest.requestBasePayCore(method, uri, params, null, null, config, null, isPage);
    }

    protected static Map<String, Object> requestBasePayCore(RequestMethod method, String uri, Map<String, Object> params, MerConfig config, ServerTypeEnum serverType, boolean isPage) throws BasePayException {
        return AbstractRequest.requestBasePayCore(method, uri, params, null, null, config, serverType, isPage);
    }

    public static String getUrl() {
        String baseUrl;
        switch (BasePay.prodMode) {
            case "test": {
                baseUrl = "https://opps-stbmertest.testpnr.com";
                break;
            }
            case "inner_test": {
                baseUrl = "https://spin-test.cloudpnr.com";
                break;
            }
            default: {
                baseUrl = "https://api.huifu.com";
            }
        }
        return baseUrl;
    }

    protected static Map<String, Object> requestBasePayCore(RequestMethod method, String uri, Map<String, Object> params, File file, String fileParam, MerConfig config, ServerTypeEnum serverType, boolean isPage) throws BasePayException {
        boolean checkSign;
        String requestSign;
        String baseUrl = AbstractRequest.getUrl();
        if (ServerTypeEnum.PAGE.equals((Object)serverType)) {
            baseUrl = AbstractRequest.getUrl();
        }
        if (params != null && params.get("base_url") != null) {
            baseUrl = (String)params.get("base_url");
            params.remove("base_url");
        }
        StringBuilder requestUrl = new StringBuilder(baseUrl);
        if (!baseUrl.endsWith("/")) {
            requestUrl.append("/");
        }
        requestUrl.append(uri);
        String back = null;
        HashMap<String, String> headers = new HashMap<String, String>(4);
        headers.put("sdk_version", "javaSDK_3.0.30");
        String reqData = JSONObject.toJSONString(params);
        String privateKey = config.getRsaPrivateKey();
        if (BasePay.debug) {
            System.out.println("PRIVATE_KEY=" + privateKey);
        }
        try {
            String sortedData = JsonUtils.sort4JsonString(reqData, 0);
            requestSign = RsaUtils.sign(sortedData, privateKey);
        }
        catch (Exception e) {
            if (BasePay.debug) {
                e.printStackTrace();
            }
            requestSign = null;
        }
        if (requestSign == null || requestSign.length() == 0) {
            throw new BasePayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Sign error. Please check your privateKey.");
        }
        if (BasePay.debug) {
            System.out.println("request sign=" + requestSign);
        }
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("sys_id", config.getSysId());
        request.put("data", JSONObject.parseObject((String)reqData));
        request.put("sign", requestSign);
        request.put("product_id", config.getProcutId());
        String requestBody = JSON.toJSONString(request);
        if (BasePay.debug) {
            System.out.println("request data = " + JSONObject.parseObject((String)reqData));
            System.out.println("requestBody param = " + requestBody);
        }
        if (RequestMethod.POST == method && file == null && "v2/supplementary/picture".equals(uri)) {
            back = HttpClientUtils.httpPostNoFile(requestUrl.toString(), headers, request, null, fileParam);
        } else if (RequestMethod.POST == method && file == null) {
            headers.put("Content-type", "application/json");
            back = HttpClientUtils.httpPostJson(requestUrl.toString(), headers, requestBody);
        } else if (RequestMethod.POST == method && file != null) {
            back = HttpClientUtils.httpPostFile(requestUrl.toString(), headers, request, file, fileParam);
        } else if (RequestMethod.GET == method) {
            back = HttpClientUtils.httpGet(requestUrl.toString(), headers, params);
        }
        if (BasePay.debug) {
            System.out.println("response string=" + back);
        }
        if (back == null || back.length() == 0) {
            throw new BasePayException(FailureCode.SYSTEM_EXCEPTION.getFailureCode(), "Request no response. Please check your network.");
        }
        if (BasePay.debug) {
            System.out.println("Is a version of the page=" + isPage);
        }
        if (isPage) {
            JSONObject data = new JSONObject();
            data.put("data", (Object)back);
            return data;
        }
        JSONObject jo = JSON.parseObject((String)back);
        JSONObject data = jo.getJSONObject("data");
        String sign = jo.getString("sign");
        String publicKey = config.getRsaPublicKey();
        if (StringUtil.isEmpty(publicKey)) {
            publicKey = BasePay.HUIFU_DEFAULT_PUBLIC_KEY;
        }
        if (BasePay.debug) {
            System.out.println("PUBLIC_KEY=" + publicKey);
            System.out.println("response data=" + data);
            System.out.println("response sign:" + sign);
        }
        try {
            String sortedData = JsonUtils.sort4JsonString(JSONObject.toJSONString((Object)data), 5);
            checkSign = RsaUtils.verify(sortedData, publicKey, sign);
        }
        catch (Exception e) {
            if (BasePay.debug) {
                e.printStackTrace();
            }
            checkSign = false;
        }
        if (!checkSign) {
            if (BasePay.debug) {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            }
            throw new BasePayException(FailureCode.SECURITY_EXCEPTION.getFailureCode(), "Response sign check error. Please check your pubkey.");
        }
        return data;
    }

    public static String getOriginalStr(Map<String, Object> map) {
        ArrayList<String> listKeys = new ArrayList<String>(map.keySet());
        Collections.sort(listKeys);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < listKeys.size(); ++i) {
            if (map.get(listKeys.get(i)) == null || map.get(listKeys.get(i)).toString().length() == 0) continue;
            stringBuilder.append((String)listKeys.get(i)).append("=").append(map.get(listKeys.get(i))).append("&");
        }
        return stringBuilder.length() == 0 ? "" : stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    protected static enum RequestMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

