/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.bspay.sdk.opps.core.utils;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTools {
    public static final String DATE_TIME_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String DATE_YYYYMMDD = "yyyyMMdd";
    public static final String HHMMSS = "HHmmss";
    private static final String DATE_TIME_YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String LONG_OTHER_FORMAT = "yyyy/MM/dd HH:mm:ss";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final String yyyyMMdd = "yyyyMMdd";
    public static final String HHmmss = "HHmmss";
    private static final DateTimeFormatter DATE_TIME_YYYYMMDDHHMMSSSSS_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    private static final DateTimeFormatter DATE_TIME_YYYYMMDDHHMMSS_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter DATE_YYYYMMDD_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter YYMM_FORMATTER = DateTimeFormatter.ofPattern("HHmmss");
    private static ThreadLocal<SimpleDateFormat> ACCURATE_OTHER_DATEYYYYMMDDHHMMSS = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat(DateTools.LONG_OTHER_FORMAT);
        }
    };

    public static String getCurrentDateTimeYYYYMMDDHHMMSS() {
        return DATE_TIME_YYYYMMDDHHMMSS_FORMATTER.format(LocalDateTime.now());
    }

    public static String getCurrentDateTimeYYYYMMDDHHMMSSSSS() {
        return DATE_TIME_YYYYMMDDHHMMSSSSS_FORMATTER.format(LocalDateTime.now());
    }

    public static String getHHMMSS() {
        return YYMM_FORMATTER.format(LocalDateTime.now());
    }

    public static String getCurrentDateYYYYMMDD() {
        return DATE_YYYYMMDD_FORMATTER.format(LocalDateTime.now());
    }

    public static boolean checkDateYYYYMMDD(String dateStr) {
        try {
            DATE_YYYYMMDD_FORMATTER.parse(dateStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getOtherCurDateYYYYMMDD(Date date) {
        return ACCURATE_OTHER_DATEYYYYMMDDHHMMSS.get().format(date);
    }

    public static Date fromDateStringyyyyMMdd(String dateString) {
        try {
            return Date.from(ZonedDateTime.parse(dateString, DATE_YYYYMMDD_FORMATTER).toInstant());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date fromDateStringyyyyMMddHHMMSS(String dateString) {
        try {
            return Date.from(ZonedDateTime.parse(dateString, DATE_TIME_YYYYMMDDHHMMSS_FORMATTER).toInstant());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatYYYYMMDDHHSS(Date date) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            if (date != null) {
                return sf.format(date);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String formatYYYYMMDD(Date date) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd");
        try {
            if (date != null) {
                return sf.format(date);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String dateToDateString(Date date, String formatStr) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat df = DateTools.getDateFormat(formatStr);
        return df.format(date);
    }

    public static SimpleDateFormat getDateFormat(String formatStr) {
        return new SimpleDateFormat(formatStr);
    }
}

