/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.beetl.core.NativeSecurityManager;

public class WhiteListNativeSecurityManager
implements NativeSecurityManager {
    Pattern callPattern = null;

    public WhiteListNativeSecurityManager() {
        this.allow(Arrays.asList("java.util"));
    }

    @Override
    public boolean permit(Object resourceId, Class c, Object target, String method) {
        if (c.isArray()) {
            return true;
        }
        String name = c.getName();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return true;
        }
        return this.callPattern.matcher(name).matches();
    }

    public void allow(List<String> calls) {
        StringBuilder sb = new StringBuilder();
        for (String pkg : calls) {
            int c = pkg.lastIndexOf(46);
            boolean classCall = false;
            if (Character.isUpperCase(pkg.charAt(c + 1))) {
                classCall = true;
            }
            if (classCall) {
                sb.append(pkg.replace(".", "\\."));
            } else {
                sb.append(pkg.replace(".", "\\.")).append("\\..*");
            }
            sb.append("|");
        }
        sb.setLength(sb.length() - 1);
        this.callPattern = Pattern.compile(sb.toString());
    }

    public static void main(String[] args) {
        List<String> pkgs = Arrays.asList("java.util", "java.io");
        StringBuilder sb = new StringBuilder();
        for (String pkg : pkgs) {
            int c = pkg.lastIndexOf(46);
            boolean classCall = false;
            if (Character.isUpperCase(pkg.charAt(c + 1))) {
                classCall = true;
            }
            if (classCall) {
                sb.append(pkg.replace(".", "\\."));
            } else {
                sb.append(pkg.replace(".", "\\.")).append("\\..*");
            }
            sb.append("|");
        }
        sb.setLength(sb.length() - 1);
        Pattern pattern = Pattern.compile(sb.toString());
        String call = "java.io.c1";
        System.out.println(pattern.matcher(call).matches());
    }
}

