/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ProgramBuilderContext;
import org.beetl.core.TagFactory;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.MVCStrictException;
import org.beetl.core.exception.NativeNotAllowedException;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.parser.BeetlParser;
import org.beetl.core.statement.ASTNode;
import org.beetl.core.statement.AjaxStatement;
import org.beetl.core.statement.AndExpression;
import org.beetl.core.statement.ArthExpression;
import org.beetl.core.statement.BlockStatement;
import org.beetl.core.statement.BreakStatement;
import org.beetl.core.statement.CompareExpression;
import org.beetl.core.statement.ContentBodyExpression;
import org.beetl.core.statement.ContinueStatement;
import org.beetl.core.statement.DirectiveStatement;
import org.beetl.core.statement.EndStatement;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.ExpressionRuntime;
import org.beetl.core.statement.ForStatement;
import org.beetl.core.statement.FormatExpression;
import org.beetl.core.statement.FunctionExpression;
import org.beetl.core.statement.GeneralForStatement;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.IGoto;
import org.beetl.core.statement.IfStatement;
import org.beetl.core.statement.IncDecExpression;
import org.beetl.core.statement.JsonArrayExpression;
import org.beetl.core.statement.JsonMapExpression;
import org.beetl.core.statement.Literal;
import org.beetl.core.statement.NativeCallExpression;
import org.beetl.core.statement.NegExpression;
import org.beetl.core.statement.NotBooleanExpression;
import org.beetl.core.statement.OrExpression;
import org.beetl.core.statement.PlaceholderST;
import org.beetl.core.statement.ProgramMetaData;
import org.beetl.core.statement.ReturnStatement;
import org.beetl.core.statement.SafePlaceholderST;
import org.beetl.core.statement.SelectStatement;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.StatementExpression;
import org.beetl.core.statement.StaticTextASTNode;
import org.beetl.core.statement.StaticTextByteASTNode;
import org.beetl.core.statement.SwitchStatement;
import org.beetl.core.statement.TagStatement;
import org.beetl.core.statement.TagVarBindingStatement;
import org.beetl.core.statement.TernaryExpression;
import org.beetl.core.statement.TryCatchStatement;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarAssignExpression;
import org.beetl.core.statement.VarAssignStatement;
import org.beetl.core.statement.VarAssignStatementSeq;
import org.beetl.core.statement.VarAttribute;
import org.beetl.core.statement.VarDefineNode;
import org.beetl.core.statement.VarRef;
import org.beetl.core.statement.VarRefAssignStatement;
import org.beetl.core.statement.VarSquareAttribute;
import org.beetl.core.statement.VarVirtualAttribute;
import org.beetl.core.statement.WhileStatement;
import org.beetl.core.statement.nat.ClassNode;
import org.beetl.core.statement.nat.InstanceNode;
import org.beetl.core.statement.nat.NativeArrayNode;
import org.beetl.core.statement.nat.NativeAtrributeNode;
import org.beetl.core.statement.nat.NativeMethodNode;
import org.beetl.core.statement.nat.NativeNode;

public class AntlrProgramBuilder {
    ProgramMetaData data = new ProgramMetaData();
    ProgramBuilderContext pbCtx = new ProgramBuilderContext();
    Expression[] EMPTY_EXPRESSION = new Expression[0];
    GroupTemplate gt;
    static EndStatement endStatment = new EndStatement();

    public AntlrProgramBuilder(GroupTemplate gt) {
        this.gt = gt;
    }

    public ProgramMetaData build(ParseTree tree) {
        int size = tree.getChildCount() - 1;
        ArrayList<Statement> ls = new ArrayList<Statement>(size);
        for (int i = 0; i < size; ++i) {
            Statement st = this.parseStatment((ParserRuleContext)tree.getChild(i));
            if (st == null) continue;
            ls.add(st);
        }
        if (this.pbCtx.current.gotoValue == 3 || this.pbCtx.current.gotoValue == 2) {
            this.data.hasGoto = true;
        }
        this.pbCtx.anzlyszeGlobal();
        this.pbCtx.anzlyszeLocal();
        this.data.varIndexSize = this.pbCtx.varIndexSize;
        this.data.tempVarStartIndex = this.pbCtx.globalIndexMap.size();
        this.data.statements = ls.toArray(new Statement[0]);
        this.data.globalIndexMap = this.pbCtx.globalIndexMap;
        this.data.globalVarAttr = this.pbCtx.globaVarAttr;
        this.data.setTemplateRootScopeIndexMap(this.pbCtx.rootIndexMap);
        return this.data;
    }

    private Statement parseStatment(ParserRuleContext node) {
        if (node == null) {
            return null;
        }
        if (node instanceof BeetlParser.VarStContext) {
            VarAssignStatementSeq varSeq = this.parseVarSt((BeetlParser.VarStContext)node);
            if (this.gt.conf.isStrict) {
                throw new MVCStrictException(varSeq.token);
            }
            return varSeq;
        }
        if (node instanceof BeetlParser.BlockStContext) {
            BeetlParser.BlockStContext bc = (BeetlParser.BlockStContext)node;
            BlockStatement block = this.parseBlock(bc.block().statement(), node);
            return block;
        }
        if (node instanceof BeetlParser.TextOutputStContext) {
            return this.parseTextOutputSt((BeetlParser.TextOutputStContext)node);
        }
        if (node instanceof BeetlParser.ReturnStContext) {
            BeetlParser.ReturnStContext rtnCtx = (BeetlParser.ReturnStContext)node;
            BeetlParser.ExpressionContext expCtx = rtnCtx.expression();
            Expression exp = null;
            if (expCtx != null) {
                exp = this.parseExpress(expCtx);
            }
            ReturnStatement st = new ReturnStatement(exp, null);
            this.pbCtx.current.gotoValue = 3;
            return st;
        }
        if (node instanceof BeetlParser.BreakStContext) {
            BreakStatement st = new BreakStatement(null);
            if (this.pbCtx.current.gotoValue != 3) {
                this.pbCtx.current.gotoValue = 2;
            }
            return st;
        }
        if (node instanceof BeetlParser.ContinueStContext) {
            ContinueStatement st = new ContinueStatement(null);
            if (this.pbCtx.current.gotoValue != 3) {
                this.pbCtx.current.gotoValue = 1;
            }
            return st;
        }
        if (node instanceof BeetlParser.ForStContext) {
            return this.parseForSt((BeetlParser.ForStContext)node);
        }
        if (node instanceof BeetlParser.StaticOutputStContext) {
            BeetlParser.StaticOutputStContext st = (BeetlParser.StaticOutputStContext)node;
            BeetlParser.ConstantsTextStatmentContext cst = st.constantsTextStatment();
            String str = cst.DecimalLiteral().getSymbol().getText();
            int position = Integer.parseInt(str);
            if (!this.gt.getConf().directByteOutput) {
                StaticTextASTNode textNode = new StaticTextASTNode(position, null);
                return textNode;
            }
            StaticTextByteASTNode textNode = new StaticTextByteASTNode(position, null);
            return textNode;
        }
        if (node instanceof BeetlParser.IfStContext) {
            return this.parseIf((BeetlParser.IfStContext)node);
        }
        if (node instanceof BeetlParser.StatmentExpStContext) {
            BeetlParser.StatementExpressionContext sec = ((BeetlParser.StatmentExpStContext)node).statementExpression();
            Expression expression = this.parseExpress(sec.expression());
            StatementExpression se = new StatementExpression(expression, null);
            return se;
        }
        if (node instanceof BeetlParser.DirectiveStContext) {
            return this.parseDirectiveStatement((BeetlParser.DirectiveStContext)node);
        }
        if (node instanceof BeetlParser.CommentTagStContext) {
            BeetlParser.CommentTypeTagContext typeCtx = ((BeetlParser.CommentTagStContext)node).commentTypeTag();
            this.parseCommentTag(typeCtx);
            return null;
        }
        if (node instanceof BeetlParser.TryStContext) {
            return this.parseTryCatch((BeetlParser.TryStContext)node);
        }
        if (node instanceof BeetlParser.FunctionTagStContext) {
            BeetlParser.FunctionTagStContext fc = (BeetlParser.FunctionTagStContext)node;
            return this.parseTag(fc.functionTagCall());
        }
        if (node instanceof BeetlParser.WhileStContext) {
            return this.parseWhile((BeetlParser.WhileStContext)node);
        }
        if (node instanceof BeetlParser.AssignStContext) {
            VarAssignStatement vas = this.parseAssign(((BeetlParser.AssignStContext)node).assignMent());
            this.pbCtx.setVarPosition(vas.token.text, vas);
            return vas;
        }
        if (node instanceof BeetlParser.SiwchStContext) {
            return this.parseSwitch((BeetlParser.SiwchStContext)node);
        }
        if (node instanceof BeetlParser.SelectStContext) {
            BeetlParser.SelectStContext selectCtx = (BeetlParser.SelectStContext)node;
            return this.parseSelect(selectCtx);
        }
        if (node instanceof BeetlParser.AjaxStContext) {
            return this.parseAjax((BeetlParser.AjaxStContext)node);
        }
        if (node instanceof BeetlParser.EndContext) {
            return endStatment;
        }
        throw new UnsupportedOperationException("\u672a\u8bc6\u522b\uff0c\u786e\u8ba4\u6a21\u677f\u4e66\u5199\u662f\u5426\u6b63\u786e");
    }

    protected SelectStatement parseSelect(BeetlParser.SelectStContext selectCtx) {
        BeetlParser.G_switchStatmentContext ctx = selectCtx.g_switchStatment();
        BeetlParser.ExpressionContext exp = ctx.expression();
        Expression base = exp != null ? this.parseExpress(exp) : null;
        List<BeetlParser.G_caseStatmentContext> caseCtxList = ctx.g_caseStatment();
        LinkedList<Expression> condtionList = new LinkedList<Expression>();
        LinkedList<BlockStatement> blockList = new LinkedList<BlockStatement>();
        for (BeetlParser.G_caseStatmentContext caseCtx : caseCtxList) {
            List<BeetlParser.ExpressionContext> expCtxList = caseCtx.expression();
            List<BeetlParser.StatementContext> statCtxList = caseCtx.statement();
            BlockStatement block = this.parseBlock(statCtxList, caseCtx);
            for (BeetlParser.ExpressionContext expCtx : expCtxList) {
                Expression condition = this.parseExpress(expCtx);
                condtionList.add(condition);
                blockList.add(block);
            }
        }
        BlockStatement defaultStatement = null;
        BeetlParser.G_defaultStatmentContext defaultCtx = ctx.g_defaultStatment();
        if (defaultCtx != null) {
            List<BeetlParser.StatementContext> defaultCtxList = ctx.g_defaultStatment().statement();
            defaultStatement = this.parseBlock(defaultCtxList, ctx);
        }
        SelectStatement select = new SelectStatement(base, condtionList.toArray(new Expression[0]), blockList.toArray(new BlockStatement[0]), defaultStatement, this.getBTToken(selectCtx.Select().getSymbol()));
        return select;
    }

    protected AjaxStatement parseAjax(BeetlParser.AjaxStContext ajaxCtx) {
        String anchor;
        GrammarToken token = null;
        String flag = "render";
        List<TerminalNode> nodes = ajaxCtx.Identifier();
        if (nodes.size() == 1) {
            token = this.getBTToken(nodes.get(0).getSymbol());
        } else {
            token = this.getBTToken(nodes.get(1).getSymbol());
            flag = nodes.get(0).getSymbol().getText();
            if (!flag.equals("render") && !flag.equals("norender")) {
                BeetlException be = new BeetlException("AJAX_PROPERTY_ERROR", "expect render or norender ,but " + flag);
                be.pushToken(token);
                throw be;
            }
        }
        BeetlParser.BlockContext blockCtx = ajaxCtx.block();
        BlockStatement block = this.parseBlock(blockCtx.statement(), blockCtx);
        AjaxStatement ajaxStat = new AjaxStatement(block, token, flag.equals("render"));
        if (this.data.ajaxs == null) {
            this.data.ajaxs = new HashMap<String, AjaxStatement>();
        }
        if (this.data.ajaxs.containsKey(anchor = ajaxStat.token.text)) {
            GrammarToken lastToken = this.data.ajaxs.get((Object)anchor).token;
            BeetlException ex = new BeetlException("AJAX_ALREADY_DEFINED", "\u5df2\u7ecf\u5728\u7b2c" + lastToken.line + "\u884c\u5b9a\u4e49");
            ex.pushToken(token);
            throw ex;
        }
        this.data.ajaxs.put(anchor, ajaxStat);
        return ajaxStat;
    }

    protected SwitchStatement parseSwitch(BeetlParser.SiwchStContext sctx) {
        BeetlParser.ExpressionContext ect = sctx.parExpression().expression();
        Expression exp = this.parseExpress(ect);
        List<BeetlParser.SwitchBlockStatementGroupContext> list = sctx.switchBlock().switchBlockStatementGroup();
        LinkedHashMap<Expression, BlockStatement> condtionsStatementsMap = new LinkedHashMap<Expression, BlockStatement>();
        ArrayList<Expression> conditionList = new ArrayList<Expression>();
        BlockStatement defaultBlock = null;
        block0: for (BeetlParser.SwitchBlockStatementGroupContext group : list) {
            List<BeetlParser.SwitchLabelContext> labels = group.switchLabel();
            List<BeetlParser.StatementContext> stats = group.statement();
            BlockStatement block = stats != null ? this.parseBlock(stats, group) : null;
            for (BeetlParser.SwitchLabelContext label : labels) {
                Expression caseExp = this.parseExpress(label.expression());
                if (caseExp == null) {
                    defaultBlock = block;
                    continue block0;
                }
                conditionList.add(caseExp);
                condtionsStatementsMap.put(caseExp, block);
            }
        }
        SwitchStatement switchStat = new SwitchStatement(exp, condtionsStatementsMap, defaultBlock, this.getBTToken(sctx.getStart()));
        return switchStat;
    }

    protected VarAssignExpression parseAssingInExp(BeetlParser.AssignGeneralInExpContext agc) {
        VarAssignExpression vas = null;
        BeetlParser.ExpressionContext expCtx = agc.generalAssignExp().expression();
        Expression exp = this.parseExpress(expCtx);
        BeetlParser.VarRefContext varRefCtx = agc.generalAssignExp().varRef();
        if (varRefCtx.children.size() == 1) {
            Token token = varRefCtx.Identifier().getSymbol();
            if (this.pbCtx.hasDefined(token.getText()) != null) {
                vas = new VarAssignExpression(exp, this.getBTToken(token));
                this.registerVar(vas);
                return vas;
            }
            BeetlException ex = new BeetlException("VAR_NOT_DEFINED");
            ex.pushToken(this.getBTToken(token));
            throw ex;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\uff0c\u7a0d\u540e\u5728\u60f3");
    }

    protected void registerNewVar(ASTNode vas) {
        if (this.pbCtx.hasDefined(vas.token.text) != null) {
            GrammarToken token = this.pbCtx.hasDefined(vas.token.text);
            BeetlException ex = new BeetlException("VAR_ALREADY_DEFINED", "\u5df2\u7ecf\u5728\u7b2c" + token.line + "\u884c\u5b9a\u4e49");
            ex.pushToken(vas.token);
            throw ex;
        }
        this.pbCtx.addVar(vas.token.text);
        this.pbCtx.setVarPosition(vas.token.text, vas);
    }

    protected void registerVar(ASTNode vas) {
        this.pbCtx.setVarPosition(vas.token.text, vas);
    }

    protected VarAssignStatement parseAssign(BeetlParser.AssignMentContext amc) {
        VarAssignStatement vas = null;
        if (amc instanceof BeetlParser.AssignGeneralInStContext) {
            BeetlParser.AssignGeneralInStContext agc = (BeetlParser.AssignGeneralInStContext)amc;
            BeetlParser.ExpressionContext expCtx = agc.generalAssignExp().expression();
            Expression exp = this.parseExpress(expCtx);
            BeetlParser.VarRefContext varRefCtx = agc.generalAssignExp().varRef();
            if (varRefCtx.children.size() == 1) {
                Token token = varRefCtx.Identifier().getSymbol();
                vas = new VarAssignStatement(exp, this.getBTToken(token));
            } else {
                VarRef ref = this.parseVarRefInLeftExpression(varRefCtx);
                vas = new VarRefAssignStatement(exp, ref);
            }
            return vas;
        }
        if (amc instanceof BeetlParser.AssignIdContext) {
            BeetlParser.AssignIdContext idCtx = (BeetlParser.AssignIdContext)amc;
            vas = new VarAssignStatement(Literal.NULLLiteral, this.getBTToken(idCtx.Identifier().getSymbol()));
            return vas;
        }
        if (!(amc instanceof BeetlParser.AssignTemplateVarContext)) {
            throw new RuntimeException("\u4e0d\u652f\u6301");
        }
        BeetlParser.AssignTemplateVarContext templateVarCtx = (BeetlParser.AssignTemplateVarContext)amc;
        BeetlParser.BlockContext blockCtx = templateVarCtx.block();
        BlockStatement block = this.parseBlock(blockCtx.statement(), blockCtx);
        ContentBodyExpression bodyExp = new ContentBodyExpression(block, this.getBTToken(templateVarCtx.Identifier().getSymbol()));
        vas = new VarAssignStatement(bodyExp, this.getBTToken(templateVarCtx.Identifier().getSymbol()));
        return vas;
    }

    protected void checkGoto(IGoto gotoHandleStat) {
        switch (this.pbCtx.current.gotoValue) {
            case 0: {
                return;
            }
            case 1: 
            case 2: {
                if (!this.pbCtx.current.canStopContinueBreakFlag) {
                    this.pbCtx.current.parent.gotoValue = this.pbCtx.current.gotoValue;
                }
                gotoHandleStat.setGoto(true);
                return;
            }
            case 3: {
                if (this.pbCtx.current.parent != this.pbCtx.root) {
                    this.pbCtx.current.parent.gotoValue = 3;
                } else {
                    this.data.hasGoto = true;
                }
                gotoHandleStat.setGoto(true);
            }
        }
    }

    protected WhileStatement parseWhile(BeetlParser.WhileStContext wc) {
        this.pbCtx.enterBlock();
        this.pbCtx.current.canStopContinueBreakFlag = true;
        BeetlParser.ExpressionContext condtionCtx = wc.parExpression().expression();
        BeetlParser.StatementContext bodyCtx = wc.statement();
        Expression condtion = this.parseExpress(condtionCtx);
        Statement body = this.parseStatment(bodyCtx);
        WhileStatement whileStat = new WhileStatement(condtion, body, this.getBTToken(wc.getStart()));
        this.pbCtx.exitBlock();
        return whileStat;
    }

    protected TagStatement parseTag(BeetlParser.FunctionTagCallContext fc) {
        String id = this.getID(fc.functionNs().Identifier());
        BeetlParser.ExpressionListContext expListCtx = fc.expressionList();
        List<BeetlParser.ExpressionContext> list = null;
        list = expListCtx != null ? fc.expressionList().expression() : Collections.EMPTY_LIST;
        Expression[] expList = this.parseExpressionCtxList(list);
        if (id.equals("htmltagvar")) {
            int line = fc.functionNs().getStart().getLine();
            Literal l = (Literal)expList[2];
            String varList = (String)l.obj;
            String[] vars = varList.split(",");
            this.pbCtx.enterBlock();
            VarDefineNode[] varDefine = new VarDefineNode[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                VarDefineNode varNode = new VarDefineNode(this.getBTToken(vars[i].trim(), line));
                this.pbCtx.addVarAndPostion(varNode);
                varDefine[i] = varNode;
            }
            BeetlParser.BlockContext blockCtx = fc.block();
            BlockStatement block = this.parseBlock(blockCtx.statement(), blockCtx);
            this.pbCtx.exitBlock();
            TagFactory tf = this.gt.getTagFactory(id);
            if (tf == null) {
                BeetlException ex = new BeetlException("TAG_NOT_FOUND");
                ex.pushToken(this.getBTToken(id, fc.functionNs().getStart().getLine()));
                throw ex;
            }
            TagVarBindingStatement tag = new TagVarBindingStatement(id, expList, block, varDefine, this.getBTToken(id, line));
            return tag;
        }
        BeetlParser.BlockContext blockCtx = fc.block();
        BlockStatement block = this.parseBlock(blockCtx.statement(), blockCtx);
        TagFactory tf = this.gt.getTagFactory(id);
        if (tf == null) {
            BeetlException ex = new BeetlException("TAG_NOT_FOUND");
            ex.pushToken(this.getBTToken(id, fc.functionNs().getStart().getLine()));
            throw ex;
        }
        TagStatement tag = new TagStatement(id, expList, block, this.getBTToken(id, fc.functionNs().getStart().getLine()));
        return tag;
    }

    protected TryCatchStatement parseTryCatch(BeetlParser.TryStContext tryStCtx) {
        BeetlParser.BlockContext tryBlockCtx = tryStCtx.block(0);
        BlockStatement tryPart = this.parseBlock(tryBlockCtx.statement(), tryBlockCtx);
        BlockStatement catchPart = null;
        VarDefineNode errorNode = null;
        if (tryStCtx.Catch() != null) {
            this.pbCtx.enterBlock();
            if (tryStCtx.Identifier() != null) {
                Token errorToken = tryStCtx.Identifier().getSymbol();
                errorNode = new VarDefineNode(this.getBTToken(errorToken));
                this.pbCtx.addVarAndPostion(errorNode);
            }
            BeetlParser.BlockContext catchBlockCtx = tryStCtx.block(1);
            catchPart = this.parseBlock(catchBlockCtx.statement(), catchBlockCtx);
            this.pbCtx.exitBlock();
        }
        TryCatchStatement statement = new TryCatchStatement(tryPart, catchPart, errorNode, this.getBTToken(tryStCtx.Try().getSymbol()));
        return statement;
    }

    protected void parseCommentTag(BeetlParser.CommentTypeTagContext typeCtx) {
        List<BeetlParser.CommentTypeItemTagContext> list = typeCtx.commentTypeItemTag();
        for (BeetlParser.CommentTypeItemTagContext ctx : list) {
            BeetlParser.ClassOrInterfaceTypeContext classCtx = ctx.classOrInterfaceType();
            Type type = this.getClassType(classCtx);
            String globalVarName = ctx.Identifier1().getSymbol().getText();
            this.data.globalType.put(globalVarName, type);
        }
    }

    private Type getClassType(BeetlParser.ClassOrInterfaceTypeContext ctx) {
        List<BeetlParser.TypeArgumentContext> listType;
        List<TerminalNode> list = ctx.Identifier1();
        String className = this.getID(list);
        Class cls = this.gt.loadClassBySimpleName(className);
        if (cls == null) {
            BeetlException ex = new BeetlException("TYPE_SEARCH_ERROR", className);
            ex.pushToken(this.getBTToken(ctx.getStart()));
            throw ex;
        }
        Type classType = new Type(cls);
        BeetlParser.TypeArgumentsContext typeArgCtx = ctx.typeArguments();
        if (typeArgCtx != null && (listType = typeArgCtx.typeArgument()) != null) {
            Type[] subType = new Type[listType.size()];
            int i = 0;
            for (BeetlParser.TypeArgumentContext typeCtx : listType) {
                BeetlParser.ClassOrInterfaceTypeContext child = typeCtx.classOrInterfaceType();
                Type type = this.getClassType(child);
                subType[i++] = type;
            }
            classType.types = subType;
        }
        return classType;
    }

    protected DirectiveStatement parseDirectiveStatement(BeetlParser.DirectiveStContext node) {
        BeetlParser.DirectiveStContext stContext = node;
        BeetlParser.DirectiveExpContext direExp = stContext.directiveExp();
        Token token = direExp.Identifier().getSymbol();
        String directive = token.getText().toLowerCase().intern();
        TerminalNode value = direExp.StringLiteral();
        List<TerminalNode> idNodeList = null;
        BeetlParser.DirectiveExpIDListContext directExpidLisCtx = direExp.directiveExpIDList();
        if (directExpidLisCtx != null) {
            idNodeList = directExpidLisCtx.Identifier();
        }
        HashSet<Object> idList = null;
        DirectiveStatement ds = null;
        if (value != null) {
            String idListValue = this.getStringValue(value.getText());
            idList = new HashSet<String>(Arrays.asList(idListValue.split(",")));
            ds = new DirectiveStatement(directive, idList, this.getBTToken(token));
        } else if (idNodeList != null) {
            idList = new HashSet();
            for (TerminalNode t : idNodeList) {
                idList.add(t.getText());
            }
            ds = new DirectiveStatement(directive, idList, this.getBTToken(token));
        } else {
            ds = new DirectiveStatement(directive, Collections.EMPTY_SET, this.getBTToken(token));
        }
        if (directive.equals("dynamic")) {
            if (ds.getIdList().size() == 0) {
                this.data.allDynamic = true;
            } else {
                this.data.dynamicObjectSet = ds.getIdList();
            }
            ds = new DirectiveStatement(directive, Collections.EMPTY_SET, this.getBTToken(token));
            return ds;
        }
        if (directive.equalsIgnoreCase("safe_output_open".intern())) {
            this.pbCtx.isSafeOutput = true;
            return ds;
        }
        if (directive.equalsIgnoreCase("safe_output_close".intern())) {
            this.pbCtx.isSafeOutput = false;
            return ds;
        }
        return ds;
    }

    protected FunctionExpression parseFunExp(BeetlParser.FunctionCallContext ctx) {
        Expression[] newExps;
        Expression one;
        BeetlParser.ExpressionListContext expListCtx = ctx.expressionList();
        Expression[] exps = this.getExprssionList(expListCtx);
        List<BeetlParser.VarAttributeContext> vaListCtx = ctx.varAttribute();
        VarAttribute[] vs = this.parseVarAttribute(vaListCtx);
        List<TerminalNode> idList = ctx.functionNs().Identifier();
        String nsId = this.getID(idList);
        GrammarToken btToken = new GrammarToken(nsId, ctx.start.getLine(), 0);
        if (nsId.equals("isEmpty") || nsId.equals("isNotEmpty")) {
            if (exps.length != 0 && (one = exps[0]) instanceof VarRef) {
                VarRef ref = (VarRef)one;
                if (!ref.hasSafe) {
                    ref.hasSafe = true;
                    ref.safe = null;
                }
            }
        } else if (nsId.equals("has")) {
            if (exps.length != 0 && (one = exps[0]) instanceof VarRef) {
                VarRef ref = (VarRef)one;
                String name = ref.token.text;
                Literal newExp = new Literal(name, ref.token);
                exps[0] = newExp;
            }
        } else if (nsId.equals("debug")) {
            Literal l = new Literal(btToken.line, btToken);
            Expression[] newExps2 = new Expression[exps.length + 2];
            System.arraycopy(exps, 0, newExps2, 0, exps.length);
            String[] expStr = this.getExpressionString(expListCtx);
            newExps2[newExps2.length - 2] = new Literal(expStr, btToken);
            newExps2[newExps2.length - 1] = l;
            for (int i = 0; i < exps.length; ++i) {
                if (exps[i] instanceof VarRef) continue;
                expStr[i] = null;
            }
            exps = newExps2;
        } else if (nsId.equals("decode") && (newExps = new Expression[exps.length]).length >= 4) {
            newExps[0] = exps[0];
            newExps[1] = exps[1];
            for (int i = 2; i < exps.length; ++i) {
                newExps[i] = new ExpressionRuntime(exps[i]);
            }
            exps = newExps;
        }
        FunctionExpression fe = new FunctionExpression(nsId, exps, vs, btToken);
        return fe;
    }

    protected IfStatement parseIf(BeetlParser.IfStContext ctx) {
        BeetlParser.ParExpressionContext pe = ctx.parExpression();
        BeetlParser.ExpressionContext expCtx = pe.expression();
        Expression exp = this.parseExpress(expCtx);
        BeetlParser.StatementContext ifStatCtx = ctx.statement(0);
        Statement ifStat = this.parseStatment(ifStatCtx);
        BeetlParser.StatementContext elseStatCtx = ctx.statement(1);
        Statement elseStat = null;
        if (elseStatCtx != null) {
            elseStat = this.parseStatment(elseStatCtx);
        }
        return new IfStatement(exp, ifStat, elseStat, this.getBTToken(ctx.If().getSymbol()));
    }

    protected String getID(List<TerminalNode> ids) {
        StringBuilder sb = new StringBuilder();
        for (TerminalNode n : ids) {
            sb.append(n.getSymbol().getText()).append(".");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected Expression[] getExprssionList(BeetlParser.ExpressionListContext expListCtx) {
        if (expListCtx == null) {
            return this.EMPTY_EXPRESSION;
        }
        List<BeetlParser.ExpressionContext> ecList = expListCtx.expression();
        Expression[] exps = new Expression[ecList.size()];
        for (int i = 0; i < ecList.size(); ++i) {
            exps[i] = this.parseExpress(ecList.get(i));
        }
        return exps;
    }

    protected String[] getExpressionString(BeetlParser.ExpressionListContext expListCtx) {
        if (expListCtx == null) {
            return new String[0];
        }
        List<BeetlParser.ExpressionContext> ecList = expListCtx.expression();
        String[] exps = new String[ecList.size()];
        for (int i = 0; i < ecList.size(); ++i) {
            exps[i] = ecList.get(i).getText();
        }
        return exps;
    }

    protected Statement parseForSt(BeetlParser.ForStContext ctx) {
        List<BeetlParser.ExpressionContext> list;
        this.pbCtx.enterBlock();
        this.pbCtx.current.canStopContinueBreakFlag = true;
        BeetlParser.StatementContext forContext = ctx.statement(0);
        BeetlParser.StatementContext elseContext = null;
        BeetlParser.ForControlContext forTypeCtx = ctx.forControl();
        if (forTypeCtx.forInControl() != null) {
            BeetlParser.ForInControlContext forCtx = forTypeCtx.forInControl();
            VarDefineNode forVar = new VarDefineNode(this.getBTToken(forCtx.Identifier().getSymbol()));
            if (this.pbCtx.hasDefined(forVar.token.text) != null) {
                GrammarToken token = this.pbCtx.hasDefined(forVar.token.text);
                BeetlException ex = new BeetlException("VAR_ALREADY_DEFINED", "\u5df2\u7ecf\u5728\u7b2c" + token.line + "\u884c\u5b9a\u4e49");
                ex.pushToken(forVar.token);
                throw ex;
            }
            VarDefineNode loopStatusVar = new VarDefineNode(new GrammarToken(forCtx.Identifier().getSymbol().getText() + "LP", forCtx.Identifier().getSymbol().getLine(), 0));
            if (this.pbCtx.hasDefined(loopStatusVar.token.text) != null) {
                GrammarToken token = this.pbCtx.hasDefined(loopStatusVar.token.text);
                BeetlException ex = new BeetlException("VAR_ALREADY_DEFINED", "For\u5faa\u73af\u9690\u542b\u53d8\u91cf\uff0c\u5df2\u7ecf\u5728\u7b2c" + token.line + "\u884c\u5b9a\u4e49");
                ex.pushToken(loopStatusVar.token);
                throw ex;
            }
            this.pbCtx.addVarAndPostion(forVar);
            this.pbCtx.addVarAndPostion(loopStatusVar);
            Expression exp = this.parseExpress(forCtx.expression());
            Statement forPart = this.parseStatment(forContext);
            Statement elseForPart = null;
            if (ctx.Elsefor() != null) {
                elseContext = ctx.statement(1);
                elseForPart = this.parseStatment(elseContext);
            }
            boolean hasSafe = false;
            if (exp instanceof VarRef) {
                VarRef varRef = (VarRef)exp;
                hasSafe = varRef.hasSafe;
            }
            if (this.pbCtx.isSafeOutput) {
                hasSafe = true;
            }
            ForStatement forStatement = new ForStatement(forVar, exp, hasSafe, forPart, elseForPart, forVar.token);
            this.checkGoto(forStatement);
            this.pbCtx.exitBlock();
            return forStatement;
        }
        BeetlParser.GeneralForControlContext forCtx = forTypeCtx.generalForControl();
        Expression[] initExp = null;
        VarAssignStatementSeq varInitSeq = null;
        Expression condtion = null;
        Expression[] updateExp = null;
        if (forCtx.forInit() != null) {
            BeetlParser.ForInitContext forInitCtx = forCtx.forInit();
            if (forInitCtx.Var() == null) {
                list = forInitCtx.expressionList().expression();
                initExp = this.parseExpressionCtxList(list);
            } else {
                BeetlParser.VarDeclareListContext varDeclare = forInitCtx.varDeclareList();
                varInitSeq = this.parseVarDeclareList(varDeclare);
            }
        }
        if (forCtx.expression() != null) {
            condtion = this.parseExpress(forCtx.expression());
        }
        if (forCtx.forUpdate() != null) {
            BeetlParser.ForUpdateContext updateCtx = forCtx.forUpdate();
            list = updateCtx.expressionList().expression();
            updateExp = this.parseExpressionCtxList(list);
        }
        Statement forPart = this.parseStatment(forContext);
        Statement elseForPart = null;
        if (ctx.Elsefor() != null) {
            elseContext = ctx.statement(1);
            elseForPart = this.parseStatment(elseContext);
        }
        GeneralForStatement forStat = new GeneralForStatement(varInitSeq, initExp, condtion, updateExp, forPart, elseForPart, varInitSeq != null ? varInitSeq.token : initExp[0].token);
        this.pbCtx.exitBlock();
        return forStat;
    }

    protected Statement parseTextOutputSt(BeetlParser.TextOutputStContext ctx) {
        Statement placeholder;
        BeetlParser.TextVarContext tvc;
        BeetlParser.TextStatmentContext tsc = ctx.textStatment();
        FormatExpression format = null;
        boolean isSafe = false;
        if (tsc.NOT() != null) {
            isSafe = true;
        }
        if ((tvc = tsc.textVar()).COMMA() != null) {
            BeetlParser.FunctionNsContext fnsc;
            String formatName = null;
            String pattern = null;
            String tokenName = null;
            int line = 0;
            BeetlParser.TextformatContext tfc = tvc.textformat();
            TerminalNode node = tfc.StringLiteral();
            if (node != null) {
                tokenName = pattern = this.getStringValue(node.getText());
                line = node.getSymbol().getLine();
            }
            if ((fnsc = tfc.functionNs()) != null) {
                List<TerminalNode> listId = fnsc.Identifier();
                tokenName = formatName = this.getID(listId);
                line = listId.get(0).getSymbol().getLine();
            }
            format = new FormatExpression(formatName, pattern, GrammarToken.createToken(tokenName, line));
        }
        Expression exp = this.parseExpress(tvc.expression());
        if (isSafe) {
            placeholder = new SafePlaceholderST(exp, format, null);
            return placeholder;
        }
        placeholder = new PlaceholderST(exp, format, null);
        return placeholder;
    }

    private VarAssignStatementSeq parseVarSt(BeetlParser.VarStContext node) {
        BeetlParser.VarStContext varSt = node;
        BeetlParser.VarDeclareListContext ctx = varSt.varDeclareList();
        return this.parseVarDeclareList(ctx);
    }

    private VarAssignStatementSeq parseVarDeclareList(BeetlParser.VarDeclareListContext ctx) {
        List<BeetlParser.AssignMentContext> list = ctx.assignMent();
        ArrayList<VarAssignStatement> listNode = new ArrayList<VarAssignStatement>();
        for (BeetlParser.AssignMentContext amc : list) {
            VarAssignStatement vas = this.parseAssign(amc);
            listNode.add(vas);
            this.registerNewVar(vas);
        }
        VarAssignStatementSeq seq = new VarAssignStatementSeq(listNode.toArray(new Statement[0]), null);
        return seq;
    }

    protected Expression parseExpress(BeetlParser.ExpressionContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx instanceof BeetlParser.LiteralExpContext) {
            return this.parseLiteralExpress(((BeetlParser.LiteralExpContext)ctx).literal());
        }
        if (ctx instanceof BeetlParser.VarRefExpContext) {
            return this.parseVarRefExpression(((BeetlParser.VarRefExpContext)ctx).varRef());
        }
        if (ctx instanceof BeetlParser.CompareExpContext) {
            CompareExpression compare = this.parseCompareExpression((BeetlParser.CompareExpContext)ctx);
            if (this.gt.conf.isStrict) {
                throw new MVCStrictException(compare.token);
            }
            return compare;
        }
        if (ctx instanceof BeetlParser.TernaryExpContext) {
            return this.parseTernaryExpression((BeetlParser.TernaryExpContext)ctx);
        }
        if (ctx instanceof BeetlParser.MuldivmodExpContext) {
            ArthExpression arth = this.parseMuldivmodExpression((BeetlParser.MuldivmodExpContext)ctx);
            if (this.gt.conf.isStrict) {
                throw new MVCStrictException(arth.token);
            }
            return arth;
        }
        if (ctx instanceof BeetlParser.AddminExpContext) {
            return this.parsePlusMins((BeetlParser.AddminExpContext)ctx);
        }
        if (ctx instanceof BeetlParser.ParExpContext) {
            BeetlParser.ParExpContext par = (BeetlParser.ParExpContext)ctx;
            return this.parseExpress(par.expression());
        }
        if (ctx instanceof BeetlParser.FunctionCallExpContext) {
            BeetlParser.FunctionCallExpContext fceCtx = (BeetlParser.FunctionCallExpContext)ctx;
            FunctionExpression fun = this.parseFunExp(fceCtx.functionCall());
            if (this.gt.conf.isStrict) {
                throw new MVCStrictException(fun.token);
            }
            return fun;
        }
        if (ctx instanceof BeetlParser.JsonExpContext) {
            BeetlParser.JsonContext jc = ((BeetlParser.JsonExpContext)ctx).json();
            return this.parseJson(jc);
        }
        if (ctx instanceof BeetlParser.NativeCallExpContext) {
            BeetlParser.NativeCallContext ncc = ((BeetlParser.NativeCallExpContext)ctx).nativeCall();
            NativeCallExpression nativeCall = this.parseNativeCallExpression(ncc);
            if (!this.gt.conf.nativeCall || this.gt.conf.isStrict) {
                throw new NativeNotAllowedException(nativeCall.token);
            }
            return nativeCall;
        }
        if (ctx instanceof BeetlParser.AndExpContext) {
            BeetlParser.AndExpContext andCtx = (BeetlParser.AndExpContext)ctx;
            return this.parseAndExpression(andCtx);
        }
        if (ctx instanceof BeetlParser.OrExpContext) {
            BeetlParser.OrExpContext orExp = (BeetlParser.OrExpContext)ctx;
            return this.parseOrExpression(orExp);
        }
        if (ctx instanceof BeetlParser.NotExpContext) {
            BeetlParser.NotExpContext notCtx = (BeetlParser.NotExpContext)ctx;
            return this.parseNotExpression(notCtx);
        }
        if (ctx instanceof BeetlParser.NegExpContext) {
            BeetlParser.NegExpContext negCtx = (BeetlParser.NegExpContext)ctx;
            return this.parseNegExpression(negCtx);
        }
        if (ctx instanceof BeetlParser.IncDecOneContext) {
            BeetlParser.IncDecOneContext oneCtx = (BeetlParser.IncDecOneContext)ctx;
            IncDecExpression exp = this.parseIncDecOneContext(oneCtx);
            if (this.gt.conf.isStrict) {
                throw new NativeNotAllowedException(exp.token);
            }
            return exp;
        }
        if (ctx instanceof BeetlParser.OneIncDecContext) {
            BeetlParser.OneIncDecContext oneCtx = (BeetlParser.OneIncDecContext)ctx;
            IncDecExpression exp = this.parseOneIncDecContext(oneCtx);
            if (this.gt.conf.isStrict) {
                throw new NativeNotAllowedException(exp.token);
            }
            return exp;
        }
        if (ctx instanceof BeetlParser.AssignGeneralInExpContext) {
            BeetlParser.AssignGeneralInExpContext agc = (BeetlParser.AssignGeneralInExpContext)ctx;
            VarAssignExpression vas = this.parseAssingInExp(agc);
            return vas;
        }
        throw new UnsupportedOperationException();
    }

    protected IncDecExpression parseIncDecOneContext(BeetlParser.IncDecOneContext ctx) {
        IncDecExpression exp = null;
        boolean isInc = ctx.INCREASE() != null;
        GrammarToken t = this.getBTToken(ctx.Identifier().getSymbol());
        exp = new IncDecExpression(isInc, false, t);
        this.pbCtx.setVarPosition(t.text, exp);
        return exp;
    }

    protected IncDecExpression parseOneIncDecContext(BeetlParser.OneIncDecContext ctx) {
        IncDecExpression exp = null;
        boolean isInc = ctx.INCREASE() != null;
        GrammarToken t = this.getBTToken(ctx.Identifier().getSymbol());
        exp = new IncDecExpression(isInc, true, t);
        this.pbCtx.setVarPosition(t.text, exp);
        return exp;
    }

    protected Expression parseNegExpression(BeetlParser.NegExpContext ctx) {
        Expression exp = this.parseExpress(ctx.expression());
        if (ctx.MIN() != null) {
            NegExpression negExp = new NegExpression(exp, this.getBTToken(ctx.MIN().getSymbol()));
            return negExp;
        }
        return exp;
    }

    protected NotBooleanExpression parseNotExpression(BeetlParser.NotExpContext ctx) {
        Expression exp = this.parseExpress(ctx.expression());
        NotBooleanExpression notExp = new NotBooleanExpression(exp, this.getBTToken(ctx.NOT().getSymbol()));
        return notExp;
    }

    protected OrExpression parseOrExpression(BeetlParser.OrExpContext ctx) {
        Expression exp1 = this.parseExpress(ctx.expression(0));
        Expression exp2 = this.parseExpress(ctx.expression(1));
        OrExpression orExp = new OrExpression(exp1, exp2, this.getBTToken(ctx.OR().getSymbol()));
        return orExp;
    }

    protected AndExpression parseAndExpression(BeetlParser.AndExpContext ctx) {
        Expression exp1 = this.parseExpress(ctx.expression(0));
        Expression exp2 = this.parseExpress(ctx.expression(1));
        AndExpression andExp = new AndExpression(exp1, exp2, this.getBTToken(ctx.AND().getSymbol()));
        return andExp;
    }

    protected NativeCallExpression parseNativeCallExpression(BeetlParser.NativeCallContext ncc) {
        int i;
        NativeCallExpression nativeExp = null;
        List list = ncc.children;
        BeetlParser.NativeVarRefChainContext first = (BeetlParser.NativeVarRefChainContext)((Object)list.get(0));
        List<TerminalNode> ids = first.Identifier();
        StringBuilder clsSb = new StringBuilder();
        boolean isCls = false;
        for (i = 0; i < ids.size(); ++i) {
            String text = ids.get(i).getText();
            char c = text.charAt(0);
            if (c >= 'A' && c <= 'Z') {
                clsSb.append(text);
                isCls = true;
                break;
            }
            clsSb.append(text).append(".");
        }
        ClassNode clsNode = null;
        InstanceNode insNode = null;
        if (isCls) {
            clsNode = new ClassNode(clsSb.toString());
            ++i;
        } else {
            String varName = ids.get(0).getText();
            VarRef ref = new VarRef(new VarAttribute[0], false, null, this.getBTToken(varName, ncc.start.getLine()));
            this.pbCtx.setVarPosition(varName, ref);
            insNode = new InstanceNode(ref);
            i = 1;
        }
        ArrayList<NativeNode> nativeList = new ArrayList<NativeNode>();
        for (int j = i; j < ids.size(); ++j) {
            NativeAtrributeNode attribute = new NativeAtrributeNode(ids.get(j).getText());
            nativeList.add(attribute);
        }
        for (int z = 1; z < list.size(); ++z) {
            ParseTree tree = (ParseTree)list.get(z);
            if (tree instanceof BeetlParser.NativeMethodContext) {
                BeetlParser.NativeMethodContext methodCtx = (BeetlParser.NativeMethodContext)tree;
                NativeMethodNode methodNode = null;
                String method = null;
                NativeNode lastNode = (NativeNode)nativeList.get(nativeList.size() - 1);
                if (!(lastNode instanceof NativeAtrributeNode)) {
                    String msg = null;
                    msg = lastNode instanceof NativeArrayNode ? "[]()" : "()()";
                    BeetlException ex = new BeetlException("PARSER_NATIVE_ERROR", msg);
                    ex.pushToken(this.getBTToken(methodCtx.getStart()));
                    throw ex;
                }
                method = ((NativeAtrributeNode)lastNode).attribute;
                nativeList.remove(nativeList.size() - 1);
                List<BeetlParser.ExpressionContext> expCtxList = methodCtx.expression();
                Expression[] exp = this.parseExpressionCtxList(expCtxList);
                methodNode = new NativeMethodNode(method, exp);
                nativeList.add(methodNode);
                continue;
            }
            if (tree instanceof BeetlParser.NativeArrayContext) {
                BeetlParser.ExpressionContext expCtx = ((BeetlParser.NativeArrayContext)tree).expression();
                Expression exp = this.parseExpress(expCtx);
                NativeArrayNode arrayNode = new NativeArrayNode(exp);
                nativeList.add(arrayNode);
                continue;
            }
            if (!(tree instanceof BeetlParser.NativeVarRefChainContext)) continue;
            List<TerminalNode> nodes = ((BeetlParser.NativeVarRefChainContext)tree).Identifier();
            for (TerminalNode node : nodes) {
                NativeAtrributeNode attributeNode = new NativeAtrributeNode(node.getText());
                nativeList.add(attributeNode);
            }
        }
        NativeNode[] chain = nativeList.toArray(new NativeNode[0]);
        nativeExp = clsNode != null ? new NativeCallExpression(clsNode, chain, this.getBTToken(ncc.start)) : new NativeCallExpression(insNode, chain, this.getBTToken(ncc.start));
        return nativeExp;
    }

    protected Expression[] parseExpressionCtxList(List<BeetlParser.ExpressionContext> list) {
        if (list == null || list.size() == 0) {
            return new Expression[0];
        }
        ArrayList<Expression> expList = new ArrayList<Expression>(list.size());
        for (BeetlParser.ExpressionContext ec : list) {
            expList.add(this.parseExpress(ec));
        }
        return expList.toArray(new Expression[0]);
    }

    protected Expression parseJson(BeetlParser.JsonContext ctx) {
        if (ctx.LEFT_SQBR() != null) {
            JsonArrayExpression json = null;
            List<BeetlParser.ExpressionContext> listCtx = ctx.expression();
            if (listCtx.size() == 0) {
                json = new JsonArrayExpression(Collections.EMPTY_LIST, this.getBTToken(ctx.LEFT_SQBR().getSymbol()));
            } else {
                ArrayList<Expression> list = new ArrayList<Expression>(listCtx.size());
                for (BeetlParser.ExpressionContext expCtx : listCtx) {
                    list.add(this.parseExpress(expCtx));
                }
                json = new JsonArrayExpression(list, this.getBTToken(ctx.LEFT_SQBR().getSymbol()));
            }
            return json;
        }
        JsonMapExpression json = null;
        List<BeetlParser.JsonKeyValueContext> listCtx = ctx.jsonKeyValue();
        if (listCtx.size() == 0) {
            json = new JsonMapExpression(Collections.EMPTY_MAP, this.getBTToken(ctx.LEFT_BRACE().getSymbol()));
        } else {
            LinkedHashMap<String, Expression> map = new LinkedHashMap<String, Expression>(listCtx.size());
            for (BeetlParser.JsonKeyValueContext kvCtx : listCtx) {
                String key = null;
                key = kvCtx.StringLiteral() != null ? this.getStringValue(kvCtx.StringLiteral().getText()) : kvCtx.Identifier().getSymbol().getText();
                Expression exp = this.parseExpress(kvCtx.expression());
                map.put(key, exp);
            }
            json = new JsonMapExpression(map, this.getBTToken(ctx.LEFT_BRACE().getSymbol()));
        }
        return json;
    }

    protected ArthExpression parseMuldivmodExpression(BeetlParser.MuldivmodExpContext ctx) {
        Expression a = this.parseExpress(ctx.expression(0));
        Expression b = this.parseExpress(ctx.expression(1));
        TerminalNode tn = (TerminalNode)ctx.children.get(1);
        short mode = 0;
        if (ctx.MUlTIP() != null) {
            mode = 2;
        } else if (ctx.DIV() != null) {
            mode = 3;
        } else if (ctx.MOD() != null) {
            mode = 4;
        }
        return new ArthExpression(a, b, mode, this.getBTToken(tn.getSymbol()));
    }

    protected Expression parsePlusMins(BeetlParser.AddminExpContext ctx) {
        Expression a = this.parseExpress(ctx.expression(0));
        Expression b = this.parseExpress(ctx.expression(1));
        TerminalNode tn = (TerminalNode)ctx.children.get(1);
        short mode = 0;
        if (ctx.ADD() != null) {
            mode = 0;
        } else if (ctx.MIN() != null) {
            mode = 1;
        }
        return new ArthExpression(a, b, mode, this.getBTToken(tn.getSymbol()));
    }

    protected Expression parseTernaryExpression(BeetlParser.TernaryExpContext ctx) {
        Expression cond = this.parseExpress(ctx.expression(0));
        Expression a = this.parseExpress(ctx.expression(1));
        Expression b = null;
        b = ctx.COLON() == null ? null : this.parseExpress(ctx.expression(2));
        TerminalNode tn = (TerminalNode)ctx.getChild(1);
        return new TernaryExpression(cond, a, b, this.getBTToken(tn.getSymbol()));
    }

    protected CompareExpression parseCompareExpression(BeetlParser.CompareExpContext ctx) {
        Expression a = this.parseExpress(ctx.expression(0));
        Expression b = this.parseExpress(ctx.expression(1));
        TerminalNode tn = (TerminalNode)ctx.children.get(1);
        int mode = 0;
        if (ctx.EQUAL() != null) {
            mode = 0;
        } else if (ctx.NOT_EQUAL() != null) {
            mode = 1;
        } else if (ctx.LARGE() != null) {
            mode = 2;
        } else if (ctx.LARGE_EQUAL() != null) {
            mode = 3;
        } else if (ctx.LESS() != null) {
            mode = 4;
        } else if (ctx.LESS_EQUAL() != null) {
            mode = 5;
        }
        return new CompareExpression(a, b, (short)mode, this.getBTToken(tn.getSymbol()));
    }

    protected Expression parseVarRefExpression(BeetlParser.VarRefContext varRef) {
        VarAttribute first;
        VarAttribute[] vas;
        List<BeetlParser.VarAttributeContext> list;
        Expression safeExp = null;
        BeetlParser.Safe_outputContext soctx = varRef.safe_output();
        boolean hasSafe = false;
        if (soctx != null) {
            list = soctx.children;
            if (list.size() == 1) {
                safeExp = null;
            } else {
                BeetlParser.Safe_allow_expContext allowExp = (BeetlParser.Safe_allow_expContext)((Object)list.get(1));
                if (allowExp.literal() != null) {
                    safeExp = this.parseLiteralExpress(allowExp.literal());
                } else if (allowExp.nativeCall() != null) {
                    safeExp = this.parseNativeCallExpression(allowExp.nativeCall());
                } else if (allowExp.functionCall() != null) {
                    safeExp = this.parseFunExp(allowExp.functionCall());
                } else if (allowExp.expression() != null) {
                    safeExp = this.parseExpress(allowExp.expression());
                } else if (allowExp.varRef() != null) {
                    safeExp = this.parseVarRefExpression(allowExp.varRef());
                }
            }
            hasSafe = true;
        }
        if (this.pbCtx.isSafeOutput) {
            hasSafe = true;
        }
        if ((vas = this.parseVarAttribute(list = varRef.varAttribute())).length > 0 && !((first = vas[0]) instanceof VarSquareAttribute) && !(first instanceof VarVirtualAttribute)) {
            this.pbCtx.setVarAttr(varRef.Identifier().getText(), first.token.text);
        }
        VarRef var = new VarRef(vas, hasSafe, safeExp, this.getBTToken(varRef.getText(), varRef.Identifier().getSymbol().getLine()), this.getBTToken(varRef.Identifier().getSymbol()));
        this.pbCtx.setVarPosition(varRef.Identifier().getText(), var);
        return var;
    }

    protected VarRef parseVarRefInLeftExpression(BeetlParser.VarRefContext varRef) {
        VarAttribute first;
        Object safeExp = null;
        BeetlParser.Safe_outputContext soctx = varRef.safe_output();
        if (soctx != null) {
            throw new BeetlException("ERROR", "\u8bed\u6cd5\u9519,\u8d4b\u503c\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4f7f\u7528\u5b89\u5168\u8f93\u51fa");
        }
        List<BeetlParser.VarAttributeContext> list = varRef.varAttribute();
        VarAttribute[] vas = this.parseVarAttribute(list);
        if (vas.length > 0 && !((first = vas[0]) instanceof VarSquareAttribute) && !(first instanceof VarVirtualAttribute)) {
            this.pbCtx.setVarAttr(varRef.Identifier().getText(), first.token.text);
        }
        VarRef var = new VarRef(vas, false, null, this.getBTToken(varRef.getText(), varRef.Identifier().getSymbol().getLine()), this.getBTToken(varRef.Identifier().getSymbol()));
        this.pbCtx.setVarPosition(varRef.Identifier().getText(), var);
        return var;
    }

    protected VarAttribute[] parseVarAttribute(List<BeetlParser.VarAttributeContext> list) {
        ArrayList<VarAttribute> listVarAttr = new ArrayList<VarAttribute>();
        for (BeetlParser.VarAttributeContext vac : list) {
            VarAttribute attr;
            BeetlParser.VarAttributeContext zf;
            if (vac instanceof BeetlParser.VarAttributeGeneralContext) {
                zf = (BeetlParser.VarAttributeGeneralContext)vac;
                attr = new VarAttribute(this.getBTToken(((BeetlParser.VarAttributeGeneralContext)zf).Identifier().getSymbol()));
                listVarAttr.add(attr);
                attr.setAA(ObjectAA.defaultObjectAA());
                continue;
            }
            if (vac instanceof BeetlParser.VarAttributeArrayOrMapContext) {
                zf = (BeetlParser.VarAttributeArrayOrMapContext)vac;
                Expression exp = this.parseExpress(((BeetlParser.VarAttributeArrayOrMapContext)zf).expression());
                VarSquareAttribute attr2 = new VarSquareAttribute(exp, this.getBTToken("[]", exp.token.line));
                attr2.setAA(ObjectAA.defaultObjectAA());
                listVarAttr.add(attr2);
                continue;
            }
            if (!(vac instanceof BeetlParser.VarAttributeVirtualContext)) continue;
            zf = (BeetlParser.VarAttributeVirtualContext)vac;
            attr = new VarVirtualAttribute(this.getBTToken(((BeetlParser.VarAttributeVirtualContext)zf).Identifier().getSymbol()));
            listVarAttr.add(attr);
        }
        return listVarAttr.toArray(new VarAttribute[0]);
    }

    protected Expression parseLiteralExpress(BeetlParser.LiteralContext ctx) {
        ParseTree tree = ctx.getChild(0);
        Object value = null;
        if (tree instanceof TerminalNode) {
            Token node = ((TerminalNode)tree).getSymbol();
            String strValue = node.getText();
            int type = node.getType();
            switch (type) {
                case 59: {
                    value = this.getStringValue(strValue);
                    break;
                }
                case 58: {
                    char c = strValue.charAt(strValue.length() - 1);
                    if (this.isHighScaleNumber(strValue)) {
                        String newValue = strValue.substring(0, strValue.length() - 1);
                        value = new BigDecimal(newValue);
                        break;
                    }
                    value = Double.parseDouble(strValue);
                    break;
                }
                case 56: {
                    if (this.isHighScaleNumber(strValue)) {
                        String newValue = strValue.substring(0, strValue.length() - 1);
                        value = new BigDecimal(newValue);
                        break;
                    }
                    if (strValue.length() < 10) {
                        value = Integer.parseInt(strValue);
                        break;
                    }
                    if (strValue.length() > 10) {
                        value = Long.parseLong(strValue);
                        break;
                    }
                    if (strValue.compareTo("2147483647") > 0) {
                        value = Long.parseLong(strValue);
                        break;
                    }
                    value = Integer.parseInt(strValue);
                    break;
                }
                case 44: {
                    value = null;
                }
            }
        } else {
            BeetlParser.BooleanLiteralContext blc = (BeetlParser.BooleanLiteralContext)tree;
            String strValue = blc.getChild(0).getText();
            value = Boolean.parseBoolean(strValue);
        }
        if (value == null) {
            return Literal.NULLLiteral;
        }
        Literal literal = new Literal(value, this.getBTToken(ctx.getStart()));
        return literal;
    }

    private String getStringValue(String strValue) {
        char[] ch = strValue.toCharArray();
        StringBuilder sb = new StringBuilder(strValue.length());
        for (int i = 1; i < ch.length - 1; ++i) {
            char c = ch[i];
            if (c == '\\') {
                char spec = ch[++i];
                char real = '\u0000';
                switch (spec) {
                    case '\"': {
                        real = '\"';
                        break;
                    }
                    case '\'': {
                        real = '\'';
                        break;
                    }
                    case 't': {
                        real = '\t';
                        break;
                    }
                    case 'r': {
                        real = '\r';
                        break;
                    }
                    case 'n': {
                        real = '\n';
                        break;
                    }
                    case 'b': {
                        real = '\b';
                        break;
                    }
                    case 'f': {
                        real = '\f';
                        break;
                    }
                    case '\\': {
                        real = '\\';
                        break;
                    }
                    default: {
                        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8f6c\u4e49\u7b26\u53f7" + strValue);
                    }
                }
                sb.append(real);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean isHighScaleNumber(String strValue) {
        char c = strValue.charAt(strValue.length() - 1);
        return c == 'h' || c == 'H';
    }

    protected BlockStatement parseBlock(List list, ParserRuleContext ctx) {
        this.pbCtx.enterBlock();
        ASTNode[] statements = new ASTNode[list.size()];
        ArrayList<Statement> nodes = new ArrayList<Statement>();
        boolean hasGoto = false;
        for (int i = 0; i < statements.length; ++i) {
            nodes.add(this.parseStatment((ParserRuleContext)list.get(i)));
        }
        BlockStatement block = new BlockStatement(nodes.toArray(new Statement[0]), this.getBTToken(ctx.getStart()));
        this.checkGoto(block);
        this.pbCtx.exitBlock();
        return block;
    }

    public GrammarToken getBTToken(Token t) {
        GrammarToken token = new GrammarToken(t.getText(), t.getLine(), t.getCharPositionInLine());
        return token;
    }

    public GrammarToken getBTToken(String text, int line) {
        GrammarToken token = GrammarToken.createToken(text, line);
        return token;
    }
}

