/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.resource.Matcher;

public class CompositeResourceLoader
implements ResourceLoader {
    private List<Matcher> matchers = new ArrayList<Matcher>();
    private Map<Matcher, ResourceLoader> matcherResourceLoaderMap = new HashMap<Matcher, ResourceLoader>();
    private boolean autoCheck = false;

    public void addResourceLoader(Matcher matcher, ResourceLoader resourceLoader) {
        if (this.matcherResourceLoaderMap.containsKey(matcher)) {
            return;
        }
        this.matcherResourceLoaderMap.put(matcher, resourceLoader);
        this.matchers.add(matcher);
    }

    public void setResourceLoaderMap(Map<Matcher, ResourceLoader> map) {
        this.matcherResourceLoaderMap = map;
    }

    @Override
    public void close() {
        Iterator<ResourceLoader> it = this.matcherResourceLoaderMap.values().iterator();
        ResourceLoader rl = null;
        while (it.hasNext()) {
            rl = it.next();
            rl.close();
        }
    }

    @Override
    public boolean exist(String key) {
        ResourceLoaderKeyEntry rlke = this.match(key);
        if (rlke == null) {
            return false;
        }
        return rlke.getResourceLoader().exist(rlke.getNewKey());
    }

    @Override
    public Resource getResource(String key) {
        ResourceLoaderKeyEntry rlke = this.match(key);
        if (rlke == null) {
            return new UnReachableResource(key, this);
        }
        return rlke.getResourceLoader().getResource(rlke.getNewKey());
    }

    @Override
    public void init(GroupTemplate gt) {
        for (ResourceLoader rl : this.matcherResourceLoaderMap.values()) {
            rl.init(gt);
        }
        Map<String, String> resourceMap = gt.getConf().getResourceMap();
        this.autoCheck = Boolean.parseBoolean(resourceMap.get("autoCheck"));
    }

    @Override
    public boolean isModified(Resource key) {
        if (this.autoCheck) {
            return key.isModified();
        }
        return false;
    }

    private ResourceLoaderKeyEntry match(String key) {
        for (Matcher matcher : this.matchers) {
            String newKey = matcher.match(key);
            if (newKey == null) continue;
            return new ResourceLoaderKeyEntry(newKey, this.matcherResourceLoaderMap.get(matcher));
        }
        return null;
    }

    @Override
    public String getResourceId(Resource resource, String id) {
        if (resource == null) {
            return id;
        }
        ResourceLoaderKeyEntry rlke = this.match(id);
        if (resource.getResourceLoader() == rlke.getResourceLoader()) {
            return resource.getResourceLoader().getResourceId(resource, id);
        }
        return id;
    }

    @Override
    public String getInfo() {
        return "CompositeResourceLoader " + this.matcherResourceLoaderMap;
    }

    private static final class UnReachableResource
    extends Resource {
        UnReachableResource(String key, ResourceLoader loader) {
            super(key, loader);
        }

        @Override
        public Reader openReader() {
            BeetlException be = new BeetlException("TEMPLATE_LOAD_ERROR", "\u590d\u5408\u8d44\u6e90\u52a0\u8f7d\u5668\u672a\u5339\u914d\u8def\u5f84:" + this.id);
            be.resourceId = this.id;
            throw be;
        }

        @Override
        public boolean isModified() {
            return true;
        }
    }

    private static final class ResourceLoaderKeyEntry {
        private final String newKey;
        private final ResourceLoader resourceLoader;

        public ResourceLoaderKeyEntry(String newKey, ResourceLoader resourceLoader) {
            this.newKey = newKey;
            this.resourceLoader = resourceLoader;
        }

        public final String getNewKey() {
            return this.newKey;
        }

        public final ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }
    }
}

