/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.IOException;
import java.io.Writer;

public class NoLockStringWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public NoLockStringWriter() {
        this.buf = new char[64];
    }

    public NoLockStringWriter(char[] buf) {
        this.buf = buf;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = NoLockStringWriter.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(cbuf, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    @Override
    public void write(String str) throws IOException {
        if (str != null) {
            int len = str.length();
            if (len < this.buf.length) {
                str.getChars(0, len, this.buf, 0);
                this.write(this.buf, 0, len);
            } else {
                this.write(str.toCharArray());
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }
}

