/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxConnectionPoolManager;
import com.informix.jdbcx.IfxCoreDataSource;
import com.informix.jdbcx.IfxDataSourceFactory;
import com.informix.util.IfxErrMsg;
import com.informix.util.InformixUrl;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class IfxDataSource
extends IfxCoreDataSource
implements DataSource,
Referenceable {
    private static final long serialVersionUID = 1L;
    private static final Object logger = Trace.getLoggerForClass(IfxDataSource.class);
    private IfxConnectionPoolManager cpm = null;
    String cpdsName = null;
    private Constructor<?> cons = null;
    private Trace trace = null;
    private final InformixUrl url;

    public IfxDataSource() {
        this.url = null;
    }

    public IfxDataSource(IfxConnectionPoolDataSource lcpds) throws SQLException {
        this.cpdsName = null;
        this.cpm = null;
        this.url = null;
    }

    public IfxDataSource(String url) throws SQLException {
        this.url = new InformixUrl(url, null);
        this.DSProperties.putAll((Map<?, ?>)this.url.getProperties());
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.cpm == null) {
            String DSUser = this.getUser();
            String DSPasswd = this.getPassword();
            if (DSUser == null && DSPasswd == null || DSUser != null && DSPasswd != null) {
                return this.getSqliConnection(DSUser, DSPasswd);
            }
            throw IfxErrMsg.getLocSQLException(-79811, this.getIfxCLIENT_LOCALE());
        }
        return this.cpm.getConnection();
    }

    @Override
    public Connection getConnection(String luser, String lpassword) throws SQLException {
        if (this.cpm == null) {
            return this.getSqliConnection(luser, lpassword);
        }
        return this.cpm.getConnection(luser, lpassword);
    }

    private Connection getSqliConnection(String luser, String lpasswd) throws SQLException {
        IfxConnection conn;
        String urlString = "";
        String host = null;
        String port = null;
        String connType = null;
        Properties prop = this.getDsProperties();
        host = prop.getProperty("IFXHOST");
        port = prop.getProperty("PORTNO");
        connType = prop.getProperty("CONNECTIONCLASS");
        if (connType.equals("com.informix.jdbc.IfxSqliConnect") && host != null && port != null) {
            urlString = host + ":" + port;
        }
        try {
            Class[] classArgs = null;
            Object[] objs = null;
            if (this.cons == null) {
                if (connType.equals("com.informix.jdbc.IfxSqliConnect")) {
                    classArgs = new Class[]{luser == null ? String.valueOf("").getClass() : luser.getClass(), lpasswd == null ? String.valueOf("").getClass() : lpasswd.getClass(), urlString.getClass(), prop.getClass()};
                    Class<?> clsRef = Class.forName(connType);
                    this.cons = clsRef.getConstructor(classArgs);
                } else {
                    classArgs = new Class[]{urlString.getClass(), prop.getClass()};
                    Class<?> clsRef = Class.forName(connType);
                    this.cons = clsRef.getConstructor(classArgs);
                }
            }
            if (urlString.equals("")) {
                urlString = null;
            }
            objs = connType.equals("com.informix.jdbc.IfxSqliConnect") ? new Object[]{luser, lpasswd, urlString, prop} : new Object[]{urlString, prop};
            conn = (IfxConnection)this.cons.newInstance(objs);
        }
        catch (InvocationTargetException te) {
            if (te.getTargetException() instanceof SQLException) {
                throw (SQLException)te.getTargetException();
            }
            throw new SQLException("Encountered non-SQLException", te.getTargetException());
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocSQLException(-79704, e.toString(), this.getIfxCLIENT_LOCALE());
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace = conn.getTrace();
            this.trace.writeTrace(logger, 1, "IfxDataSource: This has NO Connection Pool");
            this.trace.writeTrace(logger, 1, "IfxDataSource: getSqliConnection() exited");
        }
        return conn;
    }

    void getCPM() throws SQLException {
        try {
            this.cpdsName = this.getDataSourceName();
            if (this.cpdsName != null) {
                this.cpm = new IfxConnectionPoolManager(this.cpdsName);
                this.cpm.startPoolService();
            } else {
                this.cpm = null;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw IfxErrMsg.getLocSQLException(-79716, e.toString(), this.getIfxCLIENT_LOCALE());
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeProperties(out);
            return new Reference(IfxDataSource.class.getName(), new StringRefAddr("DSProperties", new String(out.toByteArray(), "ISO8859_1")), IfxDataSourceFactory.class.getName(), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getCPMFreeCount() {
        if (this.cpm != null) {
            return this.cpm.getFreeCount();
        }
        return 0;
    }

    public IfxConnectionPoolDataSource getCPDS() {
        if (this.cpm != null) {
            return this.cpm.getCPDS();
        }
        return null;
    }

    public void activateHDRPool_Primary() throws SQLException {
        if (this.cpm != null) {
            this.cpm.switchActivePool("PRIMARY");
        }
    }

    public void activateHDRPool_Secondary() throws SQLException {
        if (this.cpm != null) {
            this.cpm.switchActivePool("SECONDARY");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw IfxErrMsg.getSQLException(-79004, ": IfxDataSource.unwrap(class<T> iface)", (IfxConnection)null);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("com.informix.jdbc");
    }
}

