/*
 * Decompiled with CFR 0.152.
 */
package com.informix.json;

import com.informix.bson.DBRefBase;
import com.informix.json.ClassMapBasedObjectSerializer;
import com.informix.json.JSONSerializer;
import com.informix.json.ObjectSerializer;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class JSONSerializers {
    private JSONSerializers() {
    }

    public static ObjectSerializer getLegacy() {
        return JSONSerializers.getLegacy(false);
    }

    public static ObjectSerializer getLegacy(boolean minify) {
        JSONSerializer.Configuration configuration = new JSONSerializer.Configuration(true, minify, true, true);
        ClassMapBasedObjectSerializer serializer = JSONSerializers.addCommonSerializers(configuration);
        serializer.addObjectSerializer(Date.class, new JSONSerializer.LegacyDateSerializer(serializer, configuration));
        serializer.addObjectSerializer(BSONTimestamp.class, new JSONSerializer.LegacyBSONTimestampSerializer(serializer, configuration));
        serializer.addObjectSerializer(Binary.class, new JSONSerializer.LegacyBinarySerializer());
        serializer.addObjectSerializer(byte[].class, new JSONSerializer.LegacyBinarySerializer());
        return serializer;
    }

    public static ObjectSerializer getStrict() {
        return JSONSerializers.getStrict(false);
    }

    public static ObjectSerializer getStrict(boolean minify) {
        JSONSerializer.Configuration configuration = new JSONSerializer.Configuration(true, minify, true, true);
        ClassMapBasedObjectSerializer serializer = JSONSerializers.addCommonSerializers(configuration);
        serializer.addObjectSerializer(Date.class, new JSONSerializer.DateSerializer(serializer, configuration));
        serializer.addObjectSerializer(BSONTimestamp.class, new JSONSerializer.BSONTimestampSerializer(serializer, configuration));
        serializer.addObjectSerializer(Binary.class, new JSONSerializer.BinarySerializer(serializer, configuration));
        serializer.addObjectSerializer(byte[].class, new JSONSerializer.ByteArraySerializer(serializer, configuration));
        return serializer;
    }

    public static ObjectSerializer getInformix() {
        return JSONSerializers.getInformix(false);
    }

    public static ObjectSerializer getInformix(boolean minify) {
        JSONSerializer.Configuration configuration = new JSONSerializer.Configuration(true, minify, true, true);
        ClassMapBasedObjectSerializer serializer = JSONSerializers.addCommonSerializers(configuration);
        serializer.addObjectSerializer(ObjectId.class, new JSONSerializer.InformixObjectIdSerializer(serializer, configuration));
        serializer.addObjectSerializer(Date.class, new JSONSerializer.InformixDateSerializer(serializer, configuration));
        serializer.addObjectSerializer(BSONTimestamp.class, new JSONSerializer.LegacyBSONTimestampSerializer(serializer, configuration));
        serializer.addObjectSerializer(Binary.class, new JSONSerializer.LegacyBinarySerializer());
        serializer.addObjectSerializer(byte[].class, new JSONSerializer.LegacyBinarySerializer());
        return serializer;
    }

    static ClassMapBasedObjectSerializer addCommonSerializers(JSONSerializer.Configuration configuration) {
        ClassMapBasedObjectSerializer serializer = new ClassMapBasedObjectSerializer();
        serializer.addObjectSerializer(Object[].class, new JSONSerializer.ObjectArraySerializer(serializer, configuration));
        serializer.addObjectSerializer(Boolean.class, new JSONSerializer.ToStringSerializer());
        serializer.addObjectSerializer(Code.class, new JSONSerializer.CodeSerializer(serializer, configuration));
        serializer.addObjectSerializer(CodeWScope.class, new JSONSerializer.CodeWScopeSerializer(serializer, configuration));
        serializer.addObjectSerializer(BSONObject.class, new JSONSerializer.BSONObjectSerializer(serializer, configuration));
        serializer.addObjectSerializer(DBRefBase.class, new JSONSerializer.DBRefBaseSerializer(serializer, configuration));
        serializer.addObjectSerializer(Iterable.class, new JSONSerializer.IterableSerializer(serializer, configuration));
        serializer.addObjectSerializer(Map.class, new JSONSerializer.MapSerializer(serializer, configuration));
        serializer.addObjectSerializer(MaxKey.class, new JSONSerializer.MaxKeySerializer(serializer, configuration));
        serializer.addObjectSerializer(MinKey.class, new JSONSerializer.MinKeySerializer(serializer, configuration));
        serializer.addObjectSerializer(Number.class, new JSONSerializer.ToStringSerializer());
        serializer.addObjectSerializer(ObjectId.class, new JSONSerializer.ObjectIdSerializer(serializer, configuration));
        serializer.addObjectSerializer(Pattern.class, new JSONSerializer.PatternSerializer(serializer, configuration));
        serializer.addObjectSerializer(String.class, new JSONSerializer.StringSerializer());
        serializer.addObjectSerializer(UUID.class, new JSONSerializer.UUIDSerializer(serializer, configuration));
        return serializer;
    }
}

