/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import com.informix.util.JdbcLegacyLogFormatter;
import com.informix.util.TraceFlag;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Trace {
    private static final int ROW_SIZE = 32;
    private FileHandler fileHandler = null;
    private final String name;

    public static final Object getLoggerForClass(Class<?> clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public Trace() {
        this.fileHandler = null;
        this.name = "";
    }

    public Trace(String name) {
        this.name = "{" + name + "} ";
    }

    public Trace(int level, String fileName) {
        this(level, fileName, "");
    }

    public Trace(int level, String fileName, String name) {
        this.name = !name.isEmpty() ? "{" + name + "} " : name;
        if (fileName == null) {
            this.fileHandler = null;
        } else {
            try {
                this.fileHandler = new FileHandler(fileName);
                this.fileHandler.setLevel(TraceFlag.mapLevel(level));
                this.fileHandler.setFormatter(new JdbcLegacyLogFormatter());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void setNewTraceFile(int level, String fileName) {
        if (level == 0 || fileName == null) {
            this.fileHandler = null;
        } else {
            try {
                this.fileHandler = new FileHandler(fileName);
                this.fileHandler.setLevel(TraceFlag.mapLevel(level));
                this.fileHandler.setFormatter(new JdbcLegacyLogFormatter());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void writeTrace(int levelNum, String stringInfo) {
        if (this.fileHandler == null) {
            return;
        }
        this.fileHandler.publish(new LogRecord(TraceFlag.mapLevel(levelNum), this.name + stringInfo));
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo) {
        this.printLog(logger, stringInfo, levelNum);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, String data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, int data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, short data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, long data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, String stringInfo, boolean data) {
        this.writeTrace(logger, levelNum, stringInfo + data);
    }

    public void writeTrace(Object logger, int levelNum, byte[] byteData, char format) {
        this.writeTrace(logger, levelNum, byteData, format, byteData.length);
    }

    public void writeTrace(Object logger, int levelNum, byte[] byteData, char format, int size) {
        this.writeTrace(logger, levelNum, byteData, 0, format, size);
    }

    public void writeTrace(Object logger, int levelNum, byte[] byteData, int offset, char format, int size) {
        int i;
        if (this.fileHandler == null || !TraceFlag.loggerTrace) {
            return;
        }
        StringBuilder finalBuilder = new StringBuilder();
        StringBuilder asciiBuilder = new StringBuilder();
        boolean showAscii = format == 'b' || format == 'B';
        finalBuilder.append("Index :  Hex:");
        int finalPadding = size / 32;
        if ((finalPadding *= 32) < size) {
            finalPadding = finalPadding + 32 - size;
        }
        for (i = 0; i < size; ++i) {
            if (i % 32 == 0) {
                if (!asciiBuilder.toString().isEmpty()) {
                    finalBuilder.append('\t');
                    finalBuilder.append((CharSequence)asciiBuilder);
                    asciiBuilder = new StringBuilder();
                }
                finalBuilder.append("\n0x" + String.format("%04X", i) + ":  ");
            }
            finalBuilder.append(String.format("%02X ", byteData[i]).toLowerCase());
            if (!showAscii) continue;
            int value = new Byte(byteData[i]).intValue();
            if (value >= 32 && value <= 126) {
                asciiBuilder.append((char)value);
                continue;
            }
            asciiBuilder.append(".");
        }
        for (i = 0; i < finalPadding; ++i) {
            finalBuilder.append("   ");
        }
        if (!asciiBuilder.toString().isEmpty()) {
            finalBuilder.append('\t');
            finalBuilder.append((CharSequence)asciiBuilder);
            for (i = 0; i < finalPadding; ++i) {
                finalBuilder.append(".");
            }
        }
        finalBuilder.append('\n');
        this.printLog(logger, finalBuilder.toString(), 1);
    }

    private void printLog(Object loggerFromClass, String msg, int levelNum) {
        if (TraceFlag.loggerTrace && this.fileHandler != null) {
            this.fileHandler.publish(new LogRecord(TraceFlag.mapLevel(levelNum), this.name + msg));
        } else if (loggerFromClass instanceof Logger) {
            ((Logger)loggerFromClass).log(TraceFlag.mapLevel(levelNum), this.name + msg);
        } else {
            Logger.getLogger("com.informix.jdbc").log(TraceFlag.mapLevel(levelNum), this.name + msg);
        }
    }
}

