/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.executor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.util.Cache;
import winter.com.ideaaedi.classwinter.util.EncryptUtil;
import winter.com.ideaaedi.classwinter.util.IOUtil;
import winter.com.ideaaedi.classwinter.util.JarUtil;
import winter.com.ideaaedi.classwinter.util.Logger;
import winter.com.ideaaedi.classwinter.util.Pair;
import winter.com.ideaaedi.classwinter.util.StrUtil;

public class DecryptExecutor {
    private static final Map<String, Set<String>> checklist = new ConcurrentHashMap<String, Set<String>>(8);
    private static Map<String, String> checklistOfAllLibsMap;

    public static byte[] process(String projectPath, String classWinterInfoDir, String filename, char[] password) {
        String baseWinterInfoDir = StrUtil.isBlank(classWinterInfoDir) ? "META-INF/winter/" : classWinterInfoDir;
        classWinterInfoDir = StrUtil.isBlank(classWinterInfoDir) ? "META-INF/winter/classes/" : classWinterInfoDir;
        byte[] bytes = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), classWinterInfoDir + filename);
        return DecryptExecutor.decrypt(projectPath, baseWinterInfoDir, bytes, password);
    }

    public static byte[] decrypt(String projectPath, String classWinterInfoDir, byte[] bytes, char[] password) {
        String baseWinterInfoDir = StrUtil.isBlank(classWinterInfoDir) ? "META-INF/winter/" : classWinterInfoDir;
        boolean userIfInputPwdWhileDecrypt = DecryptExecutor.checkPwdConsistency(projectPath, baseWinterInfoDir, password);
        return EncryptUtil.decrypt(bytes, userIfInputPwdWhileDecrypt ? password : DecryptExecutor.obtainAutoGeneratedPwdWhileEncrypt(projectPath, baseWinterInfoDir));
    }

    public static boolean checklistContain(String projectPath, String classLongName) {
        byte[] checklistByte;
        if (!checklist.containsKey(projectPath) && (checklistByte = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), "META-INF/winter/checklist.classes.winter")) != null) {
            String checklistContent = new String(checklistByte, StandardCharsets.UTF_8);
            Logger.debug(DecryptExecutor.class, "checklistContent " + checklistContent);
            checklist.put(projectPath, new HashSet<String>(Arrays.asList(checklistContent.split(","))));
        }
        if (checklist.containsKey(projectPath)) {
            return checklist.get(projectPath).contains(classLongName);
        }
        if (Cache.firstSealCache.equals(Cache.sealCache.get(projectPath))) {
            HashSet firstChecklist = checklist.get(Cache.firstSealProjectPath);
            checklist.put(projectPath, firstChecklist == null ? new HashSet() : firstChecklist);
            return checklist.get(projectPath).contains(classLongName);
        }
        return false;
    }

    public static boolean checklistOfAllLibsContain(String projectPath, String classLongName) {
        if (checklistOfAllLibsMap == null) {
            byte[] checklistOfAllLibsByte = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), "META-INF/winter/classes/checklist-of-all-libs.winter");
            if (checklistOfAllLibsByte == null) {
                checklistOfAllLibsMap = new HashMap<String, String>(1);
                Logger.debug(DecryptExecutor.class, "checklistOfAllLibsByte is null. ");
            } else {
                checklistOfAllLibsMap = new HashMap<String, String>(128);
                String checklistOfAllLibsContent = new String(checklistOfAllLibsByte, StandardCharsets.UTF_8);
                Logger.debug(DecryptExecutor.class, "checklistOfAllLibsContent " + checklistOfAllLibsContent);
                Arrays.stream(checklistOfAllLibsContent.split("\r\n")).filter(str -> !StrUtil.isBlank(str)).forEach(info -> {
                    String checklist;
                    String libDirRelativePath;
                    int idx = info.indexOf("=");
                    if (idx > 0) {
                        libDirRelativePath = info.substring(0, idx);
                        checklist = info.substring(idx + 1);
                        if (StrUtil.isBlank(checklist)) {
                            throw new ClassWinterException("lib[" + libDirRelativePath.substring(0, libDirRelativePath.length() - 4) + ".jar" + "]'s checklist is blank.");
                        }
                    } else {
                        throw new ClassWinterException("checklistOfAllLibsContent Incorrect format.");
                    }
                    Arrays.stream(checklist.split(",")).map(String::trim).forEach(nonSuffixClassLongName -> checklistOfAllLibsMap.put((String)nonSuffixClassLongName, libDirRelativePath));
                });
            }
        }
        return checklistOfAllLibsMap.containsKey(classLongName);
    }

    public static String getLibDirRelativePath(String classLongName) {
        Objects.requireNonNull(checklistOfAllLibsMap);
        return checklistOfAllLibsMap.get(classLongName);
    }

    public static boolean verifySeal(String projectPath, byte[] classBytes) {
        String seal = Cache.sealCache.get(projectPath);
        if (StrUtil.isBlank(seal)) {
            throw new ClassWinterException("seal should not be blank. curr projectPath -> " + projectPath + ". curr sealCache is -> " + Cache.sealCache);
        }
        return new String(classBytes, StandardCharsets.UTF_8).contains(seal);
    }

    public static boolean verifyLibSeal(String projectPath, String classLongName, byte[] classBytes) {
        if (Cache.libSealCache == null) {
            Cache.libSealCache = new HashMap<String, String>(8);
            checklistOfAllLibsMap.values().stream().distinct().forEach(libDirRelativePath -> {
                byte[] sealByte = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), libDirRelativePath + "seal.winter");
                if (sealByte == null) {
                    throw new ClassWinterException("Lib " + libDirRelativePath.substring(0, libDirRelativePath.length() - 4) + ".jar" + " missing seal information.");
                }
                String libSealContent = new String(sealByte, StandardCharsets.UTF_8);
                Logger.debug(DecryptExecutor.class, "seal(from lib[" + DecryptExecutor.parseLib(libDirRelativePath) + "]) is " + libSealContent);
                Cache.libSealCache.put((String)libDirRelativePath, libSealContent);
            });
        }
        String libDirRelativePath2 = DecryptExecutor.getLibDirRelativePath(classLongName);
        String sealContent = Cache.libSealCache.get(libDirRelativePath2);
        return new String(classBytes, StandardCharsets.UTF_8).contains(sealContent);
    }

    private static boolean checkPwdConsistency(String projectPath, String classWinterInfoDir, char[] password) {
        boolean userIfInputPwdWhileDecrypt;
        byte[] userIfInputPwdWhileEncryptFlag = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), classWinterInfoDir + "userIfInputPwd.winter");
        if (userIfInputPwdWhileEncryptFlag == null) {
            Logger.debug(DecryptExecutor.class, "\n\tworkbenchRoot -> " + projectPath + "\n\trelativeFilePath -> " + classWinterInfoDir + "userIfInputPwd.winter");
            throw new ClassWinterException("Not found content  of 'userIfInputPwd.winter'.");
        }
        boolean userIfInputPwdWhileEncrypt = Boolean.parseBoolean(new String(userIfInputPwdWhileEncryptFlag));
        boolean bl = userIfInputPwdWhileDecrypt = !StrUtil.isEmpty(password);
        if (userIfInputPwdWhileEncrypt && !userIfInputPwdWhileDecrypt) {
            throw new ClassWinterException("Please input password while starting project.");
        }
        return userIfInputPwdWhileDecrypt;
    }

    public static String parseLib(String classWinterInfoDir) {
        classWinterInfoDir = classWinterInfoDir.replace("META-INF/winter/classes/", "");
        return classWinterInfoDir.replace("_jar/", ".jar");
    }

    public static Map<String, Pair<byte[], byte[]>> unMaskNonClassFiles(String zipFilePath, char[] password) throws IOException {
        File zipFile = new File(zipFilePath);
        byte[] nonClassFileChecklistBytes = IOUtil.readFileFromWorkbenchRoot(zipFile, "META-INF/winter/checklist.non-classes.winter");
        if (nonClassFileChecklistBytes == null) {
            return new HashMap<String, Pair<byte[], byte[]>>(1);
        }
        String nonClassFileChecklist = new String(nonClassFileChecklistBytes, StandardCharsets.UTF_8);
        Logger.debug(DecryptExecutor.class, "nonClassFileChecklist -> " + nonClassFileChecklist);
        if (StrUtil.isBlank(nonClassFileChecklist)) {
            Logger.debug(DecryptExecutor.class, "nonClassFileChecklist is empty.");
            return new HashMap<String, Pair<byte[], byte[]>>(1);
        }
        Set needToDecryptNonClassFileSet = Arrays.stream(nonClassFileChecklist.split(",")).collect(Collectors.toSet());
        boolean userIfInputPwdWhileDecrypt = DecryptExecutor.checkPwdConsistency(zipFilePath, "META-INF/winter/", password);
        HashMap<String, byte[]> replaceMap = new HashMap<String, byte[]>(16);
        for (String zipEntryName : needToDecryptNonClassFileSet) {
            byte[] cleanedBytes = IOUtil.readFileFromWorkbenchRoot(zipFile, zipEntryName);
            if (!DecryptExecutor.verifySeal(zipFilePath, cleanedBytes)) continue;
            byte[] encryptedBytes = IOUtil.readFileFromWorkbenchRoot(zipFile, "META-INF/winter/non-classes/" + zipEntryName);
            byte[] bytes = EncryptUtil.decrypt(encryptedBytes, userIfInputPwdWhileDecrypt ? password : DecryptExecutor.obtainAutoGeneratedPwdWhileEncrypt(zipFilePath, "META-INF/winter/"));
            replaceMap.put(zipEntryName, bytes);
        }
        Logger.debug(DecryptExecutor.class, "un-mask non-classes contains -> " + replaceMap.keySet());
        return JarUtil.rewriteZipEntry(new ZipFile(zipFilePath), replaceMap);
    }

    private static char[] obtainAutoGeneratedPwdWhileEncrypt(String projectPath, String classWinterInfoDir) {
        if (classWinterInfoDir.equals("META-INF/winter/")) {
            char[] pwd = Cache.passwordCacheForDecrypt.get(projectPath);
            if (pwd != null) {
                return pwd;
            }
            byte[] passwordByte = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), "META-INF/winter/pwd.winter");
            if (passwordByte == null) {
                throw new ClassWinterException("please input password.");
            }
            passwordByte = EncryptUtil.decrypt(new String(passwordByte, StandardCharsets.UTF_8), Cache.sealCache.get(projectPath).toCharArray()).getBytes(StandardCharsets.UTF_8);
            String password = new String(passwordByte, StandardCharsets.UTF_8);
            char[] passwordCharArr = password.toCharArray();
            Cache.passwordCacheForDecrypt.put(projectPath, passwordCharArr);
            return Cache.passwordCacheForDecrypt.get(projectPath);
        }
        if (Cache.libPasswordCache != null && Cache.libPasswordCache.containsKey(classWinterInfoDir)) {
            return Cache.libPasswordCache.get(classWinterInfoDir);
        }
        Cache.libPasswordCache = new HashMap<String, char[]>(8);
        byte[] passwordByte = IOUtil.readFileFromWorkbenchRoot(new File(projectPath), classWinterInfoDir + "pwd.winter");
        Objects.requireNonNull(passwordByte);
        char[] passwordCharArr = EncryptUtil.decrypt(new String(passwordByte, StandardCharsets.UTF_8), Cache.sealCache.get(projectPath).toCharArray()).toCharArray();
        Cache.libPasswordCache.put(classWinterInfoDir, passwordCharArr);
        return passwordCharArr;
    }
}

