/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.util.StrUtil;

public final class EncryptUtil {
    private static final char[] SALT = new char[]{'c', 'h', 'i', '@', 'm', 'i', 'a', 'n', '#', 'y', 'a', 'o', '%', 'f', 'a', 'n', 'g', '^', 'y', 'a', 'n'};
    private static final String AES_MODE = "AES/ECB/PKCS5Padding";

    public static byte[] encrypt(byte[] source, char[] password) {
        try {
            String pwd = EncryptUtil.md5(StrUtil.toBytes(StrUtil.mergeChar(password, SALT)), true, true);
            return EncryptUtil.encryptByAes(source, pwd.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClassWinterException(e);
        }
    }

    public static byte[] decrypt(byte[] source, char[] password) {
        try {
            String pwd = EncryptUtil.md5(StrUtil.toBytes(StrUtil.mergeChar(password, SALT)), true, true);
            return EncryptUtil.decryptByAes(source, pwd.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClassWinterException(e);
        }
    }

    public static String encrypt(String source, char[] password) {
        Objects.requireNonNull(source, "source cannot be null.");
        return Base64.getEncoder().encodeToString(EncryptUtil.encrypt(source.getBytes(StandardCharsets.UTF_8), password));
    }

    public static String decrypt(String source, char[] password) {
        Objects.requireNonNull(source, "source cannot be null.");
        return new String(EncryptUtil.decrypt(Base64.getDecoder().decode(source), password), StandardCharsets.UTF_8);
    }

    public static char[] generateCharArr(int length) {
        char[] result = new char[length];
        Character[] chars = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('-'), Character.valueOf('='), Character.valueOf('_'), Character.valueOf('+'), Character.valueOf('.')};
        List<Character> list = Arrays.asList(chars);
        Collections.shuffle(list);
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            result[i] = i < chars.length ? list.get(i).charValue() : list.get(random.nextInt(chars.length)).charValue();
        }
        return result;
    }

    private static String md5(byte[] source, boolean abbreviation, boolean upperCase) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("md5");
        byte[] targetBytes = digest.digest(source);
        char[] characters = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder builder = new StringBuilder();
        for (byte b : targetBytes) {
            int high = b >> 4 & 0xF;
            int low = b & 0xF;
            char highChar = characters[high];
            char lowChar = characters[low];
            builder.append(highChar).append(lowChar);
        }
        String result = builder.toString();
        if (abbreviation) {
            result = result.substring(8, 24);
        }
        if (upperCase) {
            result = result.toUpperCase(Locale.ENGLISH);
        }
        return result;
    }

    private static byte[] encryptByAes(byte[] source, char[] key) {
        try {
            byte[] raw = StrUtil.toBytes(key);
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(AES_MODE);
            cipher.init(1, secretKeySpec);
            return cipher.doFinal(source);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ClassWinterException(e);
        }
    }

    private static byte[] decryptByAes(byte[] source, char[] key) {
        try {
            byte[] raw = StrUtil.toBytes(key);
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(AES_MODE);
            cipher.init(2, secretKeySpec);
            return cipher.doFinal(source);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new ClassWinterException(e);
        }
    }

    public static void main(String[] args) {
        String originStr = "\u563f~boy~";
        String encryptedContent = EncryptUtil.encrypt(originStr, "\u597d\u60f3\u5403\u70e7\u70e4JustryDeng123...".toCharArray());
        String plaintext = EncryptUtil.decrypt(encryptedContent, "\u597d\u60f3\u5403\u70e7\u70e4JustryDeng123...".toCharArray());
        System.err.println("\u539f\u6587\uff1a" + originStr);
        System.err.println("\u52a0\u5bc6\u540e\uff1a" + encryptedContent);
        System.err.println("\u89e3\u5bc6\u540e\uff1a" + plaintext);
    }
}

