/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.util.FileOrderSupport;
import winter.com.ideaaedi.classwinter.util.IOUtil;
import winter.com.ideaaedi.classwinter.util.Logger;
import winter.com.ideaaedi.classwinter.util.Pair;

public final class JarUtil {
    private static final String[] IGNORE_FILE_SUFFIX = new String[]{".DS_Store", "Thumbs.db"};

    public static String doJarWar(String srcDir, String targetJarOrWar) {
        return JarUtil.doJarWar(srcDir, targetJarOrWar, null);
    }

    public static String doJarWar(String srcDir, String targetJarOrWar, FileOrderSupport fileOrderSupport) {
        File jarDirFile = new File(srcDir);
        List<File> files = IOUtil.listSubFile(jarDirFile, 0);
        if (fileOrderSupport != null) {
            files = files.stream().sorted(Comparator.comparing(fileOrderSupport::obtainFileOrder)).collect(Collectors.toList());
        }
        ZipOutputStream zos = null;
        FileOutputStream out = null;
        try {
            File generatedJar = new File(targetJarOrWar);
            if (generatedJar.exists()) {
                IOUtil.delete(generatedJar);
            }
            int rootStartIndex = jarDirFile.getAbsolutePath().length() + 1;
            out = new FileOutputStream(generatedJar);
            zos = new ZipOutputStream(out);
            for (File file : files) {
                ZipEntry zipEntry;
                if (JarUtil.isIgnore(file)) continue;
                String fileName = file.getAbsolutePath().substring(rootStartIndex);
                fileName = fileName.replace(File.separator, "/");
                if (file.isDirectory()) {
                    zipEntry = new ZipEntry(fileName + "/");
                    zipEntry.setTime(file.lastModified());
                    zipEntry.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
                    zos.putNextEntry(zipEntry);
                } else if (fileName.endsWith(".jar")) {
                    byte[] bytes = IOUtil.toBytes(file);
                    ZipEntry ze = new ZipEntry(fileName);
                    ze.setMethod(0);
                    ze.setSize(bytes.length);
                    ze.setCrc(IOUtil.computeCrc32(bytes));
                    ze.setTime(file.lastModified());
                    ze.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
                    zos.putNextEntry(ze);
                    zos.write(bytes);
                } else {
                    zipEntry = new ZipEntry(fileName);
                    zipEntry.setTime(file.lastModified());
                    zipEntry.setLastModifiedTime(FileTime.fromMillis(file.lastModified()));
                    zos.putNextEntry(zipEntry);
                    byte[] bytes = IOUtil.toBytes(file);
                    zos.write(bytes);
                }
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            try {
                throw new ClassWinterException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(zos, out);
                throw throwable;
            }
        }
        IOUtil.close(zos, out);
        return targetJarOrWar;
    }

    public static <T extends Collection<String>> List<String> unJarWar(String jarWarPath, String targetDir) {
        return JarUtil.unJarWar(jarWarPath, targetDir, true, null);
    }

    public static <T extends Collection<String>> List<String> unJarWar(String jarWarPath, String targetDir, boolean delOldTargetDirIfAlreadyExist, T entryNamePrefixes) {
        LinkedHashSet<String> linkedSet = new LinkedHashSet<String>();
        File target = new File(targetDir);
        if (delOldTargetDirIfAlreadyExist) {
            IOUtil.delete(target);
        }
        JarUtil.guarantyDirExist(target);
        ZipFile zipFile = null;
        ArrayList<String> storeLastModifiedTimeList = new ArrayList<String>();
        HashMap<String, Long> filePthAndLastModifiedTimeMap = new HashMap<String, Long>(64);
        try {
            zipFile = new ZipFile(new File(jarWarPath));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                File targetFile;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryNamePrefixes != null && entryNamePrefixes.size() > 0) {
                    if (entryNamePrefixes.stream().noneMatch(entryName::startsWith)) continue;
                }
                if (entry.isDirectory()) {
                    targetFile = new File(target, entryName);
                    JarUtil.guarantyDirExist(targetFile);
                    String absolutePath = targetFile.getAbsolutePath();
                    linkedSet.add(absolutePath);
                    storeLastModifiedTimeList.add(absolutePath);
                    filePthAndLastModifiedTimeMap.put(absolutePath, entry.getLastModifiedTime().toMillis());
                    continue;
                }
                int lastSeparatorIndex = entryName.lastIndexOf("/");
                if (lastSeparatorIndex > 0) {
                    JarUtil.guarantyDirExist(new File(target, entryName.substring(0, lastSeparatorIndex)));
                }
                targetFile = new File(target, entryName);
                byte[] bytes = IOUtil.toBytes(zipFile.getInputStream(entry));
                IOUtil.toFile(bytes, targetFile, true);
                String absolutePath = targetFile.getAbsolutePath();
                linkedSet.add(absolutePath);
                storeLastModifiedTimeList.add(absolutePath);
                filePthAndLastModifiedTimeMap.put(absolutePath, entry.getLastModifiedTime().toMillis());
            }
        }
        catch (IOException e) {
            try {
                throw new ClassWinterException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(zipFile);
                throw throwable;
            }
        }
        IOUtil.close(zipFile);
        for (String filePath : storeLastModifiedTimeList) {
            Long lastModifiedTime = (Long)filePthAndLastModifiedTimeMap.get(filePath);
            new File(filePath).setLastModified(lastModifiedTime == null ? System.currentTimeMillis() : lastModifiedTime);
        }
        return new ArrayList<String>(linkedSet);
    }

    public static void guarantyDirExist(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static String getFileFromZip(File zip, String fileName, File targetFile) {
        byte[] bytes = JarUtil.getFileFromZip(zip, fileName);
        IOUtil.toFile(bytes, targetFile, true);
        return targetFile.getAbsolutePath();
    }

    public static Map<String, Pair<byte[], byte[]>> rewriteZipEntry(ZipFile zipFile, Map<String, byte[]> replacerMap) throws IOException {
        HashMap<String, Pair<byte[], byte[]>> map = new HashMap<String, Pair<byte[], byte[]>>(8);
        if (replacerMap == null || replacerMap.size() == 0) {
            return map;
        }
        if (zipFile == null) {
            Logger.warn("zipFile is null.");
            return map;
        }
        String zipFilePath = zipFile.getName();
        if (!new File(zipFilePath).exists()) {
            Logger.warn("zipFile [" + zipFilePath + "] non-exist.");
            return map;
        }
        LinkedList<ZipEntry> zipEntryList = new LinkedList<ZipEntry>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            zipEntryList.add(zipEntry);
        }
        try (FileOutputStream fos = new FileOutputStream(zipFilePath, true);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (ZipEntry zipEntry : zipEntryList) {
                String zipEntryName = zipEntry.getName();
                byte[] originBytes = IOUtil.toBytes(zipFile.getInputStream(zipEntry));
                byte[] replaceBytes = replacerMap.get(zipEntryName);
                if (replacerMap.containsKey(zipEntryName) && replaceBytes != null) {
                    ZipEntry ze = new ZipEntry(zipEntryName);
                    ze.setMethod(0);
                    ze.setSize(replaceBytes.length);
                    ze.setCrc(IOUtil.computeCrc32(replaceBytes));
                    ze.setTime(zipEntry.getTime());
                    ze.setLastModifiedTime(zipEntry.getLastModifiedTime());
                    zos.putNextEntry(ze);
                    zos.write(replaceBytes);
                    map.put(zipEntryName, Pair.of(originBytes, replaceBytes));
                    continue;
                }
                zos.putNextEntry(new ZipEntry(zipEntry));
                zos.write(originBytes);
            }
        }
        return map;
    }

    public static byte[] getFileFromZip(File zip, String fileName) {
        byte[] byArray;
        ZipEntry zipEntry;
        InputStream is;
        ZipFile zipFile;
        block7: {
            block6: {
                zipFile = null;
                is = null;
                if (zip.exists()) break block6;
                byte[] byArray2 = null;
                IOUtil.close(is, zipFile);
                return byArray2;
            }
            zipFile = new ZipFile(zip);
            zipEntry = zipFile.getEntry(fileName);
            if (zipEntry != null) break block7;
            byte[] byArray3 = null;
            IOUtil.close(is, zipFile);
            return byArray3;
        }
        try {
            is = zipFile.getInputStream(zipEntry);
            byArray = IOUtil.toBytes(is);
        }
        catch (IOException e) {
            try {
                throw new ClassWinterException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is, zipFile);
                throw throwable;
            }
        }
        IOUtil.close(is, zipFile);
        return byArray;
    }

    public static boolean isJarOrWar(String originJarOrWar) throws IllegalArgumentException {
        if (originJarOrWar.endsWith(".jar")) {
            return true;
        }
        if (originJarOrWar.endsWith(".war")) {
            return false;
        }
        throw new IllegalArgumentException("suffix-file [" + originJarOrWar + "] is not support.");
    }

    private static boolean isIgnore(File file) {
        for (String suffix : IGNORE_FILE_SUFFIX) {
            if (!file.getAbsolutePath().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String getRootPath(String projectPath) {
        Objects.requireNonNull(projectPath, "projectPath cannot be null.");
        if (projectPath.startsWith("jar:") || projectPath.startsWith("war:")) {
            projectPath = projectPath.substring(4);
        }
        if (projectPath.startsWith("file:")) {
            projectPath = projectPath.substring(5);
        }
        if (projectPath.contains("*")) {
            return projectPath.substring(0, projectPath.indexOf("*"));
        }
        if (projectPath.contains(".war!/WEB-INF")) {
            return projectPath.substring(0, projectPath.indexOf(".war!/WEB-INF") + ".war".length());
        }
        if (IOUtil.readFileFromWorkbenchRoot(new File(projectPath), "META-INF/winter/seal.winter") != null) {
            return projectPath;
        }
        if (projectPath.contains("WEB-INF")) {
            return projectPath.substring(0, projectPath.indexOf("WEB-INF"));
        }
        if (projectPath.contains("!")) {
            return projectPath.substring(0, projectPath.indexOf("!"));
        }
        if (projectPath.endsWith(".jar") || projectPath.endsWith(".war")) {
            return projectPath;
        }
        if (projectPath.contains("/classes/")) {
            return projectPath.substring(0, projectPath.indexOf("/classes/") + "/classes/".length());
        }
        throw new ClassWinterException(projectPath);
    }
}

