/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.io.File;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import winter.com.ideaaedi.classwinter.exception.ClassWinterException;
import winter.com.ideaaedi.classwinter.util.IOUtil;
import winter.com.ideaaedi.classwinter.util.Logger;

public class JavaagentCmdArgs {
    private String password;
    private String skipProjectPathPrefix;
    private String decryptProjectPathPrefix;
    private boolean debug;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String toString() {
        return "JavaagentCmdArgs{password='" + this.password + '\'' + "skipProjectPathPrefix='" + this.skipProjectPathPrefix + '\'' + "decryptProjectPathPrefix='" + this.decryptProjectPathPrefix + '\'' + ", debug=" + this.debug + '}';
    }

    public static JavaagentCmdArgs parseJavaagentCmdArgs(String args) {
        if (args == null) {
            return new JavaagentCmdArgs();
        }
        if (args.contains(" ")) {
            throw new ClassWinterException("-javaagent args [" + args + "] cannot contain whitespace.");
        }
        String[] keyValueArr = args.split(",");
        JavaagentCmdArgs instance = new JavaagentCmdArgs();
        for (String keyValue : keyValueArr) {
            String filepath;
            if ((keyValue = keyValue.trim()).startsWith("passwordFromFile=")) {
                filepath = keyValue.substring("passwordFromFile=".length());
                Logger.debug(JavaagentCmdArgs.class, "passwordFromFile -> " + filepath);
                instance.setPassword(IOUtil.readContentFromFile(new File(filepath)).trim());
                continue;
            }
            if (keyValue.startsWith("passwordFromShell=")) {
                filepath = keyValue.substring("passwordFromShell=".length());
                String shellContent = IOUtil.readContentFromFile(new File(filepath)).trim();
                Logger.debug(JavaagentCmdArgs.class, "passwordFromShell -> " + shellContent);
                List<String> shellResultList = JavaagentCmdArgs.runShell(shellContent);
                if (shellResultList.size() == 0) {
                    throw new IllegalArgumentException("There is not any result returned from shell. \n" + shellContent);
                }
                String password = shellResultList.get(0).trim();
                if (shellResultList.size() > 1) {
                    Logger.debug(JavaagentCmdArgs.class, String.format("There is multi result returned from shell. \n shellResultList is %s. Use the first result '%s' as password.", shellResultList, password));
                }
                instance.setPassword(password);
                continue;
            }
            if (keyValue.startsWith("password=")) {
                instance.setPassword(keyValue.substring("password=".length()));
                continue;
            }
            if (keyValue.startsWith("skipProjectPathPrefix=")) {
                instance.setSkipProjectPathPrefix(keyValue.substring("skipProjectPathPrefix=".length()));
                continue;
            }
            if (keyValue.startsWith("decryptProjectPathPrefix=")) {
                instance.setDecryptProjectPathPrefix(keyValue.substring("decryptProjectPathPrefix=".length()));
                continue;
            }
            if (!keyValue.startsWith("debug=")) continue;
            instance.setDebug(Boolean.parseBoolean(keyValue.substring("debug=".length())));
        }
        return instance;
    }

    public static List<String> runShell(String shStr) {
        ArrayList<String> strList = new ArrayList<String>(4);
        try {
            String line;
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shStr}, null, null);
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
            process.waitFor();
            while ((line = lineNumberReader.readLine()) != null) {
                strList.add(line);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Get result from shell error. \n" + shStr, e);
        }
        return strList;
    }

    public String getSkipProjectPathPrefix() {
        return this.skipProjectPathPrefix;
    }

    public void setSkipProjectPathPrefix(String skipProjectPathPrefix) {
        this.skipProjectPathPrefix = skipProjectPathPrefix;
    }

    public String getDecryptProjectPathPrefix() {
        return this.decryptProjectPathPrefix;
    }

    public void setDecryptProjectPathPrefix(String decryptProjectPathPrefix) {
        this.decryptProjectPathPrefix = decryptProjectPathPrefix;
    }
}

