/*
 * Decompiled with CFR 0.152.
 */
package winter.com.ideaaedi.classwinter.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class StrUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isTrueDefault(String str, boolean defaultValue) {
        if (StrUtil.isBlank(str)) {
            return defaultValue;
        }
        return str.equalsIgnoreCase("true");
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(char[] str) {
        return str == null || str.length == 0;
    }

    public static String insertStrAfterLine(String[] origin, String insertStr, String linePrefix) {
        StringBuilder newStr = new StringBuilder();
        boolean alreadyInsert = false;
        for (String str : origin) {
            newStr.append(str).append(System.lineSeparator());
            if (!str.startsWith(linePrefix)) continue;
            newStr.append(insertStr).append(System.lineSeparator());
            alreadyInsert = true;
        }
        if (!alreadyInsert) {
            newStr.append(insertStr).append(System.lineSeparator());
        }
        return newStr.toString();
    }

    public static Set<String> strToSet(String str) {
        return StrUtil.strToSet(str, ",");
    }

    public static Set<String> strToSet(String str, String split) {
        HashSet<String> set = new HashSet<String>();
        if (!StrUtil.isBlank(str)) {
            String[] arr;
            str = str.trim();
            for (String item : arr = str.split(split)) {
                if (StrUtil.isEmpty(item)) continue;
                item = item.trim();
                set.add(item);
            }
        }
        return set;
    }

    public static char[] mergeChar(char[] ... charArr) {
        int length = 0;
        for (char[] c : charArr) {
            length += c.length;
        }
        char[] chars = new char[length];
        int lastLength = 0;
        for (char[] c : charArr) {
            System.arraycopy(c, 0, chars, lastLength, c.length);
            lastLength += c.length;
        }
        return chars;
    }

    public static byte[] toBytes(char[] charArr) {
        char[] chars0 = new char[charArr.length];
        System.arraycopy(charArr, 0, chars0, 0, charArr.length);
        CharBuffer charBuffer = CharBuffer.wrap(chars0);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static boolean startsWithOrRegMatched(String prefixOrRegex, String text) {
        return text.startsWith(prefixOrRegex) || StrUtil.regMatched(prefixOrRegex, text);
    }

    public static boolean regMatched(String patternStr, String text) {
        return StrUtil.regMatched(Pattern.compile(patternStr), text);
    }

    public static boolean regMatched(Pattern pattern, String text) {
        return pattern.matcher(text).find();
    }
}

