/*
 * Decompiled with CFR 0.152.
 */
package com.ikingtech.platform.service.application.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ikingtech.framework.sdk.application.api.ApplicationApi;
import com.ikingtech.framework.sdk.application.model.ApplicationDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationQueryParamDTO;
import com.ikingtech.framework.sdk.base.model.PageResult;
import com.ikingtech.framework.sdk.context.event.TenantInitEvent;
import com.ikingtech.framework.sdk.context.event.application.ApplicationMenuRemoveEvent;
import com.ikingtech.framework.sdk.context.event.application.ApplicationPublishEvent;
import com.ikingtech.framework.sdk.context.event.application.DevApplicationMenuInitEvent;
import com.ikingtech.framework.sdk.context.exception.FrameworkException;
import com.ikingtech.framework.sdk.context.exception.FrameworkExceptionInfo;
import com.ikingtech.framework.sdk.context.security.Me;
import com.ikingtech.framework.sdk.core.response.R;
import com.ikingtech.framework.sdk.data.mybatisplus.entity.BaseEntity;
import com.ikingtech.framework.sdk.enums.application.ApplicationStatusEnum;
import com.ikingtech.framework.sdk.utils.Tools;
import com.ikingtech.framework.sdk.web.annotation.ApiController;
import com.ikingtech.platform.service.application.entity.ApplicationDO;
import com.ikingtech.platform.service.application.entity.ApplicationPageDO;
import com.ikingtech.platform.service.application.exception.ApplicationExceptionInfo;
import com.ikingtech.platform.service.application.service.repository.ApplicationPageRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationRepository;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@ApiController(value={"/application"}, name="\u5e94\u7528\u4e2d\u5fc3-\u5e94\u7528\u7ba1\u7406", description="\u5e94\u7528\u4e2d\u5fc3-\u5e94\u7528\u7ba1\u7406")
public class ApplicationController
implements ApplicationApi {
    private static final Logger log = LoggerFactory.getLogger(ApplicationController.class);
    private final ApplicationRepository repo;
    private final ApplicationPageRepository pageRepo;
    private final ApplicationContext applicationContext;
    private static final String DEFAULT_APPLICATION_ICON = "ikflow-dingdan";
    private static final String DEFAULT_APPLICATION_ICON_BACKGROUND = "#1e90ff";

    @Transactional(rollbackFor={Exception.class})
    public R<ApplicationDTO> add(ApplicationDTO application) {
        ApplicationDO entity = (ApplicationDO)Tools.Bean.copy((Object)application, ApplicationDO.class);
        entity.setId(Tools.Id.uuid());
        entity.setCode(Tools.Id.uuid());
        entity.setIcon(DEFAULT_APPLICATION_ICON);
        entity.setIconBackground(DEFAULT_APPLICATION_ICON_BACKGROUND);
        entity.setStatus(ApplicationStatusEnum.UNPUBLISHED.name());
        entity.setTenantCode(Me.tenantCode());
        this.repo.save(entity);
        return R.ok((Object)this.modelConvert(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public R<Object> delete(String id) {
        final ApplicationDO entity = (ApplicationDO)this.repo.getById((Serializable)((Object)id));
        this.repo.removeById((Serializable)((Object)id));
        this.pageRepo.remove((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageDO::getAppCode, (Object)entity.getCode()));
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                ApplicationController.this.applicationContext.publishEvent((ApplicationEvent)new ApplicationMenuRemoveEvent((Object)this, entity.getCode()));
            }
        });
        return R.ok();
    }

    @Transactional(rollbackFor={Exception.class})
    public R<Object> update(ApplicationDTO application) {
        ApplicationDO existEntity = (ApplicationDO)this.repo.getById((Serializable)((Object)application.getId()));
        if (null == existEntity) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.APPLICATION_NOT_FOUND);
        }
        ApplicationDO newEntity = (ApplicationDO)Tools.Bean.copy((Object)application, ApplicationDO.class);
        newEntity.setCode(existEntity.getCode());
        this.repo.updateById(newEntity);
        return R.ok((Object)this.modelConvert(newEntity));
    }

    public R<List<ApplicationDTO>> page(ApplicationQueryParamDTO queryParam) {
        return R.ok((PageResult)PageResult.build((Page)((Page)this.repo.page((IPage)new Page((long)queryParam.getPage(), (long)queryParam.getRows()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(Tools.Str.isNotBlank((String)queryParam.getName()), ApplicationDO::getName, (Object)queryParam.getName())).eq(Tools.Str.isNotBlank((String)queryParam.getStatus()), ApplicationDO::getStatus, (Object)queryParam.getStatus())).like(Tools.Str.isNotBlank((String)queryParam.getRemark()), ApplicationDO::getRemark, (Object)queryParam.getRemark())).orderByDesc(BaseEntity::getCreateTime)))).convertBatch(this::modelConvert));
    }

    public R<List<ApplicationDTO>> all() {
        return R.ok(this.modelConvert(this.repo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationDO::getStatus, (Object)ApplicationStatusEnum.PUBLISHED.name()))));
    }

    public R<ApplicationDTO> detail(String id) {
        ApplicationDO entity = (ApplicationDO)this.repo.getById((Serializable)((Object)id));
        if (null == entity) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.APPLICATION_NOT_FOUND);
        }
        return R.ok((Object)this.modelConvert(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public R<Object> publish(String id) {
        final ApplicationDO entity = (ApplicationDO)this.repo.getById((Serializable)((Object)id));
        entity.setStatus(ApplicationStatusEnum.PUBLISHED.name());
        this.repo.updateById(entity);
        List designedPageEntities = Tools.Coll.filter((Collection)this.pageRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageDO::getAppCode, (Object)entity.getCode())), pageEntity -> Tools.Str.isNotBlank((String)pageEntity.getJson()));
        if (Tools.Coll.isNotBlank((Collection)designedPageEntities)) {
            this.pageRepo.updateBatchById(Tools.Coll.traverse((List)designedPageEntities, pageEntity -> {
                pageEntity.setRenderJson(pageEntity.getJson());
                return pageEntity;
            }));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    ApplicationController.this.applicationContext.publishEvent((ApplicationEvent)new ApplicationPublishEvent((Object)this, entity.getCode()));
                }
            });
        }
        return R.ok();
    }

    @EventListener
    public void tenantInitListener(TenantInitEvent event) {
        List entities = this.repo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationDO::getStatus, (Object)ApplicationStatusEnum.PUBLISHED.name()));
        if (Tools.Coll.isBlank((Collection)entities)) {
            return;
        }
        entities.forEach(entity -> this.applicationContext.publishEvent((ApplicationEvent)new DevApplicationMenuInitEvent((Object)this, Tools.Coll.newList((Object[])new String[]{event.getCode()}), entity.getCode())));
    }

    private List<ApplicationDTO> modelConvert(List<ApplicationDO> entities) {
        return Tools.Coll.convertList(entities, this::modelConvert);
    }

    private ApplicationDTO modelConvert(ApplicationDO entity) {
        ApplicationDTO application = (ApplicationDTO)Tools.Bean.copy((Object)entity, ApplicationDTO.class);
        if (null != application.getStatus()) {
            application.setStatusName(application.getStatus().description);
        }
        if (null != application.getType()) {
            application.setTypeName(application.getType().description);
        }
        return application;
    }

    public ApplicationController(ApplicationRepository repo, ApplicationPageRepository pageRepo, ApplicationContext applicationContext) {
        this.repo = repo;
        this.pageRepo = pageRepo;
        this.applicationContext = applicationContext;
    }
}

