/*
 * Decompiled with CFR 0.152.
 */
package com.ikingtech.platform.service.application.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ikingtech.framework.sdk.approve.api.ApproveFormInstanceApi;
import com.ikingtech.framework.sdk.approve.embedded.ApproveOps;
import com.ikingtech.framework.sdk.approve.model.ApproveFormInstanceDTO;
import com.ikingtech.framework.sdk.approve.model.ApproveFormInstancePreviewParamDTO;
import com.ikingtech.framework.sdk.base.model.PageResult;
import com.ikingtech.framework.sdk.context.exception.FrameworkException;
import com.ikingtech.framework.sdk.context.exception.FrameworkExceptionInfo;
import com.ikingtech.framework.sdk.context.security.Me;
import com.ikingtech.framework.sdk.core.response.R;
import com.ikingtech.framework.sdk.enums.application.ApplicationPageTypeEnum;
import com.ikingtech.framework.sdk.enums.approve.ApproveFormInstancePreviewTypeEnum;
import com.ikingtech.framework.sdk.enums.approve.ApproveFormTypeEnum;
import com.ikingtech.framework.sdk.utils.Tools;
import com.ikingtech.framework.sdk.web.annotation.ApiController;
import com.ikingtech.framework.sdk.web.annotation.PostRequest;
import com.ikingtech.platform.service.application.entity.ApplicationGeneralDataDO;
import com.ikingtech.platform.service.application.entity.ApplicationModelDO;
import com.ikingtech.platform.service.application.entity.ApplicationModelRelationDO;
import com.ikingtech.platform.service.application.entity.ApplicationPageDO;
import com.ikingtech.platform.service.application.entity.ApplicationPageModelDO;
import com.ikingtech.platform.service.application.exception.ApplicationExceptionInfo;
import com.ikingtech.platform.service.application.service.repository.ApplicationGeneralDataRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelRelationRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationPageModelRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationPageRepository;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@ApiController(value={"/application/general-data"}, name="\u5e94\u7528\u4e2d\u5fc3-\u901a\u7528\u6570\u636e\u7ba1\u7406", description="\u5e94\u7528\u4e2d\u5fc3-\u901a\u7528\u6570\u636e\u7ba1\u7406")
public class ApplicationGeneralDataController {
    private final ApplicationGeneralDataRepository service;
    private final ApplicationPageRepository pageRepo;
    private final ApplicationPageModelRepository pageModelRepo;
    private final ApplicationModelRepository modelService;
    private final ApplicationModelRelationRepository modelRelationService;
    private final ApproveFormInstanceApi approveFormInstanceApi;
    private final SqlHelper sqlHelper;

    @PostRequest(order=1, value={"/add"}, summary="\u6dfb\u52a0\u9875\u9762\u6570\u636e", description="\u6dfb\u52a0\u9875\u9762\u6570\u636e")
    public R<Object> add(@Parameter(name="page", description="\u9875\u9762\u7f16\u53f7") @RequestParam String page, @Parameter(name="businessCode", description="\u4e1a\u52a1\u7f16\u53f7") @RequestParam(required=false) String businessCode, @Parameter(name="data", description="\u9875\u9762\u6570\u636e") @RequestBody Object data) {
        ApplicationPageDO pageEntity = (ApplicationPageDO)this.pageRepo.getById((Serializable)((Object)page));
        ArrayList<ApplicationPageModelDO> pageModelEntities = null == pageEntity ? new ArrayList<ApplicationPageModelDO>() : this.pageModelRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)pageEntity.getId()));
        Map dataMap = Tools.Json.objToMap((Object)data);
        this.setCommonField(dataMap);
        if (Tools.Coll.isNotBlank(pageModelEntities)) {
            this.dealWithPageModel(pageModelEntities, modelEntity -> this.sqlHelper.save(modelEntity.getCode(), dataMap), (modelEntity, slaveModelEntity) -> {
                Object slaveModelData = dataMap.get(slaveModelEntity.getCode() + "List");
                Map slaveModelDataMap = Tools.Json.objToMap(slaveModelData);
                this.setCommonField(slaveModelDataMap);
                slaveModelDataMap.put(modelEntity.getCode() + "Id", dataMap.get("id"));
                this.sqlHelper.save(slaveModelEntity.getCode(), slaveModelDataMap);
                dataMap.remove(slaveModelEntity.getCode() + "List");
            });
        } else {
            ApplicationGeneralDataDO entity = new ApplicationGeneralDataDO();
            entity.setId((String)dataMap.get("id"));
            entity.setBusinessCode(businessCode);
            entity.setData(Tools.Json.toJsonStr((Object)data));
            entity.setPageId(page);
            this.service.save(entity);
        }
        if (null != pageEntity && ApplicationPageTypeEnum.APPROVE.name().equals(pageEntity.getType())) {
            ApproveFormInstancePreviewParamDTO previewParam = new ApproveFormInstancePreviewParamDTO();
            previewParam.setPreviewType(ApproveFormInstancePreviewTypeEnum.BY_FORM_CONFIG);
            previewParam.setFormType(ApproveFormTypeEnum.PROCESS_ONLY);
            previewParam.setFormBusinessType(pageEntity.getName());
            String formData = Tools.Json.toJsonStr((Object)data);
            previewParam.setFormData(formData);
            ApproveFormInstanceDTO formInstance = (ApproveFormInstanceDTO)this.approveFormInstanceApi.preview(previewParam).getData();
            formInstance.setBusinessDataId((String)dataMap.get("id"));
            formInstance.setFormData(formData);
            ApproveOps.submit((ApproveFormInstanceDTO)formInstance);
        }
        return R.ok();
    }

    @PostRequest(order=2, value={"/delete"}, summary="\u5220\u9664\u6570\u636e", description="\u5220\u9664\u6570\u636e")
    public R<Object> delete(@Parameter(name="page", description="\u9875\u9762\u7f16\u53f7") @RequestParam String page, @Parameter(name="id", description="\u6570\u636e\u7f16\u53f7") @RequestBody String id) {
        ArrayList<ApplicationPageModelDO> pageModelEntities;
        ApplicationPageDO pageEntity = (ApplicationPageDO)this.pageRepo.getById((Serializable)((Object)page));
        List<ApplicationPageModelDO> list = pageModelEntities = null == pageEntity ? new ArrayList<ApplicationPageModelDO>() : this.pageModelRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)pageEntity.getId()));
        if (Tools.Coll.isNotBlank(pageModelEntities)) {
            this.dealWithPageModel(pageModelEntities, modelEntity -> this.sqlHelper.removeById(modelEntity.getCode(), id), (modelEntity, slaveModelEntity) -> this.sqlHelper.removeBy(slaveModelEntity.getCode(), modelEntity.getCode() + "Id", id));
        } else {
            this.service.removeById((Serializable)((Object)id));
        }
        return R.ok();
    }

    @PostRequest(order=3, value={"/update"}, summary="\u66f4\u65b0\u9875\u9762\u6570\u636e", description="\u66f4\u65b0\u9875\u9762\u6570\u636e")
    public R<Object> update(@Parameter(name="page", description="\u9875\u9762\u7f16\u53f7") @RequestParam String page, @Parameter(name="data", description="\u9875\u9762\u6570\u636e") @RequestBody Object data) {
        ApplicationPageDO pageEntity = (ApplicationPageDO)this.pageRepo.getById((Serializable)((Object)page));
        ArrayList<ApplicationPageModelDO> pageModelEntities = null == pageEntity ? new ArrayList<ApplicationPageModelDO>() : this.pageModelRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)pageEntity.getId()));
        Map dataMap = Tools.Json.objToMap((Object)data);
        String masterModelId = (String)dataMap.get("id");
        this.setCommonField(dataMap);
        if (Tools.Coll.isNotBlank(pageModelEntities)) {
            this.dealWithPageModel(pageModelEntities, modelEntity -> this.sqlHelper.updateById(modelEntity.getCode(), dataMap), (modelEntity, slaveModelEntity) -> {
                Object slaveModelData = dataMap.get(slaveModelEntity.getCode() + "List");
                Map slaveModelDataMap = Tools.Json.objToMap(slaveModelData);
                this.setCommonField(slaveModelDataMap);
                slaveModelDataMap.put(modelEntity.getCode() + "Id", masterModelId);
                this.sqlHelper.removeBy(slaveModelEntity.getCode(), modelEntity.getCode() + "Id", masterModelId);
                this.sqlHelper.save(slaveModelEntity.getCode(), slaveModelDataMap);
                dataMap.remove(slaveModelEntity.getCode() + "List");
            });
        } else {
            ApplicationGeneralDataDO entity = (ApplicationGeneralDataDO)this.service.getById((Serializable)((Object)masterModelId));
            entity.setData(Tools.Json.toJsonStr((Object)data));
            this.service.updateById(entity);
        }
        return R.ok();
    }

    @PostRequest(order=4, value={"/list/page"}, summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public R<List<Map<String, Object>>> page(@Parameter(name="page", description="\u9875\u9762\u7f16\u53f7") @RequestParam String page, @Parameter(name="data", description="\u67e5\u8be2\u53c2\u6570") @RequestBody Object data) {
        ApplicationPageDO pageEntity = (ApplicationPageDO)this.pageRepo.getById((Serializable)((Object)page));
        ArrayList pageModelEntities = null == pageEntity ? new ArrayList() : this.pageModelRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)pageEntity.getId()));
        Map dataMap = Tools.Json.objToMap((Object)data);
        if (Tools.Coll.isNotBlank(pageModelEntities)) {
            ApplicationModelDO modelEntity = (ApplicationModelDO)this.modelService.getById((Serializable)((Object)((ApplicationPageModelDO)pageModelEntities.get(0)).getModelId()));
            if (null == modelEntity) {
                throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_NOT_FOUND);
            }
            return R.ok(this.sqlHelper.page(modelEntity.getCode(), dataMap));
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ApplicationGeneralDataDO::getPageId, (Object)page);
        dataMap.forEach((key, value) -> {
            if (!"page".equals(key) && !"rows".equals(key) && null != value) {
                if (value instanceof List) {
                    queryWrapper.apply("JSON_CONTAINS(data, JSON_OBJECT('" + key + "', {0}))", new Object[]{value});
                } else {
                    queryWrapper.apply("data -> '$." + key + "' LIKE CONCAT('%', {0}, '%')", new Object[]{value});
                }
            }
        });
        Page pageResult = (Page)this.service.page((IPage)new Page((long)((Integer)dataMap.get("page")).intValue(), (long)((Integer)dataMap.get("rows")).intValue()), (Wrapper)queryWrapper);
        return R.ok((PageResult)PageResult.build((long)pageResult.getPages(), (long)pageResult.getTotal(), (List)Tools.Coll.convertList((Collection)pageResult.getRecords(), this::generalDataConvert)));
    }

    @PostRequest(order=5, value={"/detail"}, summary="\u83b7\u53d6\u8be6\u60c5", description="\u83b7\u53d6\u8be6\u60c5")
    public R<Map<String, Object>> detail(@Parameter(name="page", description="\u9875\u9762\u7f16\u53f7") @RequestParam String page, @Parameter(name="id", description="\u6570\u636e\u7f16\u53f7") @RequestBody String id) {
        ArrayList pageModelEntities;
        ApplicationPageDO pageEntity = (ApplicationPageDO)this.pageRepo.getById((Serializable)((Object)page));
        List list = pageModelEntities = null == pageEntity ? new ArrayList() : this.pageModelRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)pageEntity.getId()));
        if (Tools.Coll.isNotBlank(pageModelEntities)) {
            ApplicationModelDO modelEntity = (ApplicationModelDO)this.modelService.getById((Serializable)((Object)((ApplicationPageModelDO)pageModelEntities.get(0)).getModelId()));
            if (null == modelEntity) {
                throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_NOT_FOUND);
            }
            return R.ok(this.sqlHelper.getById(modelEntity.getCode(), id));
        }
        return R.ok(this.generalDataConvert((ApplicationGeneralDataDO)this.service.getById((Serializable)((Object)id))));
    }

    @PostRequest(order=6, value={"/list/all"}, summary="\u83b7\u53d6\u6240\u6709\u6570\u636e\u5217\u8868", description="\u83b7\u53d6\u6240\u6709\u6570\u636e\u5217\u8868")
    public R<List<Map<String, Object>>> all(@Parameter(name="page", description="\u9875\u9762\u7f16\u53f7") @RequestParam String page, @Parameter(name="businessCode", description="\u4e1a\u52a1\u7f16\u53f7") @RequestParam(required=false) String businessCode) {
        ApplicationPageDO pageEntity = (ApplicationPageDO)this.pageRepo.getById((Serializable)((Object)page));
        List pageModelEntities = this.pageModelRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)pageEntity.getId()));
        if (Tools.Coll.isNotBlank((Collection)pageModelEntities)) {
            ApplicationModelDO modelEntity = (ApplicationModelDO)this.modelService.getById((Serializable)((Object)((ApplicationPageModelDO)pageModelEntities.get(0)).getModelId()));
            if (null == modelEntity) {
                throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_NOT_FOUND);
            }
            return R.ok(this.sqlHelper.list(modelEntity.getCode()));
        }
        return R.ok((Object)Tools.Coll.convertList((Collection)this.service.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ApplicationGeneralDataDO::getPageId, (Object)page)).eq(Tools.Str.isNotBlank((String)businessCode), ApplicationGeneralDataDO::getBusinessCode, (Object)businessCode)), this::generalDataConvert));
    }

    private Map<String, Object> generalDataConvert(ApplicationGeneralDataDO entity) {
        Map rowData = Tools.Json.toMap((String)entity.getData());
        rowData.put("id", entity.getId());
        rowData.put("createBy", entity.getCreateBy());
        rowData.put("createName", entity.getCreateName());
        rowData.put("createTime", Tools.DateTime.Formatter.simple((LocalDateTime)entity.getCreateTime()));
        rowData.put("updateBy", entity.getUpdateBy());
        rowData.put("updateName", entity.getUpdateName());
        rowData.put("updateTime", Tools.DateTime.Formatter.simple((LocalDateTime)entity.getUpdateTime()));
        return rowData;
    }

    private void setCommonField(Map<String, Object> data) {
        if (!data.containsKey("id")) {
            data.put("id", Tools.Id.uuid());
            data.put("createBy", Me.id());
            data.put("createName", Me.username());
            data.put("createTime", Tools.DateTime.Formatter.simple());
        }
        data.put("updateBy", Me.id());
        data.put("updateName", Me.username());
        data.put("updateTime", Tools.DateTime.Formatter.simple());
    }

    private void dealWithPageModel(List<ApplicationPageModelDO> pageModelEntities, Consumer<ApplicationModelDO> masterModelDealer, BiConsumer<ApplicationModelDO, ApplicationModelDO> slaveModelDealer) {
        if (pageModelEntities.size() > 1) {
            throw new FrameworkException("notSupported");
        }
        ApplicationModelDO modelEntity = (ApplicationModelDO)this.modelService.getById((Serializable)((Object)pageModelEntities.get(0).getModelId()));
        if (null == modelEntity) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_NOT_FOUND);
        }
        List modelRelationEntities = this.modelRelationService.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationModelRelationDO::getMasterModelId, (Object)modelEntity.getId()));
        if (Tools.Coll.isNotBlank((Collection)modelRelationEntities)) {
            List slaveModelEntities = this.modelService.listByIds(Tools.Coll.convertList((Collection)modelRelationEntities, ApplicationModelRelationDO::getModelId));
            for (ApplicationModelDO slaveModelEntity : slaveModelEntities) {
                slaveModelDealer.accept(modelEntity, slaveModelEntity);
            }
        }
        masterModelDealer.accept(modelEntity);
    }

    public ApplicationGeneralDataController(ApplicationGeneralDataRepository service, ApplicationPageRepository pageRepo, ApplicationPageModelRepository pageModelRepo, ApplicationModelRepository modelService, ApplicationModelRelationRepository modelRelationService, ApproveFormInstanceApi approveFormInstanceApi, SqlHelper sqlHelper) {
        this.service = service;
        this.pageRepo = pageRepo;
        this.pageModelRepo = pageModelRepo;
        this.modelService = modelService;
        this.modelRelationService = modelRelationService;
        this.approveFormInstanceApi = approveFormInstanceApi;
        this.sqlHelper = sqlHelper;
    }

    public static class SqlHelper {
        private final JdbcTemplate jdbcTemplate;
        private static final String INSERT_SQL_TEMPLATE = "INSERT INTO {} ({}) VALUES ({})";
        private static final String DELETE_SQL_TEMPLATE = "DELETE FROM {} WHERE {} = {}";
        private static final String UPDATE_SQL_TEMPLATE = "UPDATE {} SET {} WHERE {} = {}";
        private static final String UPDATE_FIELD_SQL_TEMPLATE = "{} = {}";
        private static final String SELECT_SQL_TEMPLATE = "SELECT * FROM {} WHERE {}";
        private static final String PAGE_SQL_TEMPLATE = "SELECT * FROM {} WHERE {} LIMIT {}, {}";

        public void save(String tableName, Map<String, Object> data) {
            String formattedSql = Tools.Str.format((String)INSERT_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)tableName), Tools.Coll.join((Collection)Tools.Coll.convertList(new ArrayList<String>(data.keySet()), Tools.Str::toSnakeCase)), Tools.Coll.join((Collection)Tools.Coll.convertList(new ArrayList<Object>(data.values()), value -> value instanceof String ? "'" + value + "'" : String.valueOf(value)))});
            this.jdbcTemplate.update(formattedSql);
        }

        public void removeById(String tableName, String id) {
            String formattedSql = Tools.Str.format((String)DELETE_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)tableName), "id", "'" + id + "'"});
            this.jdbcTemplate.update(formattedSql);
        }

        public void removeBy(String tableName, String columnName, String value) {
            this.jdbcTemplate.update(Tools.Str.format((String)DELETE_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)tableName), Tools.Str.toSnakeCase((String)columnName), value}));
        }

        public void updateById(String tableName, Map<String, Object> data) {
            ArrayList setValues = new ArrayList();
            data.forEach((key, value) -> setValues.add(Tools.Str.format((String)UPDATE_FIELD_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)key), value instanceof String ? "'" + value + "'" : String.valueOf(value)})));
            this.jdbcTemplate.update(Tools.Str.format((String)UPDATE_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)tableName), Tools.Coll.join(setValues), "id", "'" + data.get("id") + "'"}));
        }

        public PageResult<Map<String, Object>> page(String tableName, Map<String, Object> queryParam) {
            StringBuilder condition = new StringBuilder("1 = 1");
            queryParam.forEach((key, value) -> {
                if (!"page".equals(key) && !"rows".equals(key) && null != value) {
                    condition.append(" and ").append(Tools.Str.toSnakeCase((String)key));
                    if (value instanceof List) {
                        condition.append(" IN(").append(Tools.Coll.join((Collection)Tools.Obj.list((Object)value))).append(")");
                    } else if (value instanceof Number) {
                        condition.append(Tools.Str.format((String)" = {}", (Object[])new Object[]{value}));
                    } else {
                        condition.append(Tools.Str.format((String)" LIKE CONCAT('%{}%')", (Object[])new Object[]{value}));
                    }
                }
            });
            Long count = (Long)this.jdbcTemplate.queryForObject("SELECT COUNT('id') FROM" + Tools.Str.toSnakeCase((String)tableName), Long.class);
            if (null == count) {
                return PageResult.build();
            }
            List queryResult = this.jdbcTemplate.queryForList(Tools.Str.format((String)PAGE_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)tableName), condition.toString(), (Integer)queryParam.get("page") - 1, queryParam.get("rows")}));
            return PageResult.build((long)(count / Integer.toUnsignedLong((Integer)queryParam.get("rows")) + 1L), (long)count, (List)Tools.Coll.traverse((List)queryResult, row -> {
                HashMap newRow = new HashMap();
                row.forEach((key, value) -> newRow.put(Tools.Str.toLowerCamelCase((String)key), value));
                return newRow;
            }));
        }

        public Map<String, Object> getById(String tableName, String id) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map queryResult = this.jdbcTemplate.queryForMap(Tools.Str.format((String)SELECT_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)tableName), "id = '" + id + "'"}));
            queryResult.forEach((key, value) -> result.put(Tools.Str.toLowerCamelCase((String)key), value));
            return result;
        }

        public List<Map<String, Object>> list(String tableName) {
            String formattedSql = Tools.Str.format((String)SELECT_SQL_TEMPLATE, (Object[])new Object[]{Tools.Str.toSnakeCase((String)tableName), "1 = 1"});
            List queryResult = this.jdbcTemplate.queryForList(formattedSql);
            return Tools.Coll.traverse((List)queryResult, row -> {
                HashMap newRow = new HashMap();
                row.forEach((key, value) -> newRow.put(Tools.Str.toLowerCamelCase((String)key), value));
                return newRow;
            });
        }

        public SqlHelper(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
        }
    }
}

