/*
 * Decompiled with CFR 0.152.
 */
package com.ikingtech.platform.service.application.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ikingtech.framework.sdk.application.model.ApplicationCodeGenParamDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationModelApiDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationModelDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationModelFieldDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationModelRelationDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationQueryParamDTO;
import com.ikingtech.framework.sdk.base.model.PageResult;
import com.ikingtech.framework.sdk.context.exception.DownloadException;
import com.ikingtech.framework.sdk.context.exception.FrameworkException;
import com.ikingtech.framework.sdk.context.exception.FrameworkExceptionInfo;
import com.ikingtech.framework.sdk.context.security.Me;
import com.ikingtech.framework.sdk.core.response.R;
import com.ikingtech.framework.sdk.data.mybatisplus.entity.BaseEntity;
import com.ikingtech.framework.sdk.data.mybatisplus.entity.SortEntity;
import com.ikingtech.framework.sdk.datasource.api.DatasourceApi;
import com.ikingtech.framework.sdk.enums.application.ApplicationModelTypeEnum;
import com.ikingtech.framework.sdk.enums.common.JavaFieldTypeEnum;
import com.ikingtech.framework.sdk.enums.common.TableFieldTypeEnum;
import com.ikingtech.framework.sdk.utils.Tools;
import com.ikingtech.framework.sdk.web.annotation.ApiController;
import com.ikingtech.framework.sdk.web.annotation.PostRequest;
import com.ikingtech.platform.service.application.entity.ApplicationModelDO;
import com.ikingtech.platform.service.application.entity.ApplicationModelFieldDO;
import com.ikingtech.platform.service.application.entity.ApplicationModelRelationDO;
import com.ikingtech.platform.service.application.exception.ApplicationExceptionInfo;
import com.ikingtech.platform.service.application.service.generater.ApplicationModelCodeGenerator;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelFieldRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelRelationRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelRepository;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@ApiController(value={"/application/model"}, name="\u5e94\u7528\u4e2d\u5fc3-\u4e1a\u52a1\u6a21\u578b\u7ba1\u7406", description="\u4f4e\u4ee3\u7801\u4e2d\u5fc3-\u4e1a\u52a1\u6a21\u578b\u7ba1\u7406")
public class ApplicationModelController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationModelController.class);
    private final ApplicationModelRepository repo;
    private final ApplicationModelFieldRepository fieldRepo;
    private final ApplicationModelRelationRepository modelRelationRepo;
    private final DatasourceApi datasourceApi;

    @PostRequest(order=1, value={"/add"}, summary="\u6dfb\u52a0\u4e1a\u52a1\u6a21\u578b\u4fe1\u606f", description="\u6dfb\u52a0\u4e1a\u52a1\u6a21\u578b\u4fe1\u606f")
    public R<Object> add(@Parameter(name="model", description="\u4e1a\u52a1\u6a21\u578b\u4fe1\u606f") @RequestBody ApplicationModelDTO model) {
        ApplicationModelDO entity = (ApplicationModelDO)Tools.Bean.copy((Object)model, ApplicationModelDO.class);
        entity.setId(Tools.Id.uuid());
        entity.setType(ApplicationModelTypeEnum.MASTER.name());
        entity.setAppCode(Me.appCode());
        this.insertField(entity.getId(), model.getFields());
        this.insertModelRelation(entity.getId(), model.getSlaveModels());
        this.repo.save(entity);
        return R.ok((Object)entity.getId());
    }

    @PostRequest(order=2, value={"/delete"}, summary="\u5220\u9664\u64cd\u4f5c", description="\u5220\u9664\u64cd\u4f5c")
    public R<Object> delete(@Parameter(name="id", description="\u4e1a\u52a1\u6a21\u578b\u7f16\u53f7") @RequestBody String id) {
        this.repo.removeById((Serializable)((Object)id));
        this.fieldRepo.remove((Wrapper)Wrappers.lambdaQuery().eq(ApplicationModelFieldDO::getModelId, (Object)id));
        this.modelRelationRepo.remove((Wrapper)Wrappers.lambdaQuery().eq(ApplicationModelRelationDO::getMasterModelId, (Object)id));
        this.modelRelationRepo.remove((Wrapper)Wrappers.lambdaQuery().eq(ApplicationModelRelationDO::getModelId, (Object)id));
        return R.ok();
    }

    @PostRequest(order=3, value={"/update"}, summary="\u66f4\u65b0\u4e1a\u52a1\u6a21\u578b\u4fe1\u606f", description="\u66f4\u65b0\u4e1a\u52a1\u6a21\u578b\u4fe1\u606f")
    public R<Object> update(@Parameter(name="model", description="\u4e1a\u52a1\u6a21\u578b\u4fe1\u606f") @RequestBody ApplicationModelDTO model) {
        if (!this.repo.exists((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)model.getId()))) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_NOT_FOUND);
        }
        this.updateField(model.getId(), model.getFields());
        this.updateModelRelation(model.getId(), model.getSlaveModels());
        this.repo.updateById((ApplicationModelDO)Tools.Bean.copy((Object)model, ApplicationModelDO.class));
        return R.ok();
    }

    @PostRequest(order=4, value={"/list/page"}, summary="\u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b\u5217\u8868", description="\u5206\u9875\u67e5\u8be2\u4e1a\u52a1\u6a21\u578b\u5217\u8868")
    public R<List<ApplicationModelDTO>> page(@Parameter(name="queryParam", description="\u67e5\u8be2\u53c2\u6570") @RequestBody ApplicationQueryParamDTO queryParam) {
        return R.ok((PageResult)PageResult.build((Page)((Page)this.repo.page((IPage)new Page((long)queryParam.getPage(), (long)queryParam.getRows()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().like(Tools.Str.isNotBlank((String)queryParam.getName()), ApplicationModelDO::getName, (Object)queryParam.getName())).eq(Tools.Str.isNotBlank((String)queryParam.getStatus()), ApplicationModelDO::getStatus, (Object)queryParam.getStatus())).eq(Tools.Str.isNotBlank((String)Me.appCode()), ApplicationModelDO::getAppCode, (Object)Me.appCode())).orderByDesc(BaseEntity::getCreateTime)))).convertBatch(this::modelConvert));
    }

    @PostRequest(order=5, value={"/list/all"}, summary="\u83b7\u53d6\u6240\u6709\u4e1a\u52a1\u6a21\u578b", description="\u83b7\u53d6\u6240\u6709\u4e1a\u52a1\u6a21\u578b")
    public R<Object> all(@Parameter(name="showSlaveModelField", description="\u67e5\u8be2\u53c2\u6570") @RequestParam(value="showSlaveModelField", required=false) Boolean showSlaveModelField) {
        return R.ok(this.modelConvert(this.repo.list(), showSlaveModelField));
    }

    @PostRequest(order=6, value={"/detail"}, summary="\u83b7\u53d6\u4e1a\u52a1\u6a21\u578b\u8be6\u60c5", description="\u83b7\u53d6\u4e1a\u52a1\u6a21\u578b\u8be6\u60c5")
    public R<ApplicationModelDTO> detail(@Parameter(name="id", description="\u4e1a\u52a1\u6a21\u578b\u7f16\u53f7") @RequestBody String id) {
        ApplicationModelDO entity = (ApplicationModelDO)this.repo.getById((Serializable)((Object)id));
        if (null == entity) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_NOT_FOUND);
        }
        List modelRelationEntities = this.modelRelationRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationModelRelationDO::getMasterModelId, (Object)id));
        List slaveModelEntities = this.repo.listByIds(Tools.Coll.convertList((Collection)modelRelationEntities, ApplicationModelRelationDO::getModelId));
        Map slaveModelMap = Tools.Coll.convertMap((List)slaveModelEntities, BaseEntity::getId);
        return R.ok((Object)this.modelConvert(entity, this.fieldRepo.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ApplicationModelFieldDO::getModelId, (Object)entity.getId())).orderByAsc(SortEntity::getSortOrder)), modelRelationEntities, slaveModelMap));
    }

    @PostRequest(order=7, value={"/field/list/id"}, summary="\u6839\u636e\u4e1a\u52a1\u6a21\u578bID\u83b7\u53d6\u5b57\u6bb5\u5217\u8868", description="\u6839\u636e\u4e1a\u52a1\u6a21\u578bID\u83b7\u53d6\u5b57\u6bb5\u5217\u8868")
    public R<List<ApplicationModelFieldDTO>> listFieldById(@Parameter(name="id", description="\u4e1a\u52a1\u6a21\u578b\u7f16\u53f7") @RequestBody String id) {
        return R.ok(this.fieldModelConvert(this.fieldRepo.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ApplicationModelFieldDO::getModelId, (Object)id)).orderByAsc(SortEntity::getSortOrder))));
    }

    @PostRequest(order=8, value={"/list/datasource-id"}, summary="\u6839\u636e\u6570\u636e\u6e90\u7f16\u53f7\u83b7\u53d6\u5e94\u7528\u6a21\u578b\u5217\u8868", description="\u6839\u636e\u6570\u636e\u6e90\u7f16\u53f7\u83b7\u53d6\u5e94\u7528\u6a21\u578b\u5217\u8868")
    R<List<ApplicationModelDTO>> listByDatasourceId(@Parameter(name="datasourceId", description="\u6570\u636e\u6e90\u7f16\u53f7") @RequestBody String datasourceId) {
        List tables = (List)this.datasourceApi.listTableById(datasourceId).getData();
        return R.ok((Object)Tools.Coll.convertList((Collection)tables, table -> {
            ApplicationModelDTO model = new ApplicationModelDTO();
            model.setName(table.getDescription());
            model.setCode(Tools.Str.toLowerCamelCase((String)table.getName()));
            model.setRemark(table.getDescription());
            model.setFields(Tools.Coll.convertList((List)table.getFields(), tableField -> !"id".equals(tableField.getName()) && !"create_by".equals(tableField.getName()) && !"create_name".equals(tableField.getName()) && !"create_time".equals(tableField.getName()) && !"update_by".equals(tableField.getName()) && !"update_name".equals(tableField.getName()) && !"update_time".equals(tableField.getName()), tableField -> {
                log.info("==================={}", tableField);
                ApplicationModelFieldDTO modelField = new ApplicationModelFieldDTO();
                modelField.setName(Tools.Str.toLowerCamelCase((String)tableField.getName()));
                modelField.setRemark(tableField.getComment());
                modelField.setDbTableField(Boolean.valueOf(true));
                modelField.setDbTableFieldType(TableFieldTypeEnum.valueOfDbType((String)tableField.getType().toLowerCase()));
                modelField.setType(modelField.getDbTableFieldType().javaType);
                modelField.setLength(String.valueOf(tableField.getLength()));
                modelField.setNullable(tableField.getNullable());
                modelField.setSyncWithDatasource(Boolean.valueOf(true));
                return modelField;
            }));
            return model;
        }));
    }

    @PostRequest(order=9, value={"/create-table-sql/preview"}, summary="\u9884\u89c8\u521b\u5efa\u8868\u7684SQL\u8bed\u53e5", description="\u9884\u89c8\u521b\u5efa\u8868\u7684SQL\u8bed\u53e5")
    public R<String> previewCreateTableSql(@Parameter(name="model", description="\u4e1a\u52a1\u6a21\u578b\u4fe1\u606f") @RequestBody ApplicationModelDTO model) {
        if (Tools.Coll.isBlank((Collection)model.getFields())) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_FIELD_NOT_SPECIFIED);
        }
        List dbTableFields = Tools.Coll.filter((Collection)model.getFields(), field -> Boolean.TRUE.equals(field.getDbTableField()));
        if (Tools.Coll.isBlank((Collection)dbTableFields)) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.DB_TABLE_FIELD_NOT_FOUND);
        }
        String createTableSqlTemplate = "CREATE TABLE {} (\n  id char(32) NOT NULL COMMENT '\u4e3b\u952e/\u5c97\u4f4d\u7f16\u53f7',\n{}  create_by char(32) DEFAULT '' COMMENT '\u521b\u5efa\u4eba\u7f16\u53f7',\n  create_name varchar(64) DEFAULT '' COMMENT '\u521b\u5efa\u4eba\u59d3\u540d',\n  create_time datetime DEFAULT NULL COMMENT '\u521b\u5efa\u65f6\u95f4',\n  update_by char(32) DEFAULT '' COMMENT '\u66f4\u65b0\u4eba\u7f16\u53f7',\n  update_name varchar(64) DEFAULT '' COMMENT '\u66f4\u65b0\u4eba\u59d3\u540d',\n  update_time datetime DEFAULT NULL COMMENT '\u66f4\u65b0\u65f6\u95f4',\n  PRIMARY KEY (id)\n) COMMENT='{}';";
        StringBuilder fieldSql = new StringBuilder();
        model.getFields().forEach(field -> fieldSql.append(field.getDbTableFieldType().sqlFormat(Tools.Str.toSnakeCase((String)field.getName()), field.getLength(), field.getRemark())));
        return R.ok((Object)Tools.Str.format((String)createTableSqlTemplate, (Object[])new Object[]{model.getCode(), fieldSql.toString(), model.getRemark()}));
    }

    @PostRequest(order=10, value={"/code/gen"}, summary="\u751f\u6210\u4ee3\u7801", description="\u751f\u6210\u4ee3\u7801")
    public void generateCode(@Parameter(name="id", description="\u6a21\u578b\u7f16\u53f7") @RequestBody ApplicationCodeGenParamDTO genParam, HttpServletResponse response) {
        ServletOutputStream outputStream;
        try {
            outputStream = response.getOutputStream();
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6response\u8f93\u51fa\u6d41\u5931\u8d25[{}]", (Object)e.getMessage());
            throw new DownloadException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_CODE_GEN_FAIL);
        }
        List entities = this.repo.listByIds(genParam.getModelIds());
        if (Tools.Coll.isBlank((Collection)entities)) {
            throw new DownloadException((FrameworkExceptionInfo)ApplicationExceptionInfo.MODEL_NOT_FOUND);
        }
        response.setContentType("application/octet-stream; charset=UTF-8");
        response.setHeader("Content-Disposition", Tools.Str.format((String)"attachment; filename={}", (Object[])new Object[]{"code_gen.zip"}));
        Map<String, String> codes = new ApplicationModelCodeGenerator(this.repo, this.fieldRepo, this.modelRelationRepo).generate("", genParam.getPackageName(), entities);
        Tools.Zip zipInstance = Tools.Zip.instance();
        codes.forEach((arg_0, arg_1) -> ((Tools.Zip)zipInstance).entry(arg_0, arg_1));
        zipInstance.write((OutputStream)outputStream);
    }

    private void insertModelRelation(String modelId, List<ApplicationModelRelationDTO> modelRelations) {
        this.modelRelationRepo.saveBatch(Tools.Coll.convertList(modelRelations, modelRelation -> {
            ApplicationModelRelationDO entity = (ApplicationModelRelationDO)Tools.Bean.copy((Object)modelRelation, ApplicationModelRelationDO.class);
            entity.setId(Tools.Id.uuid());
            entity.setMasterModelId(modelId);
            return entity;
        }));
    }

    private void insertField(String modelId, List<ApplicationModelFieldDTO> fields) {
        if (Tools.Coll.isNotBlank(fields)) {
            List entities = Tools.Coll.convertList(fields, field -> {
                ApplicationModelFieldDO entity = (ApplicationModelFieldDO)Tools.Bean.copy((Object)field, ApplicationModelFieldDO.class);
                entity.setId(Tools.Id.uuid());
                entity.setModelId(modelId);
                return entity;
            });
            this.fieldRepo.saveBatch(entities);
        }
    }

    private void updateModelRelation(String modelId, List<ApplicationModelRelationDTO> fields) {
        this.modelRelationRepo.remove((Wrapper)Wrappers.lambdaQuery().eq(ApplicationModelRelationDO::getMasterModelId, (Object)modelId));
        this.insertModelRelation(modelId, fields);
    }

    private void updateField(String modelId, List<ApplicationModelFieldDTO> fields) {
        this.fieldRepo.remove((Wrapper)Wrappers.lambdaQuery().eq(ApplicationModelFieldDO::getModelId, (Object)modelId));
        this.insertField(modelId, fields);
    }

    public List<ApplicationModelDTO> modelConvert(List<ApplicationModelDO> entities) {
        return this.modelConvert(entities, false);
    }

    public List<ApplicationModelDTO> modelConvert(List<ApplicationModelDO> entities, Boolean showSlaveModelField) {
        if (Tools.Coll.isBlank(entities)) {
            return new ArrayList<ApplicationModelDTO>();
        }
        List modelIds = Tools.Coll.convertList(entities, BaseEntity::getId);
        List fieldEntities = this.fieldRepo.list((Wrapper)Wrappers.lambdaQuery().in(ApplicationModelFieldDO::getModelId, (Collection)modelIds));
        Map fieldMap = Tools.Coll.convertGroup((List)fieldEntities, ApplicationModelFieldDO::getModelId);
        List modelRelationEntities = this.modelRelationRepo.list((Wrapper)Wrappers.lambdaQuery().in(ApplicationModelRelationDO::getMasterModelId, (Collection)modelIds));
        Map modelRelationMap = Tools.Coll.convertGroup((List)modelRelationEntities, ApplicationModelRelationDO::getMasterModelId);
        if (Boolean.TRUE.equals(showSlaveModelField)) {
            Map modelMap = Tools.Coll.convertMap(entities, BaseEntity::getId);
            modelRelationMap.forEach((masterModelId, relationEntities) -> ((List)fieldMap.get(masterModelId)).addAll(Tools.Coll.convertList((Collection)relationEntities, relationEntity -> {
                ApplicationModelFieldDO field = new ApplicationModelFieldDO();
                field.setId(Tools.Id.uuid());
                field.setModelId((String)masterModelId);
                field.setType(JavaFieldTypeEnum.LIST.name());
                field.setName(((ApplicationModelDO)modelMap.get(relationEntity.getModelId())).getCode() + "List");
                return field;
            })));
        }
        ArrayList slaveModelEntities = Tools.Coll.isBlank((Collection)modelRelationEntities) ? new ArrayList() : this.repo.listByIds(Tools.Coll.convertList((Collection)modelRelationEntities, ApplicationModelRelationDO::getModelId));
        Map slaveModelMap = Tools.Coll.convertMap(slaveModelEntities, BaseEntity::getId);
        return Tools.Coll.convertList(entities, entity -> this.modelConvert((ApplicationModelDO)entity, (List)fieldMap.get(entity.getId()), (List)modelRelationMap.get(entity.getId()), slaveModelMap));
    }

    public ApplicationModelDTO modelConvert(ApplicationModelDO entity, List<ApplicationModelFieldDO> fieldEntities, List<ApplicationModelRelationDO> modelRelationEntities, Map<String, ApplicationModelDO> slaveModelMap) {
        ApplicationModelDTO model = (ApplicationModelDTO)Tools.Bean.copy((Object)entity, ApplicationModelDTO.class);
        if (null != model.getStatus()) {
            model.setStatusName(model.getStatus().description);
        }
        model.setFields(this.fieldModelConvert(fieldEntities));
        model.setApis(Tools.Coll.newList((Supplier[])new Supplier[]{() -> {
            ApplicationModelApiDTO api = new ApplicationModelApiDTO();
            api.setUri("/" + entity.getCode() + "/add");
            api.setName("\u65b0\u589e");
            return api;
        }, () -> {
            ApplicationModelApiDTO api = new ApplicationModelApiDTO();
            api.setUri("/" + entity.getCode() + "/delete");
            api.setName("\u5220\u9664");
            return api;
        }, () -> {
            ApplicationModelApiDTO api = new ApplicationModelApiDTO();
            api.setUri("/" + entity.getCode() + "/update");
            api.setName("\u66f4\u65b0");
            return api;
        }, () -> {
            ApplicationModelApiDTO api = new ApplicationModelApiDTO();
            api.setUri("/" + entity.getCode() + "/list/page");
            api.setName("\u5206\u9875\u67e5\u8be2");
            return api;
        }, () -> {
            ApplicationModelApiDTO api = new ApplicationModelApiDTO();
            api.setUri("/" + entity.getCode() + "/list/all");
            api.setName("\u5168\u91cf\u67e5\u8be2");
            return api;
        }}));
        model.setSlaveModels(Tools.Coll.convertList(modelRelationEntities, modelRelationEntity -> {
            ApplicationModelRelationDTO modelRelation = (ApplicationModelRelationDTO)Tools.Bean.copy((Object)modelRelationEntity, ApplicationModelRelationDTO.class);
            modelRelation.setModelName(((ApplicationModelDO)slaveModelMap.get(modelRelation.getModelId())).getName());
            return modelRelation;
        }));
        return model;
    }

    public List<ApplicationModelFieldDTO> fieldModelConvert(List<ApplicationModelFieldDO> entities) {
        return Tools.Coll.convertList(entities, fieldEntity -> {
            ApplicationModelFieldDTO field = (ApplicationModelFieldDTO)Tools.Bean.copy((Object)fieldEntity, ApplicationModelFieldDTO.class);
            if (null != field.getType()) {
                field.setTypeName(field.getType().description);
            }
            if (null != field.getDbTableFieldType()) {
                field.setTypeName(field.getDbTableFieldType().description);
            }
            if (null != field.getCompareType()) {
                field.setCompareTypeName(field.getCompareType().description);
            }
            return field;
        });
    }

    public ApplicationModelController(ApplicationModelRepository repo, ApplicationModelFieldRepository fieldRepo, ApplicationModelRelationRepository modelRelationRepo, DatasourceApi datasourceApi) {
        this.repo = repo;
        this.fieldRepo = fieldRepo;
        this.modelRelationRepo = modelRelationRepo;
        this.datasourceApi = datasourceApi;
    }
}

