/*
 * Decompiled with CFR 0.152.
 */
package com.ikingtech.platform.service.application.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ikingtech.framework.sdk.application.api.ApplicationMenuApi;
import com.ikingtech.framework.sdk.application.api.ApplicationPageApi;
import com.ikingtech.framework.sdk.application.model.ApplicationPageDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationPageModelDTO;
import com.ikingtech.framework.sdk.application.model.ApplicationPageQueryParamDTO;
import com.ikingtech.framework.sdk.base.model.PageResult;
import com.ikingtech.framework.sdk.context.exception.FrameworkException;
import com.ikingtech.framework.sdk.context.exception.FrameworkExceptionInfo;
import com.ikingtech.framework.sdk.context.security.Me;
import com.ikingtech.framework.sdk.core.response.R;
import com.ikingtech.framework.sdk.data.mybatisplus.entity.BaseEntity;
import com.ikingtech.framework.sdk.data.mybatisplus.entity.SortEntity;
import com.ikingtech.framework.sdk.enums.application.ApplicationPageCategoryEnum;
import com.ikingtech.framework.sdk.enums.application.ApplicationPageTypeEnum;
import com.ikingtech.framework.sdk.enums.domain.DomainEnum;
import com.ikingtech.framework.sdk.utils.Tools;
import com.ikingtech.framework.sdk.web.annotation.ApiController;
import com.ikingtech.platform.service.application.entity.ApplicationDO;
import com.ikingtech.platform.service.application.entity.ApplicationPageDO;
import com.ikingtech.platform.service.application.entity.ApplicationPageModelDO;
import com.ikingtech.platform.service.application.exception.ApplicationExceptionInfo;
import com.ikingtech.platform.service.application.service.repository.ApplicationPageModelRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationPageRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationRepository;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@ApiController(value={"/application/page"}, name="\u5e94\u7528\u4e2d\u5fc3-\u9875\u9762\u7ba1\u7406", description="\u5e94\u7528\u4e2d\u5fc3-\u9875\u9762\u7ba1\u7406")
public class ApplicationPageController
implements ApplicationPageApi {
    private static final Logger log = LoggerFactory.getLogger(ApplicationPageController.class);
    private final ApplicationPageRepository repo;
    private final ApplicationRepository applicationRepo;
    private final ApplicationPageModelRepository pageModelRepo;
    private final ApplicationMenuApi applicationMenuApi;

    @Transactional(rollbackFor={Exception.class})
    public R<ApplicationPageDTO> add(ApplicationPageDTO page) {
        ApplicationDO applicationEntity;
        ApplicationPageDO entity = (ApplicationPageDO)Tools.Bean.copy((Object)page, ApplicationPageDO.class);
        entity.setId(Tools.Id.uuid());
        entity.setSortOrder(this.getMaxSortOrder(entity.getParentId()));
        entity.setCategory(ApplicationPageCategoryEnum.GENERAL.name());
        if (ApplicationPageTypeEnum.GROUP.name().equals(entity.getType())) {
            entity.setLink(Tools.Str.format((String)"/{}", (Object[])new Object[]{entity.getId()}));
        }
        if (ApplicationPageTypeEnum.NORMAL.name().equals(entity.getType()) || ApplicationPageTypeEnum.CUSTOMIZE.name().equals(entity.getType())) {
            entity.setLink(Tools.Str.format((String)"/vpage-render/{}", (Object[])new Object[]{entity.getId()}));
            entity.setComponent("auto-rander/index.vue");
        }
        if (!ApplicationPageTypeEnum.GROUP.name().equals(entity.getType()) && !this.repo.exists((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ApplicationPageDO::getAppCode, (Object)page.getAppCode())).ne(ApplicationPageDO::getType, (Object)ApplicationPageTypeEnum.GROUP.name())) && null != (applicationEntity = (ApplicationDO)this.applicationRepo.getOne((Wrapper)Wrappers.lambdaQuery().eq(ApplicationDO::getCode, (Object)page.getAppCode())))) {
            applicationEntity.setIndexPath(entity.getLink());
            this.applicationRepo.updateById(applicationEntity);
        }
        this.repo.save(entity);
        this.insertPageModel(entity.getId(), page.getModelIds());
        this.applicationMenuApi.saveOrUpdate(entity.getId(), entity.getName(), entity.getParentId(), entity.getIcon(), entity.getLink(), entity.getComponent(), entity.getSortOrder(), "APP_PREVIEW", entity.getAppCode());
        return R.ok((Object)this.modelConvert(entity));
    }

    public R<Object> delete(String id) {
        boolean updateApplicationIndexPath;
        ApplicationPageDO entity = (ApplicationPageDO)this.repo.getById((Serializable)((Object)id));
        if (null == entity) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.PAGE_NOT_FOUND);
        }
        ApplicationDO applicationEntity = (ApplicationDO)this.applicationRepo.getOne((Wrapper)Wrappers.lambdaQuery().eq(ApplicationDO::getCode, (Object)entity.getAppCode()));
        if (ApplicationPageTypeEnum.GROUP.name().equals(entity.getType())) {
            List subPageEntities = this.repo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageDO::getParentId, (Object)entity.getId()));
            List ids = Tools.Coll.convertList((Collection)subPageEntities, BaseEntity::getId);
            ids.add(entity.getId());
            this.repo.removeBatchByIds(ids);
            this.applicationMenuApi.removeByPermissionCodes(ids, "APP_PREVIEW", entity.getAppCode());
            updateApplicationIndexPath = Tools.Coll.contains((List)subPageEntities, ApplicationPageDO::getLink, (Object)applicationEntity.getIndexPath());
        } else {
            this.repo.removeById((Serializable)((Object)id));
            this.applicationMenuApi.removeByPermissionCode(id, "APP_PREVIEW", entity.getAppCode());
            updateApplicationIndexPath = entity.getLink().equals(applicationEntity.getIndexPath());
        }
        if (updateApplicationIndexPath) {
            List remainedPageEntities = this.repo.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ApplicationPageDO::getParentId, (Object)"")).ne(BaseEntity::getId, (Object)entity.getId())).orderByAsc(SortEntity::getSortOrder));
            String newIndexPath = "";
            if (Tools.Coll.isNotBlank((Collection)remainedPageEntities)) {
                ApplicationPageDO firstRemainedPageEntity = (ApplicationPageDO)remainedPageEntities.get(0);
                if (ApplicationPageTypeEnum.GROUP.name().equals(firstRemainedPageEntity.getType())) {
                    List subPageEntities = this.repo.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ApplicationPageDO::getParentId, (Object)firstRemainedPageEntity.getId())).ne(BaseEntity::getId, (Object)entity.getId())).orderByAsc(SortEntity::getSortOrder));
                    if (Tools.Coll.isNotBlank((Collection)subPageEntities)) {
                        newIndexPath = ((ApplicationPageDO)subPageEntities.get(0)).getLink();
                    }
                } else {
                    newIndexPath = firstRemainedPageEntity.getLink();
                }
            }
            applicationEntity.setIndexPath(newIndexPath);
            this.applicationRepo.updateById(applicationEntity);
        }
        return R.ok();
    }

    public R<Object> update(ApplicationPageDTO page) {
        if (!this.repo.exists((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getId, (Object)page.getId()))) {
            throw new FrameworkException("appPageNotFound");
        }
        ApplicationPageDO entity = (ApplicationPageDO)Tools.Bean.copy((Object)page, ApplicationPageDO.class);
        this.repo.updateById(entity);
        this.updatePageModel(entity.getId(), page.getModelIds());
        this.applicationMenuApi.saveOrUpdate(entity.getId(), entity.getName(), entity.getParentId(), entity.getIcon(), entity.getLink(), entity.getComponent(), entity.getSortOrder(), "APP_PREVIEW", entity.getAppCode());
        return R.ok((Object)this.modelConvert(entity));
    }

    public R<List<ApplicationPageDTO>> page(ApplicationPageQueryParamDTO queryParam) {
        return R.ok((PageResult)PageResult.build((Page)((Page)this.repo.page((IPage)new Page((long)queryParam.getPage(), (long)queryParam.getRows()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Tools.Str.isNotBlank((String)queryParam.getAppCode()), ApplicationPageDO::getAppCode, (Object)queryParam.getAppCode())).like(Tools.Str.isNotBlank((String)queryParam.getName()), ApplicationPageDO::getName, (Object)queryParam.getName())).eq(Tools.Str.isNotBlank((String)queryParam.getType()), ApplicationPageDO::getType, (Object)queryParam.getType())))).convertBatch(this::modelConvert));
    }

    public R<List<ApplicationPageDTO>> all() {
        return R.ok(this.modelConvert(this.repo.list()));
    }

    public R<ApplicationPageDTO> detail(String id) {
        ApplicationPageDO entity = (ApplicationPageDO)this.repo.getById((Serializable)((Object)id));
        if (null == entity) {
            throw new FrameworkException((FrameworkExceptionInfo)ApplicationExceptionInfo.PAGE_NOT_FOUND);
        }
        return R.ok((Object)this.modelConvert(entity));
    }

    public R<List<ApplicationPageDTO>> listByAppCode(String appCode) {
        return R.ok(this.modelConvert(this.repo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageDO::getAppCode, (Object)appCode))));
    }

    private void insertPageModel(String pageId, List<String> modelIds) {
        if (Tools.Coll.isNotBlank(modelIds)) {
            this.pageModelRepo.saveBatch(Tools.Coll.convertList(modelIds, modelId -> {
                ApplicationPageModelDO pageModeEntity = new ApplicationPageModelDO();
                pageModeEntity.setId(Tools.Id.uuid());
                pageModeEntity.setPageId(pageId);
                pageModeEntity.setModelId((String)modelId);
                return pageModeEntity;
            }));
        }
    }

    private void updatePageModel(String pageId, List<String> modelIds) {
        this.pageModelRepo.remove((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)pageId));
        this.insertPageModel(pageId, modelIds);
    }

    private List<ApplicationPageDTO> modelConvert(List<ApplicationPageDO> entities) {
        return Tools.Coll.convertList(entities, this::modelConvert);
    }

    private ApplicationPageDTO modelConvert(ApplicationPageDO entity) {
        ApplicationPageDTO page = (ApplicationPageDTO)Tools.Bean.copy((Object)entity, ApplicationPageDTO.class);
        if (null != page.getType()) {
            page.setTypeName(page.getType().description);
        }
        if (DomainEnum.TENANT.name().equals(Me.domainCode())) {
            page.setJson(entity.getRenderJson());
        }
        List pageModelEntities = this.pageModelRepo.list((Wrapper)Wrappers.lambdaQuery().eq(ApplicationPageModelDO::getPageId, (Object)page.getId()));
        page.setModelIds(Tools.Coll.convertList((Collection)pageModelEntities, ApplicationPageModelDO::getModelId));
        page.setModels(Tools.Coll.convertList((Collection)pageModelEntities, pageModelEntity -> (ApplicationPageModelDTO)Tools.Bean.copy((Object)pageModelEntity, ApplicationPageModelDTO.class)));
        return page;
    }

    private Integer getMaxSortOrder(String parentId) {
        List orders = this.repo.listObjs((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{SortEntity::getSortOrder}).eq(ApplicationPageDO::getParentId, (Object)parentId)).orderByDesc(SortEntity::getSortOrder), Number.class::cast);
        return Tools.Coll.isBlank((Collection)orders) ? 0 : ((Number)orders.get(0)).intValue();
    }

    public ApplicationPageController(ApplicationPageRepository repo, ApplicationRepository applicationRepo, ApplicationPageModelRepository pageModelRepo, ApplicationMenuApi applicationMenuApi) {
        this.repo = repo;
        this.applicationRepo = applicationRepo;
        this.pageModelRepo = pageModelRepo;
        this.applicationMenuApi = applicationMenuApi;
    }
}

