/*
 * Decompiled with CFR 0.152.
 */
package com.ikingtech.platform.service.application.service.generater;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ikingtech.framework.sdk.application.model.code.ApplicationFieldParam;
import com.ikingtech.framework.sdk.application.model.code.ApplicationModelCodeGenParam;
import com.ikingtech.framework.sdk.context.security.Me;
import com.ikingtech.framework.sdk.data.mybatisplus.entity.BaseEntity;
import com.ikingtech.framework.sdk.enums.common.JavaFieldTypeEnum;
import com.ikingtech.framework.sdk.enums.common.TableFieldTypeEnum;
import com.ikingtech.framework.sdk.enums.scffold.ScaffoldQueryCompareTypeEnum;
import com.ikingtech.framework.sdk.utils.Tools;
import com.ikingtech.platform.service.application.entity.ApplicationModelDO;
import com.ikingtech.platform.service.application.entity.ApplicationModelFieldDO;
import com.ikingtech.platform.service.application.entity.ApplicationModelRelationDO;
import com.ikingtech.platform.service.application.service.generater.ApplicationCodeGenerator;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelFieldRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelRelationRepository;
import com.ikingtech.platform.service.application.service.repository.ApplicationModelRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public abstract class AbstractCodeGenerator
implements ApplicationCodeGenerator {
    private final ApplicationModelRepository modelService;
    private final ApplicationModelFieldRepository fieldService;
    private final ApplicationModelRelationRepository modelRelationService;

    protected Boolean relateToApprove() {
        return false;
    }

    protected String initiateFormModelId() {
        return "";
    }

    protected String approveBusinessType() {
        return "";
    }

    @Override
    public Map<String, String> generate(String basePath, String packageName, List<ApplicationModelDO> entities) {
        HashMap<String, String> result = new HashMap<String, String>();
        List modelIds = Tools.Coll.convertList(entities, BaseEntity::getId);
        List modelRelationEntities = this.modelRelationService.list((Wrapper)Wrappers.lambdaQuery().in(ApplicationModelRelationDO::getMasterModelId, (Collection)modelIds));
        modelIds.addAll(Tools.Coll.convertList((Collection)modelRelationEntities, ApplicationModelRelationDO::getModelId));
        Map modelRelationMap = Tools.Coll.convertGroup((List)modelRelationEntities, ApplicationModelRelationDO::getMasterModelId);
        Map modelMap = Tools.Coll.convertMap(entities, BaseEntity::getId);
        if (Tools.Coll.isNotBlank((Collection)modelRelationEntities)) {
            modelMap.putAll(Tools.Coll.convertMap((List)this.modelService.listByIds(Tools.Coll.convertList((Collection)modelRelationEntities, ApplicationModelRelationDO::getModelId)), BaseEntity::getId));
        }
        List fieldEntities = this.fieldService.list((Wrapper)Wrappers.lambdaQuery().in(ApplicationModelFieldDO::getModelId, (Collection)modelIds));
        Map fieldMap = Tools.Coll.convertMap((List)fieldEntities, BaseEntity::getId);
        Map modelFieldMap = Tools.Coll.convertGroup((List)fieldEntities, ApplicationModelFieldDO::getModelId);
        for (ApplicationModelDO entity : entities) {
            List currentModelFieldEntities = (List)modelFieldMap.get(entity.getId());
            String modelPackageName = packageName + "." + Tools.Str.toDotSeparate((String)entity.getCode());
            ApplicationModelCodeGenParam codeGenParam = this.createCodeGenParam(modelPackageName, entity, currentModelFieldEntities);
            codeGenParam.setGroupId(packageName);
            codeGenParam.setArtifactId(Tools.Str.toHyphenSeparate((String)entity.getCode()));
            codeGenParam.setQueryFields(Tools.Coll.convertList((List)currentModelFieldEntities, fieldEntity -> Boolean.TRUE.equals(fieldEntity.getQueryField()), this::createQueryField));
            if (Boolean.TRUE.equals(this.relateToApprove()) && entity.getId().equals(this.initiateFormModelId())) {
                codeGenParam.setRelateToApprove(Boolean.valueOf(true));
                codeGenParam.setApproveBusinessType(this.approveBusinessType());
            }
            List currentModelRelationEntities = (List)modelRelationMap.get(entity.getId());
            String rootPath = basePath + "/" + entity.getCode();
            String srcPath = rootPath + "/src/main";
            String packagePath = srcPath + "/java/" + codeGenParam.getPackageName().replace(".", "/");
            if (Tools.Coll.isNotBlank((Collection)currentModelRelationEntities)) {
                for (ApplicationModelRelationDO modelRelationEntity : currentModelRelationEntities) {
                    List slaveModelFieldEntities = (List)modelFieldMap.get(modelRelationEntity.getModelId());
                    ApplicationModelDO slaveModelEntity = (ApplicationModelDO)modelMap.get(modelRelationEntity.getModelId());
                    ApplicationModelCodeGenParam slaveModelCodeGenParam = this.createCodeGenParam(modelPackageName, slaveModelEntity, slaveModelFieldEntities);
                    slaveModelCodeGenParam.setMasterModelCode(entity.getCode());
                    slaveModelCodeGenParam.setUpperCamelMasterModelCode(Tools.Str.toUpperCamelCaseWithoutSeparate((String)slaveModelCodeGenParam.getMasterModelCode()));
                    slaveModelCodeGenParam.setSlaveModel(Boolean.valueOf(true));
                    slaveModelCodeGenParam.setQueryFields(Tools.Coll.convertList((List)slaveModelFieldEntities, slaveModelFieldEntity -> Boolean.TRUE.equals(slaveModelFieldEntity.getQueryField()), slaveModelFieldEntity -> this.createQueryField(slaveModelFieldEntity.getName(), Tools.Str.format((String)"{}{}", (Object[])new Object[]{slaveModelEntity.getCode(), Tools.Str.toUpperCamelCaseWithoutSeparate((String)slaveModelFieldEntity.getName())}), JavaFieldTypeEnum.valueOf((String)slaveModelFieldEntity.getType()), ScaffoldQueryCompareTypeEnum.valueOf((String)slaveModelFieldEntity.getCompareType()), slaveModelFieldEntity.getRemark())));
                    slaveModelCodeGenParam.setQueryExecuteCondition(Tools.Str.join((List)Tools.Coll.convertList((Collection)slaveModelCodeGenParam.getQueryFields(), ApplicationFieldParam::getCondition), (String)"||\n\t\t\t\t"));
                    slaveModelCodeGenParam.setForeignKeyFieldName(((ApplicationModelFieldDO)fieldMap.get(modelRelationEntity.getForeignKeyFieldId())).getName());
                    slaveModelCodeGenParam.setUpperCamelForeignKeyFieldName(Tools.Str.toUpperCamelCaseWithoutSeparate((String)slaveModelCodeGenParam.getForeignKeyFieldName()));
                    ApplicationFieldParam slaveFieldParam = this.createModelField(slaveModelEntity.getCode() + "List", JavaFieldTypeEnum.LIST, JavaFieldTypeEnum.MODEL, slaveModelEntity.getRemark(), slaveModelEntity.getCode());
                    slaveFieldParam.setRelateModel(slaveModelCodeGenParam);
                    codeGenParam.getSlaveFields().add(slaveFieldParam);
                    Tools.Velocity velocity = Tools.Velocity.instance().context("param", (Object)slaveModelCodeGenParam);
                    result.put(packagePath + "/service/" + slaveModelCodeGenParam.getUpperCamelModelCode() + "Service.java", velocity.generate("template/Service.java.vm"));
                    result.put(packagePath + "/model/" + slaveModelCodeGenParam.getUpperCamelModelCode() + "DTO.java", velocity.generate("template/Model.java.vm"));
                    result.put(packagePath + "/entity/" + slaveModelCodeGenParam.getUpperCamelModelCode() + "DO.java", velocity.generate("template/Entity.java.vm"));
                    result.put(packagePath + "/mapper/" + slaveModelCodeGenParam.getUpperCamelModelCode() + "Mapper.java", velocity.generate("template/Mapper.java.vm"));
                }
            }
            Tools.Velocity velocity = Tools.Velocity.instance().context("param", (Object)codeGenParam);
            result.put(packagePath + "/controller/" + codeGenParam.getUpperCamelModelCode() + "Controller.java", velocity.generate("template/Controller.java.vm"));
            result.put(packagePath + "/service/" + codeGenParam.getUpperCamelModelCode() + "Service.java", velocity.generate("template/Service.java.vm"));
            result.put(packagePath + "/model/" + codeGenParam.getUpperCamelModelCode() + "DTO.java", velocity.generate("template/Model.java.vm"));
            result.put(packagePath + "/model/" + codeGenParam.getUpperCamelModelCode() + "QueryParamDTO.java", velocity.generate("template/QueryParam.java.vm"));
            result.put(packagePath + "/entity/" + codeGenParam.getUpperCamelModelCode() + "DO.java", velocity.generate("template/Entity.java.vm"));
            result.put(packagePath + "/mapper/" + codeGenParam.getUpperCamelModelCode() + "Mapper.java", velocity.generate("template/Mapper.java.vm"));
            result.put(rootPath + "/pom.xml", velocity.generate("template/ModulePom.xml.vm"));
        }
        return result;
    }

    private ApplicationModelCodeGenParam createCodeGenParam(String packageName, ApplicationModelDO entity, List<ApplicationModelFieldDO> fieldEntities) {
        ApplicationModelCodeGenParam codeGenParam = new ApplicationModelCodeGenParam();
        codeGenParam.setPackageName(packageName);
        codeGenParam.setModelName(entity.getName());
        codeGenParam.setModelCode(entity.getCode());
        codeGenParam.setHyphenModelCode(Tools.Str.toHyphenSeparate((String)entity.getCode()));
        codeGenParam.setUpperCamelModelCode(Tools.Str.toUpperCamelCaseWithoutSeparate((String)entity.getCode()));
        codeGenParam.setSnakeCaseModelCode(Tools.Str.toHyphenSeparate((String)entity.getCode()));
        codeGenParam.setAuthor(Me.name());
        codeGenParam.setDbTableSerialVersionUid(String.valueOf(ThreadLocalRandom.current().nextLong()));
        codeGenParam.setModelSerialVersionUid(String.valueOf(ThreadLocalRandom.current().nextLong()));
        codeGenParam.setQueryParamSerialVersionUid(String.valueOf(ThreadLocalRandom.current().nextLong()));
        codeGenParam.setDbTableFields(Tools.Coll.convertList(fieldEntities, fieldEntity -> Boolean.TRUE.equals(fieldEntity.getDbTableField()), this::createDbField));
        codeGenParam.setModelFields(Tools.Coll.convertList(fieldEntities, this::createModelField));
        codeGenParam.setQueryFields(new ArrayList());
        codeGenParam.setSlaveFields(new ArrayList());
        return codeGenParam;
    }

    private ApplicationFieldParam createModelField(ApplicationModelFieldDO fieldEntity) {
        return this.createModelField(fieldEntity.getName(), JavaFieldTypeEnum.valueOf((String)fieldEntity.getType()), Tools.Str.isBlank((String)fieldEntity.getGenericType()) ? null : JavaFieldTypeEnum.valueOf((String)fieldEntity.getGenericType()), fieldEntity.getRemark(), "");
    }

    private ApplicationFieldParam createModelField(String fieldName, JavaFieldTypeEnum type, JavaFieldTypeEnum genericType, String remark, String slaveModelCode) {
        ApplicationFieldParam fieldParam = new ApplicationFieldParam();
        fieldParam.setName(fieldName);
        fieldParam.setUpperCamelName(Tools.Str.toUpperCamelCaseWithoutSeparate((String)fieldParam.getName()));
        if (JavaFieldTypeEnum.LIST.equals((Object)type)) {
            if (JavaFieldTypeEnum.MODEL.equals((Object)genericType)) {
                fieldParam.setModifier(Tools.Str.format((String)type.modifier, (Object[])new Object[]{Tools.Str.toUpperCamelCaseWithoutSeparate((String)slaveModelCode) + "DTO"}));
            } else {
                fieldParam.setModifier(Tools.Str.format((String)type.modifier, (Object[])new Object[]{genericType.modifier}));
            }
        } else {
            fieldParam.setModifier(type.modifier);
        }
        fieldParam.setRemark(remark);
        return fieldParam;
    }

    private ApplicationFieldParam createDbField(ApplicationModelFieldDO fieldEntity) {
        ApplicationFieldParam fieldParam = new ApplicationFieldParam();
        fieldParam.setName(fieldEntity.getName());
        fieldParam.setUpperCamelName(Tools.Str.toUpperCamelCaseWithoutSeparate((String)fieldEntity.getName()));
        fieldParam.setSnakeCaseName(Tools.Str.toSnakeCase((String)fieldEntity.getName()));
        fieldParam.setModifier(TableFieldTypeEnum.valueOf((String)fieldEntity.getDbTableFieldType()).javaType.modifier);
        return fieldParam;
    }

    private ApplicationFieldParam createQueryField(ApplicationModelFieldDO fieldEntity) {
        return this.createQueryField(fieldEntity.getName(), fieldEntity.getName(), JavaFieldTypeEnum.valueOf((String)fieldEntity.getType()), ScaffoldQueryCompareTypeEnum.valueOf((String)fieldEntity.getCompareType()), fieldEntity.getRemark());
    }

    private ApplicationFieldParam createQueryField(String name, String queryName, JavaFieldTypeEnum type, ScaffoldQueryCompareTypeEnum compareType, String remark) {
        ApplicationFieldParam fieldParam = new ApplicationFieldParam();
        fieldParam.setName(name);
        fieldParam.setUpperCamelName(Tools.Str.toUpperCamelCaseWithoutSeparate((String)fieldParam.getName()));
        fieldParam.setQueryName(queryName);
        fieldParam.setUpperCamelQueryName(Tools.Str.toUpperCamelCaseWithoutSeparate((String)fieldParam.getQueryName()));
        fieldParam.setModifier(type.modifier);
        fieldParam.setRemark(remark);
        fieldParam.setCompareType(compareType.expression);
        fieldParam.setCondition(Tools.Str.format((String)type.checkNull, (Object[])new Object[]{"queryParam.get" + fieldParam.getUpperCamelQueryName() + "()"}));
        return fieldParam;
    }

    public AbstractCodeGenerator(ApplicationModelRepository modelService, ApplicationModelFieldRepository fieldService, ApplicationModelRelationRepository modelRelationService) {
        this.modelService = modelService;
        this.fieldService = fieldService;
        this.modelRelationService = modelRelationService;
    }
}

