/*
 * Decompiled with CFR 0.152.
 */
package com.imadcn.framework.idworker.spring.schema.parser;

import com.imadcn.framework.idworker.generator.CompressUUIDGenerator;
import com.imadcn.framework.idworker.generator.SnowflakeGenerator;
import com.imadcn.framework.idworker.spring.schema.parser.BaseBeanDefinitionParser;
import com.imadcn.framework.idworker.spring.schema.parser.GeneratorRegisteryBuilder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class GeneratorBeanDefinitionParser
extends BaseBeanDefinitionParser {
    private String generatorType;

    public GeneratorBeanDefinitionParser(String generatorType) {
        this.generatorType = generatorType;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Class generatorClass = null;
        if ("snowflake".equals(this.generatorType)) {
            generatorClass = SnowflakeGenerator.class;
        } else if ("compress-uuid".equals(this.generatorType)) {
            generatorClass = CompressUUIDGenerator.class;
        } else {
            throw new IllegalArgumentException("unknown registryType");
        }
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(generatorClass);
        if (generatorClass.isAssignableFrom(SnowflakeGenerator.class)) {
            result.addConstructorArgValue((Object)GeneratorRegisteryBuilder.buildWorkerNodeRegisterBeanDefinition(element, parserContext));
            result.setInitMethodName("init");
        }
        return result.getBeanDefinition();
    }
}

