/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common;

import com.indeed.proctor.common.LegacyTaglibFunctions;
import com.indeed.proctor.common.ProctorRuleFunctions;
import com.indeed.proctor.common.ProctorUtils;
import com.indeed.proctor.common.el.LibraryFunctionMapperBuilder;
import com.indeed.proctor.common.el.MulticontextReadOnlyVariableMapper;
import com.indeed.shaded.javax.el7.ArrayELResolver;
import com.indeed.shaded.javax.el7.BeanELResolver;
import com.indeed.shaded.javax.el7.CompositeELResolver;
import com.indeed.shaded.javax.el7.ELContext;
import com.indeed.shaded.javax.el7.ELResolver;
import com.indeed.shaded.javax.el7.ExpressionFactory;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.shaded.javax.el7.ListELResolver;
import com.indeed.shaded.javax.el7.MapELResolver;
import com.indeed.shaded.javax.el7.ValueExpression;
import com.indeed.shaded.javax.el7.VariableMapper;
import com.indeed.shaded.org.apache.el7.ExpressionFactoryImpl;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RuleEvaluator {
    private static final Logger LOGGER = LogManager.getLogger(RuleEvaluator.class);
    static final FunctionMapper FUNCTION_MAPPER = RuleEvaluator.defaultFunctionMapperBuilder().build();
    static final ExpressionFactory EXPRESSION_FACTORY = new ExpressionFactoryImpl();
    @Nonnull
    final ExpressionFactory expressionFactory;
    @Nonnull
    final CompositeELResolver elResolver;
    @Nonnull
    private final Map<String, ValueExpression> testConstants;
    @Nonnull
    private final FunctionMapper functionMapper;

    RuleEvaluator(@Nonnull ExpressionFactory expressionFactory, @Nonnull FunctionMapper functionMapper, @Nonnull Map<String, Object> testConstantsMap) {
        this.expressionFactory = expressionFactory;
        this.functionMapper = functionMapper;
        this.elResolver = RuleEvaluator.constructStandardElResolver();
        this.testConstants = ProctorUtils.convertToValueExpressionMap(expressionFactory, testConstantsMap);
    }

    public static RuleEvaluator createDefaultRuleEvaluator(Map<String, Object> testConstantsMap) {
        return new RuleEvaluator(EXPRESSION_FACTORY, FUNCTION_MAPPER, testConstantsMap);
    }

    @Nonnull
    private static CompositeELResolver constructStandardElResolver() {
        CompositeELResolver elResolver = new CompositeELResolver();
        elResolver.add(new ArrayELResolver());
        elResolver.add(new ListELResolver());
        elResolver.add(new MapELResolver());
        elResolver.add(new BeanELResolver());
        return elResolver;
    }

    public static LibraryFunctionMapperBuilder defaultFunctionMapperBuilder() {
        LibraryFunctionMapperBuilder builder = new LibraryFunctionMapperBuilder().add("indeed", ProctorRuleFunctions.class).add("fn", LegacyTaglibFunctions.class).add("proctor", ProctorRuleFunctions.class);
        return builder;
    }

    @Nonnull
    ELContext createElContext(@Nonnull Map<String, Object> values) {
        Map<String, ValueExpression> localContext = ProctorUtils.convertToValueExpressionMap(this.expressionFactory, values);
        MulticontextReadOnlyVariableMapper variableMapper = new MulticontextReadOnlyVariableMapper(this.testConstants, localContext);
        return this.createELContext(variableMapper);
    }

    @Nonnull
    ELContext createELContext(final @Nonnull VariableMapper variableMapper) {
        return new ELContext(){

            @Override
            @Nonnull
            public ELResolver getELResolver() {
                return RuleEvaluator.this.elResolver;
            }

            @Override
            @Nonnull
            public FunctionMapper getFunctionMapper() {
                return RuleEvaluator.this.functionMapper;
            }

            @Override
            @Nonnull
            public VariableMapper getVariableMapper() {
                return variableMapper;
            }
        };
    }

    public boolean evaluateBooleanRule(String rule, @Nonnull Map<String, Object> values) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)rule)) {
            return true;
        }
        if (!rule.startsWith("${") || !rule.endsWith("}")) {
            LOGGER.error("Invalid rule '" + rule + "'");
            return false;
        }
        String bareRule = ProctorUtils.removeElExpressionBraces(rule);
        if (StringUtils.isBlank((CharSequence)bareRule) || "true".equalsIgnoreCase(bareRule)) {
            return true;
        }
        if ("false".equalsIgnoreCase(bareRule)) {
            return false;
        }
        ELContext elContext = this.createElContext(values);
        ValueExpression ve = this.expressionFactory.createValueExpression(elContext, rule, Boolean.TYPE);
        RuleEvaluator.checkRuleIsBooleanType(rule, elContext, ve);
        Object result = ve.getValue(elContext);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new IllegalArgumentException("Received non-boolean return value: " + (result == null ? "null" : result.getClass().getCanonicalName()) + " from rule " + rule);
    }

    static void checkRuleIsBooleanType(String rule, ELContext elContext, ValueExpression ve) {
        Class type = ve.getType(elContext);
        if (ClassUtils.isPrimitiveWrapper(type)) {
            type = ClassUtils.wrapperToPrimitive(type);
        }
        if (type != null && type != Boolean.TYPE) {
            throw new IllegalArgumentException("Received non-boolean return value: " + type + " from rule " + rule);
        }
    }

    @CheckForNull
    @Deprecated
    public Object evaluateRule(String rule, Map<String, Object> values, Class expectedType) {
        ELContext elContext = this.createElContext(values);
        ValueExpression ve = this.expressionFactory.createValueExpression(elContext, rule, expectedType);
        return ve.getValue(elContext);
    }
}

