/*
 * Decompiled with CFR 0.152.
 */
package com.indeed.proctor.common.el;

import com.google.common.collect.ImmutableSet;
import com.indeed.proctor.common.RuleEvaluator;
import com.indeed.proctor.common.el.LibraryFunctionMapper;
import com.indeed.shaded.javax.el7.CompositeELResolver;
import com.indeed.shaded.javax.el7.ELContext;
import com.indeed.shaded.javax.el7.ELResolver;
import com.indeed.shaded.javax.el7.ExpressionFactory;
import com.indeed.shaded.javax.el7.FunctionMapper;
import com.indeed.shaded.javax.el7.ValueExpression;
import com.indeed.shaded.javax.el7.VariableMapper;
import java.util.HashSet;
import java.util.Set;

public class RuleAnalyzer {
    public static Set<String> getReferencedVariables(String elString) {
        final NameGatheringVariableMapper variableMapper = new NameGatheringVariableMapper();
        final CompositeELResolver elResolver = new CompositeELResolver();
        final LibraryFunctionMapper functionMapper = RuleEvaluator.defaultFunctionMapperBuilder().build();
        ExpressionFactory.newInstance().createValueExpression(new ELContext(){

            @Override
            public ELResolver getELResolver() {
                return elResolver;
            }

            @Override
            public FunctionMapper getFunctionMapper() {
                return functionMapper;
            }

            @Override
            public VariableMapper getVariableMapper() {
                return variableMapper;
            }
        }, elString, Void.class);
        return variableMapper.getGatheredVariables();
    }

    private static class NameGatheringVariableMapper
    extends VariableMapper {
        private final Set<String> variablesReferenced = new HashSet<String>();

        private NameGatheringVariableMapper() {
        }

        @Override
        public ValueExpression resolveVariable(String variable) {
            this.variablesReferenced.add(variable);
            return null;
        }

        @Override
        public ValueExpression setVariable(String variable, ValueExpression expression) {
            throw new UnsupportedOperationException();
        }

        private Set<String> getGatheredVariables() {
            return ImmutableSet.copyOf(this.variablesReferenced);
        }
    }
}

