/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MultiHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extensions {
    private static LogProvider ourLogger = new SimpleLogProvider();
    public static final ExtensionPointName<AreaListener> AREA_LISTENER_EXTENSION_POINT = new ExtensionPointName("com.intellij.arealistener");
    private static final Map<AreaInstance, ExtensionsAreaImpl> ourAreaInstance2area = new HashMap<AreaInstance, ExtensionsAreaImpl>();
    private static final MultiHashMap ourAreaClass2instances = new MultiHashMap();
    private static final Map<AreaInstance, String> ourAreaInstance2class = new HashMap<AreaInstance, String>();
    private static final Map<String, AreaClassConfiguration> ourAreaClass2Configuration = new HashMap<String, AreaClassConfiguration>();

    private static ExtensionsAreaImpl createRootArea() {
        ExtensionsAreaImpl rootArea = new ExtensionsAreaImpl(null, null, null, ourLogger);
        rootArea.registerExtensionPoint(AREA_LISTENER_EXTENSION_POINT.getName(), AreaListener.class.getName());
        ourAreaInstance2area.put(null, rootArea);
        return rootArea;
    }

    private Extensions() {
    }

    public static ExtensionsArea getRootArea() {
        return Extensions.getArea(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static ExtensionsArea getArea(@Nullable AreaInstance areaInstance) {
        if (!ourAreaInstance2area.containsKey(areaInstance)) {
            throw new IllegalArgumentException("No area instantiated for: " + areaInstance);
        }
        ExtensionsArea extensionsArea = ourAreaInstance2area.get(areaInstance);
        if (extensionsArea == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/Extensions.getArea must not return null");
        }
        return extensionsArea;
    }

    public static void cleanRootArea(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.cleanRootArea must not be null");
        }
        final ExtensionsAreaImpl oldRootArea = (ExtensionsAreaImpl)Extensions.getRootArea();
        oldRootArea.dropCaches();
        final ExtensionsAreaImpl newArea = Extensions.createRootArea();
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                newArea.dropCaches();
                ourAreaInstance2area.put(null, oldRootArea);
            }
        });
    }

    public static Object[] getExtensions(@NonNls String extensionPointName) {
        return Extensions.getExtensions(extensionPointName, null);
    }

    public static <T> T[] getExtensions(ExtensionPointName<T> extensionPointName) {
        return Extensions.getExtensions(extensionPointName.getName(), null);
    }

    public static <T> T[] getExtensions(ExtensionPointName<T> extensionPointName, AreaInstance areaInstance) {
        return Extensions.getExtensions(extensionPointName.getName(), areaInstance);
    }

    public static Object[] getExtensions(String extensionPointName, AreaInstance areaInstance) {
        ExtensionsArea area = Extensions.getArea(areaInstance);
        ExtensionPoint extensionPoint = area.getExtensionPoint(extensionPointName);
        assert (extensionPoint != null) : "Unable to get extension point " + extensionPoint + " for " + areaInstance;
        return extensionPoint.getExtensions();
    }

    public static void instantiateArea(@NonNls @NotNull String areaClass, AreaInstance areaInstance, AreaInstance parentAreaInstance) {
        AreaListener[] listeners;
        if (areaClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.instantiateArea must not be null");
        }
        if (!ourAreaClass2Configuration.containsKey(areaClass)) {
            throw new IllegalArgumentException("Area class is not registered: " + areaClass);
        }
        if (ourAreaInstance2area.containsKey(areaInstance)) {
            throw new IllegalArgumentException("Area already instantiated for: " + areaInstance);
        }
        ExtensionsArea parentArea = Extensions.getArea(parentAreaInstance);
        AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
        if (!Extensions.equals(parentArea.getAreaClass(), configuration.getParentClassName())) {
            throw new IllegalArgumentException("Wrong parent area. Expected class: " + configuration.getParentClassName() + " actual class: " + parentArea.getAreaClass());
        }
        ExtensionsAreaImpl area = new ExtensionsAreaImpl(areaClass, areaInstance, (PicoContainer)parentArea.getPicoContainer(), ourLogger);
        ourAreaInstance2area.put(areaInstance, area);
        ourAreaClass2instances.put((Object)areaClass, (Object)areaInstance);
        ourAreaInstance2class.put(areaInstance, areaClass);
        for (AreaListener listener : listeners = Extensions.getAreaListeners()) {
            listener.areaCreated(areaClass, areaInstance);
        }
    }

    private static AreaListener[] getAreaListeners() {
        return Extensions.getRootArea().getExtensionPoint(AREA_LISTENER_EXTENSION_POINT).getExtensions();
    }

    public static void registerAreaClass(@NonNls String areaClass, @NonNls String parentAreaClass) {
        if (ourAreaClass2Configuration.containsKey(areaClass)) {
            AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
            if (!Extensions.equals(configuration.getParentClassName(), parentAreaClass)) {
                throw new RuntimeException("Area class already registered: " + areaClass, ourAreaClass2Configuration.get(areaClass).getCreationPoint());
            }
            return;
        }
        AreaClassConfiguration configuration = new AreaClassConfiguration(areaClass, parentAreaClass);
        ourAreaClass2Configuration.put(areaClass, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeArea(@NotNull AreaInstance areaInstance) {
        if (areaInstance == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/Extensions.disposeArea must not be null");
        }
        assert (ourAreaInstance2area.containsKey(areaInstance));
        AreaListener[] listeners = Extensions.getAreaListeners();
        String areaClass = ourAreaInstance2class.get(areaInstance);
        if (areaClass == null) {
            throw new IllegalArgumentException("Area class is null (area never instantiated?). Instance: " + areaInstance);
        }
        try {
            for (AreaListener listener : listeners) {
                listener.areaDisposing(areaClass, areaInstance);
            }
        }
        finally {
            ourAreaInstance2area.remove(areaInstance);
            ourAreaClass2instances.remove((Object)ourAreaInstance2class.remove(areaInstance), (Object)areaInstance);
            ourAreaInstance2class.remove(areaInstance);
        }
    }

    public static AreaInstance[] getAllAreas(String areaClass) {
        Collection instances = (Collection)ourAreaClass2instances.get((Object)areaClass);
        return instances != null ? instances.toArray(new AreaInstance[instances.size()]) : new AreaInstance[]{};
    }

    private static boolean equals(Object object1, Object object2) {
        return object1 == object2 || object1 != null && object2 != null && object1.equals(object2);
    }

    public static void setLogProvider(LogProvider logProvider) {
        ourLogger = logProvider;
    }

    static {
        Extensions.createRootArea();
    }

    public static class SimpleLogProvider
    implements LogProvider {
        public void error(String message) {
            new Throwable(message).printStackTrace();
        }

        public void error(String message, Throwable t) {
            System.err.println(message);
            t.printStackTrace();
        }

        public void error(Throwable t) {
            t.printStackTrace();
        }

        public void warn(String message) {
            System.err.println(message);
        }

        public void warn(String message, Throwable t) {
            System.err.println(message);
            t.printStackTrace();
        }

        public void warn(Throwable t) {
            t.printStackTrace();
        }
    }

    private static class AreaClassConfiguration {
        private String myClassName;
        private String myParentClassName;
        private Throwable myCreationPoint = new Throwable();

        AreaClassConfiguration(String className, String parentClassName) {
            this.myClassName = className;
            this.myParentClassName = parentClassName;
        }

        public Throwable getCreationPoint() {
            return this.myCreationPoint;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public String getParentClassName() {
            return this.myParentClassName;
        }
    }
}

