/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.SmartExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionPointImpl<T>
implements ExtensionPoint<T> {
    private final LogProvider myLogger;
    private final AreaInstance myArea;
    private final String myName;
    private final String myBeanClassName;
    private final List<T> myExtensions = new ArrayList<T>();
    private final ExtensionsAreaImpl myOwner;
    private final PluginDescriptor myDescriptor;
    private final Set<ExtensionComponentAdapter> myExtensionAdapters = new LinkedHashSet<ExtensionComponentAdapter>();
    private final Set<ExtensionPointListener<T>> myEPListeners = new LinkedHashSet<ExtensionPointListener<T>>();
    private List<ExtensionComponentAdapter> myLoadedAdapters = new CopyOnWriteArrayList<ExtensionComponentAdapter>();
    private SoftReference<T[]> myExtensionsCache;
    private Class myExtensionClass;

    public ExtensionPointImpl(String name, String beanClassName, ExtensionsAreaImpl owner, AreaInstance area, LogProvider logger, PluginDescriptor descriptor) {
        this.myName = name;
        this.myBeanClassName = beanClassName;
        this.myOwner = owner;
        this.myArea = area;
        this.myLogger = logger;
        this.myDescriptor = descriptor;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public AreaInstance getArea() {
        return this.myArea;
    }

    @Override
    public String getBeanClassName() {
        return this.myBeanClassName;
    }

    @Override
    public void registerExtension(T extension) {
        this.registerExtension(extension, LoadingOrder.ANY);
    }

    public PluginDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public synchronized void registerExtension(T extension, LoadingOrder order) {
        assert (extension != null) : "Extension cannot be null";
        assert (this.myExtensions.size() == this.myLoadedAdapters.size());
        if (LoadingOrder.ANY == order) {
            ExtensionComponentAdapter lastAdapter;
            int index = this.myLoadedAdapters.size();
            if (this.myLoadedAdapters.size() > 0 && (lastAdapter = this.myLoadedAdapters.get(this.myLoadedAdapters.size() - 1)).getOrder() == LoadingOrder.LAST) {
                --index;
            }
            this.internalRegisterExtension(extension, new ObjectComponentAdapter(extension, order), index, true);
        } else {
            this.myExtensionAdapters.add(new ObjectComponentAdapter(extension, order));
            this.processAdapters();
        }
    }

    private void internalRegisterExtension(T extension, ExtensionComponentAdapter adapter, int index, boolean runNotifications) {
        this.myExtensionsCache = null;
        if (this.myExtensions.contains(extension)) {
            this.myLogger.error("Extension was already added: " + extension);
        } else {
            this.myExtensions.add(index, extension);
            this.myLoadedAdapters.add(index, adapter);
            if (runNotifications) {
                if (extension instanceof Extension) {
                    Extension o = (Extension)extension;
                    try {
                        o.extensionAdded(this);
                    }
                    catch (Throwable e) {
                        this.myLogger.error(e);
                    }
                }
                this.notifyListenersOnAdd(extension, adapter.getPluginDescriptor());
            }
        }
    }

    private void notifyListenersOnAdd(T extension, PluginDescriptor pluginDescriptor) {
        for (ExtensionPointListener<T> listener : this.getListenersCopy()) {
            try {
                listener.extensionAdded(extension, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    private ExtensionPointListener<T>[] getListenersCopy() {
        return this.myEPListeners.toArray(new ExtensionPointListener[this.myEPListeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        void var1_5;
        Object var1_1 = null;
        this.processAdapters();
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            void var1_3;
            if (this.myExtensionsCache != null) {
                T[] TArray = this.myExtensionsCache.get();
            }
            if (var1_3 == null) {
                Object[] objectArray = this.myExtensions.toArray((Object[])Array.newInstance(this.getExtensionClass(), this.myExtensions.size()));
                this.myExtensionsCache = new SoftReference<Object[]>(objectArray);
            }
        }
        void v0 = var1_5;
        if (v0 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionPointImpl.getExtensions must not return null");
        }
        return v0;
    }

    private synchronized void processAdapters() {
        if (this.myExtensionAdapters.size() > 0) {
            ArrayList<ExtensionComponentAdapter> allAdapters = new ArrayList<ExtensionComponentAdapter>(this.myExtensionAdapters.size() + this.myLoadedAdapters.size());
            allAdapters.addAll(this.myExtensionAdapters);
            allAdapters.addAll(this.myLoadedAdapters);
            this.myExtensions.clear();
            List<ExtensionComponentAdapter> loadedAdapters = this.myLoadedAdapters;
            this.myLoadedAdapters = new ArrayList<ExtensionComponentAdapter>();
            LoadingOrder.Orderable[] adapters = allAdapters.toArray(new ExtensionComponentAdapter[this.myExtensionAdapters.size()]);
            LoadingOrder.sort(adapters);
            for (int i = 0; i < adapters.length; ++i) {
                LoadingOrder.Orderable adapter = adapters[i];
                Object extension = ((ExtensionComponentAdapter)adapter).getExtension();
                this.internalRegisterExtension(extension, (ExtensionComponentAdapter)adapter, i, !loadedAdapters.contains(adapter));
            }
            this.myExtensionAdapters.clear();
        }
    }

    @Override
    @Nullable
    public T getExtension() {
        T[] extensions = this.getExtensions();
        if (extensions.length == 0) {
            return null;
        }
        return extensions[0];
    }

    @Override
    public synchronized boolean hasExtension(T extension) {
        this.processAdapters();
        return this.myExtensions.contains(extension);
    }

    @Override
    public synchronized void unregisterExtension(T extension) {
        MutablePicoContainer[] pluginContainers;
        assert (extension != null) : "Extension cannot be null";
        int index = this.getExtensionIndex(extension);
        ExtensionComponentAdapter adapter = this.myLoadedAdapters.get(index);
        this.myOwner.getMutablePicoContainer().unregisterComponent(adapter.getComponentKey());
        for (MutablePicoContainer pluginContainer : pluginContainers = this.myOwner.getPluginContainers()) {
            pluginContainer.unregisterComponent(adapter.getComponentKey());
        }
        this.processAdapters();
        this.internalUnregisterExtension(extension, null);
    }

    private int getExtensionIndex(T extension) {
        if (!this.myExtensions.contains(extension)) {
            throw new IllegalArgumentException("Extension to be removed not found: " + extension);
        }
        return this.myExtensions.indexOf(extension);
    }

    private synchronized void internalUnregisterExtension(T extension, PluginDescriptor pluginDescriptor) {
        this.myExtensionsCache = null;
        int index = this.getExtensionIndex(extension);
        this.myExtensions.remove(index);
        this.myLoadedAdapters.remove(index);
        this.notifyListenersOnRemove(extension, pluginDescriptor);
        if (extension instanceof Extension) {
            Extension o = (Extension)extension;
            try {
                o.extensionRemoved(this);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    private void notifyListenersOnRemove(T extensionObject, PluginDescriptor pluginDescriptor) {
        for (ExtensionPointListener<T> listener : this.getListenersCopy()) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                this.myLogger.error(e);
            }
        }
    }

    @Override
    public void addExtensionPointListener(ExtensionPointListener<T> listener) {
        this.processAdapters();
        if (this.myEPListeners.add(listener)) {
            for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters) {
                try {
                    listener.extensionAdded(componentAdapter.getExtension(), componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
        }
    }

    @Override
    public void removeExtensionPointListener(ExtensionPointListener<T> listener) {
        if (this.myEPListeners.contains(listener)) {
            for (ExtensionComponentAdapter componentAdapter : this.myLoadedAdapters) {
                try {
                    listener.extensionRemoved(componentAdapter.getExtension(), componentAdapter.getPluginDescriptor());
                }
                catch (Throwable e) {
                    this.myLogger.error(e);
                }
            }
            this.myEPListeners.remove(listener);
        }
    }

    @Override
    public synchronized void reset() {
        this.myOwner.removeAllComponents(this.myExtensionAdapters);
        this.myExtensionAdapters.clear();
        for (T extension : this.getExtensions()) {
            this.unregisterExtension(extension);
        }
    }

    @Override
    public Class getExtensionClass() {
        if (this.myExtensionClass == null) {
            try {
                this.myExtensionClass = this.myDescriptor.getPluginClassLoader() == null ? Class.forName(this.myBeanClassName) : Class.forName(this.myBeanClassName, true, this.myDescriptor.getPluginClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.myExtensionClass = Object.class;
            }
        }
        return this.myExtensionClass;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void registerExtensionAdapter(ExtensionComponentAdapter adapter) {
        this.myExtensionAdapters.add(adapter);
    }

    public synchronized boolean unregisterComponentAdapter(ExtensionComponentAdapter componentAdapter) {
        if (this.myExtensionAdapters.contains(componentAdapter)) {
            this.myExtensionAdapters.remove(componentAdapter);
            return true;
        }
        if (this.myLoadedAdapters.contains(componentAdapter)) {
            MutablePicoContainer[] pluginContainers;
            Object componentKey = componentAdapter.getComponentKey();
            this.myOwner.getMutablePicoContainer().unregisterComponent(componentKey);
            for (MutablePicoContainer pluginContainer : pluginContainers = this.myOwner.getPluginContainers()) {
                pluginContainer.unregisterComponent(componentKey);
            }
            this.internalUnregisterExtension(componentAdapter.getExtension(), componentAdapter.getPluginDescriptor());
            return true;
        }
        return false;
    }

    final void dropCaches() {
        for (ExtensionPointListener<T> listener : this.getListenersCopy()) {
            if (!(listener instanceof SmartExtensionPoint)) continue;
            ((SmartExtensionPoint)listener).dropCache();
        }
    }

    private static class ObjectComponentAdapter
    extends ExtensionComponentAdapter {
        private Object myExtension;
        private LoadingOrder myLoadingOrder;

        public ObjectComponentAdapter(Object extension, LoadingOrder loadingOrder) {
            super(Object.class.getName(), null, null, null, false);
            this.myExtension = extension;
            this.myLoadingOrder = loadingOrder;
        }

        public Object getExtension() {
            return this.myExtension;
        }

        public LoadingOrder getOrder() {
            return this.myLoadingOrder;
        }

        @Nullable
        public String getOrderId() {
            return null;
        }

        @NonNls
        public Element getDescribingElement() {
            return new Element("RuntimeExtension: " + this.myExtension);
        }
    }
}

