/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout;

import com.itextpdf.html2pdf.attach.impl.layout.BodyHtmlStylesContainer;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocumentRenderer;
import com.itextpdf.html2pdf.attach.impl.layout.PageContextProcessor;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEvent;
import com.itextpdf.kernel.pdf.event.AbstractPdfDocumentEventHandler;
import com.itextpdf.kernel.pdf.event.PdfDocumentEvent;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.properties.UnitValue;
import java.util.HashMap;
import java.util.Map;

class HtmlBodyStylesApplierHandler
extends AbstractPdfDocumentEventHandler {
    private final HtmlDocumentRenderer htmlDocumentRenderer;
    private final Map<Integer, PageStylesProperties> pageStylesPropertiesMap;
    private PdfCanvas pdfCanvas;

    public HtmlBodyStylesApplierHandler(HtmlDocumentRenderer htmlDocumentRenderer, Map<Integer, PageStylesProperties> pageStylesPropertiesMap) {
        this.htmlDocumentRenderer = htmlDocumentRenderer;
        this.pageStylesPropertiesMap = pageStylesPropertiesMap;
    }

    public void onAcceptedEvent(AbstractPdfDocumentEvent event) {
        if (!(event instanceof PdfDocumentEvent)) {
            return;
        }
        PdfPage page = ((PdfDocumentEvent)event).getPage();
        int pageNumber = event.getDocument().getPageNumber(page);
        this.processPage(page, pageNumber);
    }

    void processPage(PdfPage page, int pageNumber) {
        PageStylesProperties pageProperties = this.pageStylesPropertiesMap.get(pageNumber);
        if (pageProperties == null) {
            return;
        }
        PageContextProcessor contextProcessor = this.htmlDocumentRenderer.getPageProcessor(pageNumber);
        this.pdfCanvas = contextProcessor.drawPageBackground(page);
        this.applyHtmlBodyStyles(page, contextProcessor.computeLayoutMargins(), pageProperties.styles, pageNumber);
        this.pdfCanvas = null;
    }

    private void applyHtmlBodyStyles(PdfPage page, float[] margins, BodyHtmlStylesContainer[] styles, int pageNumber) {
        int firstBackground = this.applyFirstBackground(page, margins, styles, pageNumber);
        boolean htmlHasBackground = false;
        for (int i = 0; i < 2; ++i) {
            if (styles[i] == null) continue;
            if (i == 1) {
                boolean bl = htmlHasBackground = styles[0] != null && (styles[0].hasOwnProperty(6) || styles[0].hasOwnProperty(90));
            }
            if (styles[i].hasContentToDraw()) {
                this.drawSimulatedDiv(page, styles[i].properties, margins, firstBackground != i, pageNumber, htmlHasBackground);
            }
            for (int j = 0; j < 4; ++j) {
                int n = j;
                margins[n] = margins[n] + styles[i].getTotalWidth()[j];
            }
        }
    }

    private int applyFirstBackground(PdfPage page, float[] margins, BodyHtmlStylesContainer[] styles, int pageNumber) {
        int firstBackground = -1;
        if (styles[0] != null && (styles[0].getOwnProperty(6) != null || styles[0].getOwnProperty(90) != null)) {
            firstBackground = 0;
        } else if (styles[1] != null && (styles[1].getOwnProperty(6) != null || styles[1].getOwnProperty(90) != null)) {
            firstBackground = 1;
        }
        if (firstBackground != -1) {
            HashMap<Integer, Object> background = new HashMap<Integer, Object>();
            background.put(6, styles[firstBackground].getProperty(6));
            background.put(90, styles[firstBackground].getProperty(90));
            this.drawSimulatedDiv(page, background, margins, true, pageNumber, false);
        }
        return firstBackground;
    }

    private void drawSimulatedDiv(PdfPage page, Map<Integer, Object> styles, float[] margins, boolean drawBackground, int pageNumber, boolean recalculateBodyAreaForContentSize) {
        Div pageBordersSimulation = new Div().setFillAvailableArea(true);
        for (Map.Entry<Integer, Object> entry : styles.entrySet()) {
            if ((entry.getKey() == 6 || entry.getKey() == 90) && !drawBackground) continue;
            pageBordersSimulation.setProperty(entry.getKey().intValue(), entry.getValue());
        }
        pageBordersSimulation.getAccessibilityProperties().setRole("Artifact");
        Rectangle backgroundArea = new Rectangle(page.getTrimBox()).applyMargins(margins[0], margins[1], margins[2], margins[3], false);
        if (recalculateBodyAreaForContentSize) {
            if (this.pageStylesPropertiesMap.get((Object)Integer.valueOf((int)pageNumber)).lowestAndHighest == null) {
                return;
            }
            LowestAndHighest lowestAndHighest = this.pageStylesPropertiesMap.get((Object)Integer.valueOf((int)pageNumber)).lowestAndHighest;
            this.recalculateBackgroundAreaForBody(backgroundArea, pageBordersSimulation, lowestAndHighest);
        }
        if (this.pdfCanvas == null) {
            this.pdfCanvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), page.getDocument());
        }
        Canvas canvas = new Canvas(this.pdfCanvas, backgroundArea);
        canvas.enableAutoTagging(page);
        canvas.add((IBlockElement)pageBordersSimulation);
        canvas.close();
    }

    private void recalculateBackgroundAreaForBody(Rectangle backgroundArea, Div pageBordersSimulation, LowestAndHighest lowestAndHighest) {
        float newHighest;
        UnitValue marginTop = (UnitValue)pageBordersSimulation.getOwnProperty(46);
        UnitValue marginBottom = (UnitValue)pageBordersSimulation.getOwnProperty(43);
        float marginTopWidth = marginTop == null ? 0.0f : marginTop.getValue();
        float marginBottomWidth = marginBottom == null ? 0.0f : marginBottom.getValue();
        Border borderTop = (Border)pageBordersSimulation.getOwnProperty(13);
        Border borderBottom = (Border)pageBordersSimulation.getOwnProperty(10);
        float borderTopWidth = borderTop == null ? 0.0f : borderTop.getWidth();
        float borderBottomWidth = borderBottom == null ? 0.0f : borderBottom.getWidth();
        UnitValue paddingTop = (UnitValue)pageBordersSimulation.getOwnProperty(50);
        UnitValue paddingBottom = (UnitValue)pageBordersSimulation.getOwnProperty(47);
        float paddingTopWidth = paddingTop == null ? 0.0f : paddingTop.getValue();
        float paddingBottomWidth = paddingBottom == null ? 0.0f : paddingBottom.getValue();
        float oldHighest = backgroundArea.getY() + backgroundArea.getHeight();
        if (lowestAndHighest.lowest >= backgroundArea.getY()) {
            backgroundArea.setY(lowestAndHighest.lowest - paddingBottomWidth - borderBottomWidth - marginBottomWidth);
        }
        if ((newHighest = lowestAndHighest.highest - lowestAndHighest.lowest + paddingTopWidth + paddingBottomWidth + borderTopWidth + borderBottomWidth + marginTopWidth + marginBottomWidth + backgroundArea.getY()) <= oldHighest) {
            backgroundArea.setHeight(newHighest - backgroundArea.getY());
        }
    }

    static class PageStylesProperties {
        BodyHtmlStylesContainer[] styles;
        LowestAndHighest lowestAndHighest;

        public PageStylesProperties(BodyHtmlStylesContainer[] styles) {
            this.styles = styles;
        }
    }

    static class LowestAndHighest {
        float lowest;
        float highest;

        public LowestAndHighest(float lowest, float highest) {
            this.lowest = lowest;
            this.highest = highest;
        }
    }
}

