/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArrayDirectIterator;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.utils.ICopyFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PdfArray
extends PdfObject
implements Iterable<PdfObject> {
    protected List<PdfObject> list;

    public PdfArray() {
        this.list = new ArrayList<PdfObject>();
    }

    public PdfArray(PdfObject obj) {
        this();
        this.list.add(obj);
    }

    public PdfArray(PdfArray arr) {
        this();
        this.list.addAll(arr.list);
    }

    public PdfArray(Rectangle rectangle) {
        this.list = new ArrayList<PdfObject>(4);
        this.add(new PdfNumber(rectangle.getLeft()));
        this.add(new PdfNumber(rectangle.getBottom()));
        this.add(new PdfNumber(rectangle.getRight()));
        this.add(new PdfNumber(rectangle.getTop()));
    }

    public PdfArray(List<? extends PdfObject> objects) {
        this.list = new ArrayList<PdfObject>(objects.size());
        for (PdfObject pdfObject : objects) {
            this.add(pdfObject);
        }
    }

    public PdfArray(float[] numbers) {
        this.list = new ArrayList<PdfObject>(numbers.length);
        for (float f : numbers) {
            this.list.add(new PdfNumber(f));
        }
    }

    public PdfArray(double[] numbers) {
        this.list = new ArrayList<PdfObject>(numbers.length);
        for (double f : numbers) {
            this.list.add(new PdfNumber(f));
        }
    }

    public PdfArray(int[] numbers) {
        this.list = new ArrayList<PdfObject>(numbers.length);
        int[] nArray = numbers;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float i2 = nArray[i];
            this.list.add(new PdfNumber(i2));
        }
    }

    public PdfArray(boolean[] values) {
        this.list = new ArrayList<PdfObject>(values.length);
        for (boolean b : values) {
            this.list.add(PdfBoolean.valueOf(b));
        }
    }

    public PdfArray(List<String> strings, boolean asNames) {
        this.list = new ArrayList<PdfObject>(strings.size());
        for (String s : strings) {
            this.list.add(asNames ? new PdfName(s) : new PdfString(s));
        }
    }

    public PdfArray(Iterable<? extends PdfObject> objects, int initialCapacity) {
        this.list = new ArrayList<PdfObject>(initialCapacity);
        for (PdfObject pdfObject : objects) {
            this.add(pdfObject);
        }
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.size() == 0;
    }

    public boolean contains(PdfObject o) {
        if (this.list.contains(o)) {
            return true;
        }
        if (o == null) {
            return false;
        }
        for (PdfObject pdfObject : this) {
            if (!PdfObject.equalContent(o, pdfObject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<PdfObject> iterator() {
        return new PdfArrayDirectIterator(this.list);
    }

    public void add(PdfObject pdfObject) {
        this.list.add(pdfObject);
    }

    public void add(int index, PdfObject element) {
        this.list.add(index, element);
    }

    public PdfObject set(int index, PdfObject element) {
        return this.list.set(index, element);
    }

    public void addAll(Collection<PdfObject> c) {
        this.list.addAll(c);
    }

    public void addAll(PdfArray a) {
        if (a != null) {
            this.addAll(a.list);
        }
    }

    public PdfObject get(int index) {
        return this.get(index, true);
    }

    public void remove(int index) {
        this.list.remove(index);
    }

    public void remove(PdfObject o) {
        if (this.list.remove(o)) {
            return;
        }
        if (o == null) {
            return;
        }
        for (PdfObject pdfObject : this.list) {
            if (!PdfObject.equalContent(o, pdfObject)) continue;
            this.list.remove(pdfObject);
            break;
        }
    }

    public void clear() {
        this.list.clear();
    }

    public int indexOf(PdfObject o) {
        if (o == null) {
            return this.list.indexOf(null);
        }
        int index = 0;
        for (PdfObject pdfObject : this) {
            if (PdfObject.equalContent(o, pdfObject)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public List<PdfObject> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public byte getType() {
        return 1;
    }

    public String toString() {
        String string = "[";
        for (PdfObject entry : this.list) {
            PdfIndirectReference indirectReference = entry.getIndirectReference();
            string = string + (indirectReference == null ? entry.toString() : indirectReference.toString()) + " ";
        }
        string = string + "]";
        return string;
    }

    public PdfObject get(int index, boolean asDirect) {
        if (!asDirect) {
            return this.list.get(index);
        }
        PdfObject obj = this.list.get(index);
        if (obj.getType() == 5) {
            return ((PdfIndirectReference)obj).getRefersTo(true);
        }
        return obj;
    }

    public PdfArray getAsArray(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 1) {
            return (PdfArray)direct;
        }
        return null;
    }

    public PdfDictionary getAsDictionary(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 3) {
            return (PdfDictionary)direct;
        }
        return null;
    }

    public PdfStream getAsStream(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 9) {
            return (PdfStream)direct;
        }
        return null;
    }

    public PdfNumber getAsNumber(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 8) {
            return (PdfNumber)direct;
        }
        return null;
    }

    public PdfName getAsName(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 6) {
            return (PdfName)direct;
        }
        return null;
    }

    public PdfString getAsString(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 10) {
            return (PdfString)direct;
        }
        return null;
    }

    public PdfBoolean getAsBoolean(int index) {
        PdfObject direct = this.get(index, true);
        if (direct != null && direct.getType() == 2) {
            return (PdfBoolean)direct;
        }
        return null;
    }

    public Rectangle toRectangle() {
        try {
            float x1 = this.getAsNumber(0).floatValue();
            float y1 = this.getAsNumber(1).floatValue();
            float x2 = this.getAsNumber(2).floatValue();
            float y2 = this.getAsNumber(3).floatValue();
            float llx = Math.min(x1, x2);
            float lly = Math.min(y1, y2);
            float urx = Math.max(x1, x2);
            float ury = Math.max(y1, y2);
            return new Rectangle(llx, lly, urx - llx, ury - lly);
        }
        catch (Exception e) {
            throw new PdfException("Cannot convert PdfArray to Rectangle.", e, this);
        }
    }

    public float[] toFloatArray() {
        try {
            float[] rslt = new float[this.size()];
            for (int k = 0; k < rslt.length; ++k) {
                rslt[k] = this.getAsNumber(k).floatValue();
            }
            return rslt;
        }
        catch (Exception e) {
            throw new PdfException("Cannot convert PdfArray to an array of floats.", e, this);
        }
    }

    public double[] toDoubleArray() {
        try {
            double[] rslt = new double[this.size()];
            for (int k = 0; k < rslt.length; ++k) {
                rslt[k] = this.getAsNumber(k).doubleValue();
            }
            return rslt;
        }
        catch (Exception e) {
            throw new PdfException("Cannot convert PdfArray to an array of doubles.", e, this);
        }
    }

    public long[] toLongArray() {
        try {
            long[] rslt = new long[this.size()];
            for (int k = 0; k < rslt.length; ++k) {
                rslt[k] = this.getAsNumber(k).longValue();
            }
            return rslt;
        }
        catch (Exception e) {
            throw new PdfException("Cannot convert PdfArray to an array of longs.", e, this);
        }
    }

    public int[] toIntArray() {
        try {
            int[] rslt = new int[this.size()];
            for (int k = 0; k < rslt.length; ++k) {
                rslt[k] = this.getAsNumber(k).intValue();
            }
            return rslt;
        }
        catch (Exception e) {
            throw new PdfException("Cannot convert PdfArray to an array of integers.", e, this);
        }
    }

    public boolean[] toBooleanArray() {
        boolean[] rslt = new boolean[this.size()];
        for (int k = 0; k < rslt.length; ++k) {
            PdfBoolean tmp = this.getAsBoolean(k);
            if (tmp == null) {
                throw new PdfException("Cannot convert PdfArray to an array of booleans", this);
            }
            rslt[k] = tmp.getValue();
        }
        return rslt;
    }

    @Override
    protected PdfObject newInstance() {
        return new PdfArray();
    }

    @Override
    protected void copyContent(PdfObject from, PdfDocument document, ICopyFilter copyFilter) {
        super.copyContent(from, document, copyFilter);
        PdfArray array = (PdfArray)from;
        for (PdfObject entry : array.list) {
            if (!copyFilter.shouldProcess(this, null, entry)) continue;
            this.add(entry.processCopying(document, false, copyFilter));
        }
    }

    protected void releaseContent() {
        this.list = null;
    }
}

