/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.canvas;

import java.util.ArrayList;
import java.util.List;

final class Bezier {
    private Bezier() {
    }

    static List<double[]> bezierArc(double x1, double y1, double x2, double y2, double startAng, double extent) {
        int Nfrag;
        double fragAngle;
        double tmp;
        if (x1 > x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 > y1) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (Math.abs(extent) <= 90.0) {
            fragAngle = extent;
            Nfrag = 1;
        } else {
            Nfrag = (int)Math.ceil(Math.abs(extent) / 90.0);
            fragAngle = extent / (double)Nfrag;
        }
        double x_cen = (x1 + x2) / 2.0;
        double y_cen = (y1 + y2) / 2.0;
        double rx = (x2 - x1) / 2.0;
        double ry = (y2 - y1) / 2.0;
        double halfAng = fragAngle * Math.PI / 360.0;
        double kappa = Math.abs(1.3333333333333333 * (1.0 - Math.cos(halfAng)) / Math.sin(halfAng));
        ArrayList<double[]> pointList = new ArrayList<double[]>();
        for (int iter = 0; iter < Nfrag; ++iter) {
            double theta0 = (startAng + (double)iter * fragAngle) * Math.PI / 180.0;
            double theta1 = (startAng + (double)(iter + 1) * fragAngle) * Math.PI / 180.0;
            double cos0 = Math.cos(theta0);
            double cos1 = Math.cos(theta1);
            double sin0 = Math.sin(theta0);
            double sin1 = Math.sin(theta1);
            if (fragAngle > 0.0) {
                pointList.add(new double[]{x_cen + rx * cos0, y_cen - ry * sin0, x_cen + rx * (cos0 - kappa * sin0), y_cen - ry * (sin0 + kappa * cos0), x_cen + rx * (cos1 + kappa * sin1), y_cen - ry * (sin1 - kappa * cos1), x_cen + rx * cos1, y_cen - ry * sin1});
                continue;
            }
            pointList.add(new double[]{x_cen + rx * cos0, y_cen - ry * sin0, x_cen + rx * (cos0 + kappa * sin0), y_cen - ry * (sin0 - kappa * cos0), x_cen + rx * (cos1 - kappa * sin1), y_cen - ry * (sin1 + kappa * cos1), x_cen + rx * cos1, y_cen - ry * sin1});
        }
        return pointList;
    }
}

