/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.lotl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.MultiThreadingUtil;
import com.itextpdf.io.resolver.resource.IResourceRetriever;
import com.itextpdf.signatures.validation.SafeCalling;
import com.itextpdf.signatures.validation.TrustedCertificatesStore;
import com.itextpdf.signatures.validation.lotl.CountrySpecificLotl;
import com.itextpdf.signatures.validation.lotl.IServiceContext;
import com.itextpdf.signatures.validation.lotl.LotlFetchingProperties;
import com.itextpdf.signatures.validation.lotl.LotlService;
import com.itextpdf.signatures.validation.lotl.XmlCertificateRetriever;
import com.itextpdf.signatures.validation.lotl.XmlCountryCertificateHandler;
import com.itextpdf.signatures.validation.lotl.XmlCountryRetriever;
import com.itextpdf.signatures.validation.lotl.XmlDefaultCertificateHandler;
import com.itextpdf.signatures.validation.lotl.XmlSignatureValidator;
import com.itextpdf.signatures.validation.report.ReportItem;
import com.itextpdf.signatures.validation.report.ValidationReport;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class CountrySpecificLotlFetcher {
    private final LotlService service;

    public CountrySpecificLotlFetcher(LotlService service) {
        this.service = service;
    }

    public Map<String, Result> getAndValidateCountrySpecificLotlFiles(byte[] lotlXml, LotlService lotlService) {
        XmlCertificateRetriever certificateRetriever = new XmlCertificateRetriever(new XmlDefaultCertificateHandler());
        List<Certificate> lotlTrustedCertificates = certificateRetriever.getCertificates(new ByteArrayInputStream(lotlXml));
        XmlCountryRetriever countryRetriever = new XmlCountryRetriever();
        List<CountrySpecificLotl> countrySpecificLotl = countryRetriever.getAllCountriesLotlFilesLocation(new ByteArrayInputStream(lotlXml), lotlService.getLotlFetchingProperties());
        TrustedCertificatesStore certificatesStore = new TrustedCertificatesStore();
        certificatesStore.addGenerallyTrustedCertificates(lotlTrustedCertificates);
        XmlSignatureValidator validator = lotlService.getXmlSignatureValidator(certificatesStore);
        List<Callable<Result>> tasks = this.getTasks(lotlService, countrySpecificLotl, validator);
        HashMap<String, Result> countrySpecificCacheEntries = new HashMap<String, Result>();
        for (Result result : this.executeTasks(tasks)) {
            countrySpecificCacheEntries.put(result.createUniqueIdentifier(), result);
        }
        return countrySpecificCacheEntries;
    }

    protected List<Result> executeTasks(List<Callable<Result>> tasks) {
        return MultiThreadingUtil.runActionsParallel(tasks, (int)tasks.size());
    }

    private List<Callable<Result>> getTasks(LotlService lotlService, List<CountrySpecificLotl> countrySpecificLotl, XmlSignatureValidator validator) {
        ArrayList<Callable<Result>> tasks = new ArrayList<Callable<Result>>(countrySpecificLotl.size());
        for (CountrySpecificLotl f : countrySpecificLotl) {
            Callable<Result> resultCallable = () -> {
                ValidationReport report = new ValidationReport();
                Result result = SafeCalling.onExceptionLog(() -> new CountryFetcher(this.service.getResourceRetriever(), validator, f, lotlService.getLotlFetchingProperties()).getCountrySpecificLotl(), new Result().setCountrySpecificLotl(f), report, e -> new ReportItem("Lotl validation.", MessageFormatUtil.format((String)"Failed to fetch Lotl for country {0} from {1}. Report {2}", (Object[])new Object[]{f.getSchemeTerritory(), f.getTslLocation(), e.getMessage()}), (Exception)e, ReportItem.ReportItemStatus.INVALID));
                result.getLocalReport().merge(report);
                return result;
            };
            tasks.add(resultCallable);
        }
        return tasks;
    }

    private static final class CountryFetcher {
        static final String COUNTRY_SPECIFIC_LOTL_NOT_VALIDATED = "Country specific Lotl file: {0}, {1} wasn't successfully validated. It will be ignored.";
        static final String COULD_NOT_RESOLVE_URL = "Couldn't resolve {0} url. This TSL Location will be ignored.";
        private final IResourceRetriever resourceRetriever;
        private final XmlSignatureValidator xmlSignatureValidator;
        private final CountrySpecificLotl countrySpecificLotl;
        private final LotlFetchingProperties properties;

        CountryFetcher(IResourceRetriever resourceRetriever, XmlSignatureValidator xmlSignatureValidator, CountrySpecificLotl countrySpecificLotl, LotlFetchingProperties properties) {
            this.resourceRetriever = resourceRetriever;
            this.xmlSignatureValidator = xmlSignatureValidator;
            this.countrySpecificLotl = countrySpecificLotl;
            this.properties = properties;
        }

        public Result getCountrySpecificLotl() {
            Result countryResult = new Result();
            countryResult.setCountrySpecificLotl(this.countrySpecificLotl);
            byte[] countryLotlBytes = SafeCalling.onExceptionLog(() -> this.resourceRetriever.getByteArrayByUrl(new URL(this.countrySpecificLotl.getTslLocation())), null, countryResult.getLocalReport(), e -> new ReportItem("Lotl validation.", MessageFormatUtil.format((String)COULD_NOT_RESOLVE_URL, (Object[])new Object[]{this.countrySpecificLotl.getTslLocation()}), (Exception)e, ReportItem.ReportItemStatus.INVALID));
            if (countryLotlBytes == null) {
                return countryResult;
            }
            ValidationReport localReport = this.xmlSignatureValidator.validate(new ByteArrayInputStream(countryLotlBytes));
            countryResult.setLocalReport(localReport);
            if (localReport.getValidationResult() == ValidationReport.ValidationResult.VALID) {
                XmlCertificateRetriever countryCertificateRetriever = new XmlCertificateRetriever(new XmlCountryCertificateHandler(this.properties.getServiceTypes()));
                countryCertificateRetriever.getCertificates(new ByteArrayInputStream(countryLotlBytes));
                countryResult.getContexts().addAll(countryCertificateRetriever.getServiceContexts());
            } else {
                countryResult.getLocalReport().addReportItem(new ReportItem("Lotl validation.", MessageFormatUtil.format((String)COUNTRY_SPECIFIC_LOTL_NOT_VALIDATED, (Object[])new Object[]{this.countrySpecificLotl.getSchemeTerritory(), this.countrySpecificLotl.getTslLocation()}), ReportItem.ReportItemStatus.INVALID));
            }
            return countryResult;
        }
    }

    public static class Result {
        private ValidationReport localReport = new ValidationReport();
        private List<IServiceContext> contexts = new ArrayList<IServiceContext>();
        private CountrySpecificLotl countrySpecificLotl;

        public ValidationReport getLocalReport() {
            return this.localReport;
        }

        public void setLocalReport(ValidationReport localReport) {
            this.localReport = localReport;
        }

        public List<IServiceContext> getContexts() {
            return this.contexts;
        }

        public void setContexts(List<IServiceContext> contexts) {
            this.contexts = contexts;
        }

        public CountrySpecificLotl getCountrySpecificLotl() {
            return this.countrySpecificLotl;
        }

        public Result setCountrySpecificLotl(CountrySpecificLotl countrySpecificLotl) {
            this.countrySpecificLotl = countrySpecificLotl;
            return this;
        }

        public String createUniqueIdentifier() {
            return this.countrySpecificLotl.getSchemeTerritory() + "_" + this.countrySpecificLotl.getTslLocation();
        }
    }
}

