/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.EllipseSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import com.itextpdf.svg.utils.SvgCssUtils;

public class CircleSvgNodeRenderer
extends EllipseSvgNodeRenderer {
    @Override
    protected boolean setParameters(SvgDrawContext context) {
        this.initCenter(context);
        String r = this.getAttribute("r");
        float percentBaseValue = 0.0f;
        if (CssTypesValidationUtils.isPercentageValue((String)r)) {
            if (context.getCurrentViewPort() == null) {
                throw new SvgProcessingException("Relative value can't be resolved, no viewport is set.");
            }
            percentBaseValue = SvgCoordinateUtils.calculateNormalizedDiagonalLength(context);
        }
        this.ry = this.rx = SvgCssUtils.parseAbsoluteLength(this, r, percentBaseValue, 0.0f, context);
        return this.rx > 0.0f;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        CircleSvgNodeRenderer copy = new CircleSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

