/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.svg.renderers.IBranchSvgNodeRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.utils.SvgTextUtil;
import java.util.Map;

public final class TemplateResolveUtils {
    private TemplateResolveUtils() {
    }

    public static void resolve(IBranchSvgNodeRenderer renderer, SvgDrawContext context) {
        String href = renderer.getAttribute("href");
        if (href == null) {
            href = renderer.getAttribute("xlink:href");
        }
        if (href == null || href.charAt(0) != '#') {
            return;
        }
        String normalizedName = SvgTextUtil.filterReferenceValue(href);
        ISvgNodeRenderer template = context.getNamedObject(normalizedName);
        if (!(template instanceof IBranchSvgNodeRenderer)) {
            return;
        }
        IBranchSvgNodeRenderer namedObject = (IBranchSvgNodeRenderer)template.createDeepCopy();
        TemplateResolveUtils.resolve(namedObject, context);
        if (renderer.getChildren().isEmpty()) {
            for (ISvgNodeRenderer child : namedObject.getChildren()) {
                renderer.addChild(child);
            }
        }
        Map<String, String> referencedAttributes = namedObject.getAttributeMapCopy();
        for (Map.Entry<String, String> entry : referencedAttributes.entrySet()) {
            if (renderer.getAttribute(entry.getKey()) != null) continue;
            renderer.setAttribute(entry.getKey(), entry.getValue());
        }
    }
}

