/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.path.json.config;

import com.jayway.restassured.mapper.factory.DefaultGsonObjectMapperFactory;
import com.jayway.restassured.mapper.factory.DefaultJackson1ObjectMapperFactory;
import com.jayway.restassured.mapper.factory.DefaultJackson2ObjectMapperFactory;
import com.jayway.restassured.mapper.factory.GsonObjectMapperFactory;
import com.jayway.restassured.mapper.factory.Jackson1ObjectMapperFactory;
import com.jayway.restassured.mapper.factory.Jackson2ObjectMapperFactory;
import com.jayway.restassured.path.json.config.JsonParserType;
import com.jayway.restassured.path.json.mapping.JsonPathObjectDeserializer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

public class JsonPathConfig {
    private final NumberReturnType numberReturnType;
    private final JsonPathObjectDeserializer defaultDeserializer;
    private final JsonParserType defaultParserType;
    private final GsonObjectMapperFactory gsonObjectMapperFactory;
    private final Jackson1ObjectMapperFactory jackson1ObjectMapperFactory;
    private final Jackson2ObjectMapperFactory jackson2ObjectMapperFactory;
    private final String charset;

    public JsonPathConfig(JsonPathConfig config) {
        this(config.numberReturnType(), config.defaultParserType(), config.gsonObjectMapperFactory(), config.jackson1ObjectMapperFactory(), config.jackson2ObjectMapperFactory(), config.defaultDeserializer(), config.charset());
    }

    public JsonPathConfig() {
        this(NumberReturnType.FLOAT_AND_DOUBLE, null, new DefaultGsonObjectMapperFactory(), new DefaultJackson1ObjectMapperFactory(), new DefaultJackson2ObjectMapperFactory(), null, JsonPathConfig.defaultCharset());
    }

    public JsonPathConfig(NumberReturnType numberReturnType) {
        this(numberReturnType, null, new DefaultGsonObjectMapperFactory(), new DefaultJackson1ObjectMapperFactory(), new DefaultJackson2ObjectMapperFactory(), null, JsonPathConfig.defaultCharset());
    }

    public JsonPathConfig(String defaultCharset) {
        this(NumberReturnType.FLOAT_AND_DOUBLE, null, new DefaultGsonObjectMapperFactory(), new DefaultJackson1ObjectMapperFactory(), new DefaultJackson2ObjectMapperFactory(), null, defaultCharset);
    }

    private JsonPathConfig(NumberReturnType numberReturnType, JsonParserType parserType, GsonObjectMapperFactory gsonObjectMapperFactory, Jackson1ObjectMapperFactory jackson1ObjectMapperFactory, Jackson2ObjectMapperFactory jackson2ObjectMapperFactory, JsonPathObjectDeserializer defaultDeserializer, String charset) {
        if (numberReturnType == null) {
            throw new IllegalArgumentException("numberReturnType cannot be null");
        }
        if ((charset = StringUtils.trimToNull((String)charset)) == null) {
            throw new IllegalArgumentException("Charset cannot be empty");
        }
        this.charset = charset;
        this.numberReturnType = numberReturnType;
        this.defaultDeserializer = defaultDeserializer;
        this.defaultParserType = parserType;
        this.gsonObjectMapperFactory = gsonObjectMapperFactory;
        this.jackson1ObjectMapperFactory = jackson1ObjectMapperFactory;
        this.jackson2ObjectMapperFactory = jackson2ObjectMapperFactory;
    }

    private static String defaultCharset() {
        return Charset.defaultCharset().name();
    }

    public String charset() {
        return this.charset;
    }

    public JsonPathConfig charset(String charset) {
        return new JsonPathConfig(this.numberReturnType, this.defaultParserType, this.gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, this.defaultDeserializer, charset);
    }

    public NumberReturnType numberReturnType() {
        return this.numberReturnType;
    }

    public JsonPathConfig numberReturnType(NumberReturnType numberReturnType) {
        return new JsonPathConfig(numberReturnType, this.defaultParserType, this.gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, this.defaultDeserializer, this.charset);
    }

    public boolean shouldRepresentJsonNumbersAsBigDecimal() {
        return this.numberReturnType() == NumberReturnType.BIG_DECIMAL;
    }

    public JsonParserType defaultParserType() {
        return this.defaultParserType;
    }

    public boolean hasDefaultParserType() {
        return this.defaultParserType != null;
    }

    public boolean hasCustomGsonObjectMapperFactory() {
        return this.gsonObjectMapperFactory() != null && this.gsonObjectMapperFactory().getClass() != DefaultGsonObjectMapperFactory.class;
    }

    public boolean hasCustomJackson10ObjectMapperFactory() {
        return this.jackson1ObjectMapperFactory() != null && this.jackson1ObjectMapperFactory().getClass() != DefaultJackson1ObjectMapperFactory.class;
    }

    public boolean hasCustomJackson20ObjectMapperFactory() {
        return this.jackson2ObjectMapperFactory() != null && this.jackson2ObjectMapperFactory().getClass() != DefaultJackson2ObjectMapperFactory.class;
    }

    public JsonPathConfig defaultParserType(JsonParserType defaultParserType) {
        return new JsonPathConfig(this.numberReturnType, defaultParserType, this.gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, this.defaultDeserializer, this.charset);
    }

    public JsonPathObjectDeserializer defaultDeserializer() {
        return this.defaultDeserializer;
    }

    public boolean hasDefaultDeserializer() {
        return this.defaultDeserializer != null;
    }

    public JsonPathConfig defaultObjectDeserializer(JsonPathObjectDeserializer defaultObjectDeserializer) {
        return new JsonPathConfig(this.numberReturnType, null, this.gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, defaultObjectDeserializer, this.charset);
    }

    public GsonObjectMapperFactory gsonObjectMapperFactory() {
        return this.gsonObjectMapperFactory;
    }

    public JsonPathConfig gsonObjectMapperFactory(GsonObjectMapperFactory gsonObjectMapperFactory) {
        return new JsonPathConfig(this.numberReturnType, this.defaultParserType, gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, this.defaultDeserializer, this.charset);
    }

    public Jackson1ObjectMapperFactory jackson1ObjectMapperFactory() {
        return this.jackson1ObjectMapperFactory;
    }

    public JsonPathConfig jackson1ObjectMapperFactory(Jackson1ObjectMapperFactory jackson1ObjectMapperFactory) {
        return new JsonPathConfig(this.numberReturnType, this.defaultParserType, this.gsonObjectMapperFactory, jackson1ObjectMapperFactory, this.jackson2ObjectMapperFactory, this.defaultDeserializer, this.charset);
    }

    public Jackson2ObjectMapperFactory jackson2ObjectMapperFactory() {
        return this.jackson2ObjectMapperFactory;
    }

    public JsonPathConfig jackson2ObjectMapperFactory(Jackson2ObjectMapperFactory jackson2ObjectMapperFactory) {
        return new JsonPathConfig(this.numberReturnType, this.defaultParserType, this.gsonObjectMapperFactory, this.jackson1ObjectMapperFactory, jackson2ObjectMapperFactory, this.defaultDeserializer, this.charset);
    }

    public static JsonPathConfig jsonPathConfig() {
        return new JsonPathConfig();
    }

    public JsonPathConfig with() {
        return this;
    }

    public JsonPathConfig and() {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NumberReturnType {
        FLOAT_AND_DOUBLE,
        BIG_DECIMAL,
        DOUBLE;

    }
}

